package flashx.textLayout.elements
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.property.NumberOrPercentOrEnumProperty;
   import flashx.textLayout.property.EnumStringProperty;
   import flash.display.DisplayObject;
   import flash.display.DisplayObjectContainer;
   import flash.display.Loader;
   import flash.display.MovieClip;
   import flash.system.Capabilities;
   import flashx.textLayout.formats.FormatValue;
   import flash.text.engine.TextRotation;
   import flashx.textLayout.formats.Float;
   import flash.text.engine.GraphicElement;
   import flash.display.Sprite;
   import flashx.textLayout.events.ModelChange;
   import flash.events.ErrorEvent;
   import flashx.textLayout.events.StatusChangeEvent;
   import flash.events.Event;
   import flash.events.IOErrorEvent;
   import flash.display.LoaderInfo;
   import flash.net.URLRequest;
   import flash.display.Shape;
   import flash.text.engine.TextLine;
   import flash.text.engine.TextBaseline;
   import flash.text.engine.FontMetrics;
   import flashx.textLayout.compose.TextFlowLine;
   import flash.geom.Rectangle;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.JustificationRule;
   
   use namespace tlf_internal;
   
   public final class InlineGraphicElement extends FlowLeafElement
   {
      
      private static const LOAD_INITIATED:String = "loadInitiated";
      
      private static const OPEN_RECEIVED:String = "openReceived";
      
      private static const LOAD_COMPLETE:String = "loadComplete";
      
      private static const EMBED_LOADED:String = "embedLoaded";
      
      private static const DISPLAY_OBJECT:String = "displayObject";
      
      private static const NULL_GRAPHIC:String = "nullGraphic";
      
      private static var isMac:Boolean = Capabilities.os.search("Mac OS") > -1;
      
      tlf_internal static const heightPropertyDefinition:NumberOrPercentOrEnumProperty = new NumberOrPercentOrEnumProperty("height",FormatValue.AUTO,false,null,0,32000,"0%","1000000%",FormatValue.AUTO);
      
      tlf_internal static const widthPropertyDefinition:NumberOrPercentOrEnumProperty = new NumberOrPercentOrEnumProperty("width",FormatValue.AUTO,false,null,0,32000,"0%","1000000%",FormatValue.AUTO);
      
      tlf_internal static const rotationPropertyDefinition:EnumStringProperty = new EnumStringProperty("rotation",TextRotation.ROTATE_0,false,null,TextRotation.ROTATE_0,TextRotation.ROTATE_90,TextRotation.ROTATE_180,TextRotation.ROTATE_270);
      
      tlf_internal static const floatPropertyDefinition:EnumStringProperty = new EnumStringProperty("float",Float.NONE,false,null,Float.NONE,Float.LEFT,Float.RIGHT);
       
      private var _source:Object;
      
      private var _graphic:DisplayObject;
      
      private var _elementWidth:Number;
      
      private var _elementHeight:Number;
      
      private var _graphicStatus:Object;
      
      private var okToUpdateHeightAndWidth:Boolean;
      
      private var _width;
      
      private var _height;
      
      private var _measuredWidth:Number;
      
      private var _measuredHeight:Number;
      
      private var _float;
      
      public function InlineGraphicElement()
      {
         super();
         this.okToUpdateHeightAndWidth = false;
         this._measuredWidth = 0;
         this._measuredHeight = 0;
         this.internalSetWidth(undefined);
         this.internalSetHeight(undefined);
         this._float = floatPropertyDefinition.defaultValue;
         this._graphicStatus = InlineGraphicElementStatus.LOAD_PENDING;
         setTextLength(1);
         _text = String.fromCharCode(65007);
      }
      
      private static function recursiveShutDownGraphic(graphic:DisplayObject) : void
      {
         var container:DisplayObjectContainer = null;
         var idx:int = 0;
         if(graphic is Loader)
         {
            Loader(graphic).unloadAndStop();
         }
         else if(graphic)
         {
            container = graphic as DisplayObjectContainer;
            if(container)
            {
               for(idx = 0; idx < container.numChildren; idx++)
               {
                  recursiveShutDownGraphic(container.getChildAt(idx));
               }
            }
            if(graphic is MovieClip)
            {
               MovieClip(graphic).stop();
            }
         }
      }
      
      override tlf_internal function createContentElement() : void
      {
         if(_blockElement)
         {
            return;
         }
         computedFormat;
         var graphicElement:GraphicElement = new GraphicElement();
         _blockElement = graphicElement;
         _blockElement.textRotation = String(rotationPropertyDefinition.defaultValue);
         graphicElement.elementHeight = this._float != Float.NONE?Number(0):Number(this.elementHeight);
         graphicElement.elementWidth = this._float != Float.NONE?Number(0):Number(this.elementWidth);
         graphicElement.graphic = this._float != Float.NONE?new Sprite():this.graphic;
         super.createContentElement();
         _text = null;
      }
      
      override tlf_internal function canReleaseContentElement() : Boolean
      {
         return false;
      }
      
      override tlf_internal function releaseContentElement() : void
      {
         if(Boolean(_blockElement == null) || Boolean(!this.canReleaseContentElement()))
         {
            return;
         }
         _text = String.fromCharCode(65007);
         super.releaseContentElement();
      }
      
      private function getGraphicElement() : GraphicElement
      {
         if(!_blockElement)
         {
            this.createContentElement();
         }
         return GraphicElement(_blockElement);
      }
      
      public function get graphic() : DisplayObject
      {
         return this._graphic;
      }
      
      private function setGraphic(value:DisplayObject) : void
      {
         if(_blockElement)
         {
            GraphicElement(_blockElement).graphic = this._float != Float.NONE?new Sprite():value;
         }
         this._graphic = value;
      }
      
      tlf_internal function get elementWidth() : Number
      {
         return this._elementWidth;
      }
      
      tlf_internal function set elementWidth(value:Number) : void
      {
         if(_blockElement)
         {
            GraphicElement(_blockElement).elementWidth = this._float != Float.NONE?Number(0):Number(value);
         }
         this._elementWidth = value;
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength,true,false);
      }
      
      tlf_internal function get elementHeight() : Number
      {
         return this._elementHeight;
      }
      
      tlf_internal function set elementHeight(value:Number) : void
      {
         if(_blockElement)
         {
            GraphicElement(_blockElement).elementHeight = this._float != Float.NONE?Number(0):Number(value);
         }
         this._elementHeight = value;
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength,true,false);
      }
      
      public function get status() : String
      {
         switch(this._graphicStatus)
         {
            case LOAD_INITIATED:
            case OPEN_RECEIVED:
               return InlineGraphicElementStatus.LOADING;
            case LOAD_COMPLETE:
            case EMBED_LOADED:
            case DISPLAY_OBJECT:
            case NULL_GRAPHIC:
               return InlineGraphicElementStatus.READY;
            case InlineGraphicElementStatus.LOAD_PENDING:
            case InlineGraphicElementStatus.SIZE_PENDING:
               return String(this._graphicStatus);
            default:
               return InlineGraphicElementStatus.ERROR;
         }
      }
      
      private function changeGraphicStatus(stat:Object) : void
      {
         var tf:TextFlow = null;
         var oldStatus:String = this.status;
         this._graphicStatus = stat;
         var newStatus:String = this.status;
         if(Boolean(oldStatus != newStatus) || Boolean(stat is ErrorEvent))
         {
            tf = getTextFlow();
            if(tf)
            {
               if(newStatus == InlineGraphicElementStatus.SIZE_PENDING)
               {
                  tf.processAutoSizeImageLoaded(this);
               }
               tf.dispatchEvent(new StatusChangeEvent(StatusChangeEvent.INLINE_GRAPHIC_STATUS_CHANGE,false,false,this,newStatus,stat as ErrorEvent));
            }
         }
      }
      
      public function get width() : *
      {
         return this._width;
      }
      
      public function set width(w:*) : void
      {
         this.internalSetWidth(w);
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
      }
      
      public function get measuredWidth() : Number
      {
         return this._measuredWidth;
      }
      
      public function get actualWidth() : Number
      {
         return this.elementWidth;
      }
      
      private function widthIsComputed() : Boolean
      {
         return this.internalWidth is String;
      }
      
      private function get internalWidth() : Object
      {
         return this._width === undefined?widthPropertyDefinition.defaultValue:this._width;
      }
      
      private function computeWidth() : Number
      {
         var effHeight:Number = NaN;
         if(this.internalWidth == FormatValue.AUTO)
         {
            if(this.internalHeight == FormatValue.AUTO)
            {
               return this._measuredWidth;
            }
            if(Boolean(this._measuredHeight == 0) || Boolean(this._measuredWidth == 0))
            {
               return 0;
            }
            effHeight = !!this.heightIsComputed()?Number(this.computeHeight()):Number(Number(this.internalHeight));
            return effHeight / this._measuredHeight * this._measuredWidth;
         }
         return widthPropertyDefinition.computeActualPropertyValue(this.internalWidth,this._measuredWidth);
      }
      
      private function internalSetWidth(w:*) : void
      {
         this._width = widthPropertyDefinition.setHelper(this.width,w);
         this.elementWidth = !!this.widthIsComputed()?Number(0):Number(Number(this.internalWidth));
         if(Boolean(this.okToUpdateHeightAndWidth) && Boolean(this.graphic))
         {
            if(this.widthIsComputed())
            {
               this.elementWidth = this.computeWidth();
            }
            this.graphic.width = this.elementWidth;
            if(this.internalHeight == FormatValue.AUTO)
            {
               this.elementHeight = this.computeHeight();
               this.graphic.height = this.elementHeight;
            }
         }
      }
      
      public function get height() : *
      {
         return this._height;
      }
      
      public function set height(h:*) : void
      {
         this.internalSetHeight(h);
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
      }
      
      private function get internalHeight() : Object
      {
         return this._height === undefined?heightPropertyDefinition.defaultValue:this._height;
      }
      
      tlf_internal function get float() : *
      {
         return this._float;
      }
      
      tlf_internal function set float(value:*) : *
      {
         var origWasInline:Boolean = false;
         var graphicElement:GraphicElement = null;
         if(value === undefined)
         {
            value = floatPropertyDefinition.defaultValue;
         }
         value = floatPropertyDefinition.setHelper(this.float,value) as String;
         if(this._float != value)
         {
            origWasInline = this._float == Float.NONE;
            this._float = value;
            if(this._float != Float.NONE)
            {
               if(Boolean(origWasInline) && Boolean(_blockElement))
               {
                  graphicElement = GraphicElement(_blockElement);
                  this.setGraphic(graphicElement.graphic);
                  this.elementWidth = graphicElement.elementWidth;
                  this.elementHeight = graphicElement.elementHeight;
               }
            }
            else
            {
               this._graphic.x = 0;
               this._graphic.y = 0;
               this.setGraphic(this._graphic);
               this.elementWidth = this._elementWidth;
               this.elementHeight = this._elementHeight;
            }
            modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
         }
      }
      
      public function get measuredHeight() : Number
      {
         return this._measuredHeight;
      }
      
      public function get actualHeight() : Number
      {
         return this.elementHeight;
      }
      
      private function heightIsComputed() : Boolean
      {
         return this.internalHeight is String;
      }
      
      private function computeHeight() : Number
      {
         var effWidth:Number = NaN;
         if(this.internalHeight == FormatValue.AUTO)
         {
            if(this.internalWidth == FormatValue.AUTO)
            {
               return this._measuredHeight;
            }
            if(Boolean(this._measuredHeight == 0) || Boolean(this._measuredWidth == 0))
            {
               return 0;
            }
            effWidth = !!this.widthIsComputed()?Number(this.computeWidth()):Number(Number(this.internalWidth));
            return effWidth / this._measuredWidth * this._measuredHeight;
         }
         return heightPropertyDefinition.computeActualPropertyValue(this.internalHeight,this._measuredHeight);
      }
      
      private function internalSetHeight(h:*) : void
      {
         this._height = heightPropertyDefinition.setHelper(this.height,h);
         this.elementHeight = !!this.heightIsComputed()?Number(0):Number(Number(this.internalHeight));
         if(Boolean(this.okToUpdateHeightAndWidth) && Boolean(this.graphic != null))
         {
            if(this.heightIsComputed())
            {
               this.elementHeight = this.computeHeight();
            }
            this.graphic.height = this.elementHeight;
            if(this.internalWidth == FormatValue.AUTO)
            {
               this.elementWidth = this.computeWidth();
               this.graphic.width = this.elementWidth;
            }
         }
      }
      
      private function loadCompleteHandler(e:Event) : void
      {
         this.removeDefaultLoadHandlers();
         this.okToUpdateHeightAndWidth = true;
         var g:DisplayObject = this.graphic;
         this._measuredWidth = g.width;
         this._measuredHeight = g.height;
         if(!this.widthIsComputed())
         {
            g.width = this.elementWidth;
         }
         if(!this.heightIsComputed())
         {
            g.height = this.elementHeight;
         }
         if(e is IOErrorEvent)
         {
            this.changeGraphicStatus(e);
         }
         else if(Boolean(this.widthIsComputed()) || Boolean(this.heightIsComputed()))
         {
            g.visible = false;
            this.changeGraphicStatus(InlineGraphicElementStatus.SIZE_PENDING);
         }
         else
         {
            this.changeGraphicStatus(LOAD_COMPLETE);
         }
      }
      
      private function openHandler(e:Event) : void
      {
         this.changeGraphicStatus(OPEN_RECEIVED);
      }
      
      private function addDefaultLoadHandlers(loader:Loader) : void
      {
         var loaderInfo:LoaderInfo = loader.contentLoaderInfo;
         loaderInfo.addEventListener(Event.OPEN,this.openHandler,false,0,true);
         loaderInfo.addEventListener(Event.COMPLETE,this.loadCompleteHandler,false,0,true);
         loaderInfo.addEventListener(IOErrorEvent.IO_ERROR,this.loadCompleteHandler,false,0,true);
      }
      
      private function removeDefaultLoadHandlers() : void
      {
         var loader:Loader = Loader(this.graphic);
         loader.contentLoaderInfo.removeEventListener(Event.OPEN,this.openHandler);
         loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,this.loadCompleteHandler);
         loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR,this.loadCompleteHandler);
      }
      
      public function get source() : Object
      {
         return this._source;
      }
      
      public function set source(value:Object) : void
      {
         this.stop(true);
         this._source = value;
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
         this.changeGraphicStatus(InlineGraphicElementStatus.LOAD_PENDING);
      }
      
      override tlf_internal function applyDelayedElementUpdate(textFlow:TextFlow, okToUnloadGraphics:Boolean, hasController:Boolean) : void
      {
         var source:Object = null;
         var elem:DisplayObject = null;
         var inlineGraphicResolver:Function = null;
         var loader:Loader = null;
         var myPattern:RegExp = null;
         var src:String = null;
         var pictURLReq:URLRequest = null;
         var cls:Class = null;
         if(this._graphicStatus == InlineGraphicElementStatus.LOAD_PENDING)
         {
            if(hasController)
            {
               source = this._source;
               if(source is String)
               {
                  inlineGraphicResolver = textFlow.configuration.inlineGraphicResolverFunction;
                  if(inlineGraphicResolver != null)
                  {
                     source = inlineGraphicResolver(this);
                  }
               }
               if(Boolean(source is String) || Boolean(source is URLRequest))
               {
                  this.okToUpdateHeightAndWidth = false;
                  loader = new Loader();
                  this.addDefaultLoadHandlers(loader);
                  if(source is String)
                  {
                     myPattern = /\\/g;
                     src = source as String;
                     src = src.replace(myPattern,"/");
                     if(isMac)
                     {
                        pictURLReq = new URLRequest(encodeURI(src));
                     }
                     else
                     {
                        pictURLReq = new URLRequest(src);
                     }
                     loader.load(pictURLReq);
                  }
                  else
                  {
                     loader.load(URLRequest(source));
                  }
                  this.setGraphic(loader);
                  this.changeGraphicStatus(LOAD_INITIATED);
               }
               else if(source is Class)
               {
                  cls = source as Class;
                  elem = DisplayObject(new cls());
                  this.changeGraphicStatus(EMBED_LOADED);
               }
               else if(source is DisplayObject)
               {
                  elem = DisplayObject(source);
                  this.changeGraphicStatus(DISPLAY_OBJECT);
               }
               else
               {
                  elem = new Shape();
                  this.changeGraphicStatus(NULL_GRAPHIC);
               }
               if(this._graphicStatus != LOAD_INITIATED)
               {
                  this.okToUpdateHeightAndWidth = true;
                  this._measuredWidth = Boolean(elem)?Number(elem.width):Number(0);
                  this._measuredHeight = Boolean(elem)?Number(elem.height):Number(0);
                  if(this.widthIsComputed())
                  {
                     if(elem)
                     {
                        elem.width = this.elementWidth = this.computeWidth();
                     }
                     else
                     {
                        this.elementWidth = 0;
                     }
                  }
                  else
                  {
                     elem.width = Number(this.width);
                  }
                  if(this.heightIsComputed())
                  {
                     if(elem)
                     {
                        elem.height = this.elementHeight = this.computeHeight();
                     }
                     else
                     {
                        this.elementHeight = 0;
                     }
                  }
                  else
                  {
                     elem.height = Number(this.height);
                  }
                  this.setGraphic(elem);
               }
            }
         }
         else
         {
            if(this._graphicStatus == InlineGraphicElementStatus.SIZE_PENDING)
            {
               this.updateAutoSizes();
               this.graphic.visible = true;
               this.changeGraphicStatus(LOAD_COMPLETE);
            }
            if(!hasController)
            {
               this.stop(okToUnloadGraphics);
            }
         }
      }
      
      override tlf_internal function updateForMustUseComposer(textFlow:TextFlow) : Boolean
      {
         this.applyDelayedElementUpdate(textFlow,false,true);
         return this.status != InlineGraphicElementStatus.READY;
      }
      
      private function updateAutoSizes() : void
      {
         if(this.widthIsComputed())
         {
            this.elementWidth = this.computeWidth();
            this.graphic.width = this.elementWidth;
         }
         if(this.heightIsComputed())
         {
            this.elementHeight = this.computeHeight();
            this.graphic.height = this.elementHeight;
         }
      }
      
      private function stop(okToUnloadGraphics:Boolean) : Boolean
      {
         if(Boolean(this._graphicStatus == OPEN_RECEIVED) || Boolean(this._graphicStatus == LOAD_INITIATED))
         {
            try
            {
               Loader(this.graphic).close();
            }
            catch(e:Error)
            {
            }
            this.removeDefaultLoadHandlers();
         }
         if(this._graphicStatus != DISPLAY_OBJECT)
         {
            if(okToUnloadGraphics)
            {
               recursiveShutDownGraphic(this.graphic);
               this.setGraphic(null);
            }
            if(this.widthIsComputed())
            {
               this.elementWidth = 0;
            }
            if(this.heightIsComputed())
            {
               this.elementHeight = 0;
            }
            this.changeGraphicStatus(InlineGraphicElementStatus.LOAD_PENDING);
         }
         return true;
      }
      
      override tlf_internal function getEffectiveFontSize() : Number
      {
         if(this.float != Float.NONE)
         {
            return 0;
         }
         var defaultLeading:Number = super.getEffectiveFontSize();
         return Math.max(defaultLeading,this.elementHeight);
      }
      
      tlf_internal function getEffectiveAscent() : Number
      {
         if(this.float != Float.NONE)
         {
            return 0;
         }
         return this.elementHeight + GraphicElement(_blockElement).elementFormat.baselineShift;
      }
      
      tlf_internal function getTypographicAscent(textLine:TextLine) : Number
      {
         var dominantBaselineString:String = null;
         if(this.float != Float.NONE)
         {
            return 0;
         }
         var effectiveHeight:Number = this.elementHeight;
         if(this._computedFormat.dominantBaseline != FormatValue.AUTO)
         {
            dominantBaselineString = this._computedFormat.dominantBaseline;
         }
         else
         {
            dominantBaselineString = this.getParagraph().getEffectiveDominantBaseline();
         }
         var graphicElement:GraphicElement = GraphicElement(_blockElement);
         var alignmentBaseline:String = graphicElement.elementFormat.alignmentBaseline == TextBaseline.USE_DOMINANT_BASELINE?dominantBaselineString:graphicElement.elementFormat.alignmentBaseline;
         var top:Number = 0;
         if(dominantBaselineString == TextBaseline.IDEOGRAPHIC_CENTER)
         {
            top = top + effectiveHeight / 2;
         }
         else if(Boolean(dominantBaselineString == TextBaseline.IDEOGRAPHIC_BOTTOM) || Boolean(dominantBaselineString == TextBaseline.DESCENT) || Boolean(dominantBaselineString == TextBaseline.ROMAN))
         {
            top = top + effectiveHeight;
         }
         top = top + (textLine.getBaselinePosition(TextBaseline.ROMAN) - textLine.getBaselinePosition(alignmentBaseline));
         top = top + graphicElement.elementFormat.baselineShift;
         return top;
      }
      
      override public function shallowCopy(startPos:int = 0, endPos:int = -1) : FlowElement
      {
         if(endPos == -1)
         {
            endPos = textLength;
         }
         var retFlow:InlineGraphicElement = super.shallowCopy(startPos,endPos) as InlineGraphicElement;
         retFlow.source = this.source;
         retFlow.width = this.width;
         retFlow.height = this.height;
         retFlow.float = this.float;
         return retFlow;
      }
      
      override protected function get abstract() : Boolean
      {
         return false;
      }
      
      override tlf_internal function appendElementsForDelayedUpdate(tf:TextFlow) : void
      {
         if(Boolean(this._graphicStatus == InlineGraphicElementStatus.LOAD_PENDING) || Boolean(this._graphicStatus == InlineGraphicElementStatus.SIZE_PENDING) || Boolean(!tf.flowComposer) || Boolean(tf.flowComposer.numControllers == 0))
         {
            tf.appendOneElementForUpdate(this);
         }
      }
      
      override tlf_internal function calculateStrikeThrough(tLine:TextLine, blockProgression:String, metrics:FontMetrics) : Number
      {
         var line:TextFlowLine = null;
         var elemIdx:int = 0;
         if(Boolean(!this.graphic) || Boolean(this.status != InlineGraphicElementStatus.READY))
         {
            return super.calculateStrikeThrough(tLine,blockProgression,metrics);
         }
         var stOffset:Number = 0;
         var myBounds:Rectangle = this.graphic.getBounds(tLine);
         if(blockProgression != BlockProgression.RL)
         {
            stOffset = myBounds.y + this.elementHeight / 2;
         }
         else
         {
            line = tLine.userData as TextFlowLine;
            elemIdx = this.getAbsoluteStart() - line.absoluteStart;
            if(tLine.getAtomTextRotation(elemIdx) != TextRotation.ROTATE_0)
            {
               stOffset = myBounds.x + this.elementHeight / 2;
            }
            else
            {
               stOffset = myBounds.x + this.elementWidth / 2;
            }
         }
         return blockProgression == BlockProgression.TB?Number(stOffset):Number(-stOffset);
      }
      
      override tlf_internal function calculateUnderlineOffset(stOffset:Number, blockProgression:String, metrics:FontMetrics, tLine:TextLine) : Number
      {
         if(Boolean(!this.graphic) || Boolean(this.status != InlineGraphicElementStatus.READY))
         {
            return super.calculateUnderlineOffset(stOffset,blockProgression,metrics,tLine);
         }
         var ulOffset:Number = 0;
         if(blockProgression == BlockProgression.TB)
         {
            ulOffset = this.graphic.getBounds(tLine).bottom;
         }
         else
         {
            ulOffset = this.graphic.getBounds(tLine).right;
         }
         ulOffset = ulOffset + (metrics.underlineOffset + metrics.underlineThickness / 2);
         var para:ParagraphElement = this.getParagraph();
         var justRule:String = para.getEffectiveJustificationRule();
         if(justRule == JustificationRule.EAST_ASIAN)
         {
            ulOffset = ulOffset + 1;
         }
         return ulOffset;
      }
   }
}
