package flashx.textLayout.elements
{
   import flash.text.engine.ContentElement;
   import flashx.textLayout.tlf_internal;
   import flash.text.engine.ElementFormat;
   import flash.text.engine.TextElement;
   import flash.text.engine.FontMetrics;
   import flashx.textLayout.formats.FormatValue;
   import flash.text.engine.TextRotation;
   import flash.text.engine.TextBaseline;
   import flashx.textLayout.utils.LocaleUtil;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.compose.ISWFContext;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flash.text.engine.TypographicCase;
   import flashx.textLayout.formats.TLFTypographicCase;
   import flash.text.engine.FontDescription;
   import flashx.textLayout.compose.FlowComposerBase;
   import flashx.textLayout.formats.BaselineShift;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flash.text.engine.TextLine;
   import flashx.textLayout.compose.TextFlowLine;
   import flashx.textLayout.utils.CharacterUtil;
   import flash.geom.Rectangle;
   import flash.display.Shape;
   import flashx.textLayout.formats.IMEStatus;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.TextDecoration;
   import flashx.textLayout.formats.BackgroundColor;
   import flashx.textLayout.compose.StandardFlowComposer;
   import flash.events.EventDispatcher;
   
   use namespace tlf_internal;
   
   public class FlowLeafElement extends FlowElement
   {
       
      protected var _blockElement:ContentElement;
      
      protected var _text:String;
      
      private var _hasAttachedListeners:Boolean;
      
      public function FlowLeafElement()
      {
         this._hasAttachedListeners = false;
         super();
      }
      
      override tlf_internal function createContentElement() : void
      {
         if(_computedFormat)
         {
            this._blockElement.elementFormat = this.computeElementFormat();
         }
         if(parent)
         {
            parent.insertBlockElement(this,this._blockElement);
         }
      }
      
      override tlf_internal function releaseContentElement() : void
      {
         if(Boolean(!this.canReleaseContentElement()) || Boolean(this._blockElement == null))
         {
            return;
         }
         this._blockElement = null;
         if(_computedFormat)
         {
            _computedFormat = null;
         }
      }
      
      override tlf_internal function canReleaseContentElement() : Boolean
      {
         return !this._hasAttachedListeners;
      }
      
      private function blockElementExists() : Boolean
      {
         return this._blockElement != null;
      }
      
      tlf_internal function getBlockElement() : ContentElement
      {
         if(!this._blockElement)
         {
            this.createContentElement();
         }
         return this._blockElement;
      }
      
      public function get text() : String
      {
         return Boolean(this._blockElement)?this._blockElement.rawText:this._text;
      }
      
      tlf_internal function getElementFormat() : ElementFormat
      {
         if(!this._blockElement)
         {
            this.createContentElement();
         }
         return this._blockElement.elementFormat;
      }
      
      override tlf_internal function setParentAndRelativeStart(newParent:FlowGroupElement, newStart:int) : void
      {
         if(newParent == parent)
         {
            return;
         }
         var hasBlock:Boolean = this._blockElement != null;
         if(Boolean(this._blockElement) && Boolean(parent) && Boolean(parent.hasBlockElement()))
         {
            parent.removeBlockElement(this,this._blockElement);
         }
         if(Boolean(newParent) && Boolean(!newParent.hasBlockElement()) && Boolean(this._blockElement))
         {
            newParent.createContentElement();
         }
         super.setParentAndRelativeStart(newParent,newStart);
         if(parent)
         {
            if(parent.hasBlockElement())
            {
               if(!this._blockElement)
               {
                  this.createContentElement();
               }
               else if(hasBlock)
               {
                  parent.insertBlockElement(this,this._blockElement);
               }
            }
            else if(this._blockElement)
            {
               this.releaseContentElement();
            }
         }
      }
      
      protected function quickInitializeForSplit(sibling:FlowLeafElement, newSpanLength:int, newSpanTextElement:TextElement) : void
      {
         setTextLength(newSpanLength);
         this._blockElement = newSpanTextElement;
         quickCloneTextLayoutFormat(sibling);
         var tf:TextFlow = sibling.getTextFlow();
         if(Boolean(tf == null) || Boolean(tf.formatResolver == null))
         {
            _computedFormat = sibling._computedFormat;
            if(this._blockElement)
            {
               this._blockElement.elementFormat = sibling.getElementFormat();
            }
         }
      }
      
      tlf_internal function addParaTerminator() : void
      {
      }
      
      tlf_internal function removeParaTerminator() : void
      {
      }
      
      public function getNextLeaf(limitElement:FlowGroupElement = null) : FlowLeafElement
      {
         if(!parent)
         {
            return null;
         }
         return parent.getNextLeafHelper(limitElement,this);
      }
      
      public function getPreviousLeaf(limitElement:FlowGroupElement = null) : FlowLeafElement
      {
         if(!parent)
         {
            return null;
         }
         return parent.getPreviousLeafHelper(limitElement,this);
      }
      
      override public function getCharAtPosition(relativePosition:int) : String
      {
         var textValue:String = Boolean(this._blockElement)?this._blockElement.rawText:this._text;
         if(textValue)
         {
            return textValue.charAt(relativePosition);
         }
         return String("");
      }
      
      override tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
         if(this._blockElement)
         {
            this.computedFormat;
         }
      }
      
      public function getComputedFontMetrics() : FontMetrics
      {
         if(!this._blockElement)
         {
            this.createContentElement();
         }
         var ef:ElementFormat = this._blockElement.elementFormat;
         if(!ef)
         {
            return null;
         }
         var tf:TextFlow = getTextFlow();
         if(Boolean(tf) && Boolean(tf.flowComposer) && Boolean(tf.flowComposer.swfContext))
         {
            return tf.flowComposer.swfContext.callInContext(ef.getFontMetrics,ef,null,true);
         }
         return ef.getFontMetrics();
      }
      
      private function resolveDomBaseline() : String
      {
         var para:ParagraphElement = null;
         var domBase:String = _computedFormat.dominantBaseline;
         if(domBase == FormatValue.AUTO)
         {
            if(this.computedFormat.textRotation == TextRotation.ROTATE_270)
            {
               domBase = TextBaseline.IDEOGRAPHIC_CENTER;
            }
            else
            {
               para = getParagraph();
               if(para != null)
               {
                  domBase = para.getEffectiveDominantBaseline();
               }
               else
               {
                  domBase = LocaleUtil.dominantBaseline(_computedFormat.locale);
               }
            }
         }
         return domBase;
      }
      
      private function computeElementFormat() : ElementFormat
      {
         var textFlow:TextFlow = null;
         var flowComposer:IFlowComposer = null;
         var fontMetrics:FontMetrics = null;
         var tf:TextFlow = null;
         var swfContext:ISWFContext = null;
         var format:ElementFormat = new ElementFormat();
         format.alignmentBaseline = _computedFormat.alignmentBaseline;
         format.alpha = Number(_computedFormat.textAlpha);
         format.breakOpportunity = _computedFormat.breakOpportunity;
         format.color = uint(_computedFormat.color);
         format.dominantBaseline = this.resolveDomBaseline();
         format.digitCase = _computedFormat.digitCase;
         format.digitWidth = _computedFormat.digitWidth;
         format.ligatureLevel = _computedFormat.ligatureLevel;
         format.fontSize = Number(_computedFormat.fontSize);
         format.kerning = _computedFormat.kerning;
         format.locale = _computedFormat.locale;
         format.trackingLeft = TextLayoutFormat.trackingLeftProperty.computeActualPropertyValue(_computedFormat.trackingLeft,format.fontSize);
         format.trackingRight = TextLayoutFormat.trackingRightProperty.computeActualPropertyValue(_computedFormat.trackingRight,format.fontSize);
         format.textRotation = _computedFormat.textRotation;
         format.baselineShift = -TextLayoutFormat.baselineShiftProperty.computeActualPropertyValue(_computedFormat.baselineShift,format.fontSize);
         switch(_computedFormat.typographicCase)
         {
            case TLFTypographicCase.LOWERCASE_TO_SMALL_CAPS:
               format.typographicCase = TypographicCase.CAPS_AND_SMALL_CAPS;
               break;
            case TLFTypographicCase.CAPS_TO_SMALL_CAPS:
               format.typographicCase = TypographicCase.SMALL_CAPS;
               break;
            default:
               format.typographicCase = _computedFormat.typographicCase;
         }
         var fd:FontDescription = new FontDescription();
         fd.fontWeight = _computedFormat.fontWeight;
         fd.fontPosture = _computedFormat.fontStyle;
         fd.fontName = _computedFormat.fontFamily;
         fd.renderingMode = _computedFormat.renderingMode;
         fd.cffHinting = _computedFormat.cffHinting;
         if(GlobalSettings.resolveFontLookupFunction != null)
         {
            textFlow = getTextFlow();
            if(textFlow)
            {
               flowComposer = textFlow.flowComposer;
               fd.fontLookup = GlobalSettings.resolveFontLookupFunction(Boolean(flowComposer)?FlowComposerBase.computeBaseSWFContext(flowComposer.swfContext):null,_computedFormat);
            }
            else
            {
               fd.fontLookup = _computedFormat.fontLookup;
            }
         }
         else
         {
            fd.fontLookup = _computedFormat.fontLookup;
         }
         var fontMapper:Function = GlobalSettings.fontMapperFunction;
         if(fontMapper != null)
         {
            fontMapper(fd);
         }
         format.fontDescription = fd;
         if(Boolean(_computedFormat.baselineShift == BaselineShift.SUPERSCRIPT) || Boolean(_computedFormat.baselineShift == BaselineShift.SUBSCRIPT))
         {
            tf = getTextFlow();
            swfContext = Boolean(tf) && Boolean(tf.flowComposer)?tf.flowComposer.swfContext:null;
            if(swfContext)
            {
               fontMetrics = swfContext.callInContext(format.getFontMetrics,format,null,true);
            }
            else
            {
               fontMetrics = format.getFontMetrics();
            }
            if(_computedFormat.baselineShift == BaselineShift.SUPERSCRIPT)
            {
               format.baselineShift = fontMetrics.superscriptOffset * format.fontSize;
               format.fontSize = fontMetrics.superscriptScale * format.fontSize;
            }
            else
            {
               format.baselineShift = fontMetrics.subscriptOffset * format.fontSize;
               format.fontSize = fontMetrics.subscriptScale * format.fontSize;
            }
         }
         return format;
      }
      
      override public function get computedFormat() : ITextLayoutFormat
      {
         if(!_computedFormat)
         {
            _computedFormat = doComputeTextLayoutFormat();
            if(this._blockElement)
            {
               this._blockElement.elementFormat = this.computeElementFormat();
            }
         }
         return _computedFormat;
      }
      
      tlf_internal function getEffectiveFontSize() : Number
      {
         return Number(this.computedFormat.fontSize);
      }
      
      tlf_internal function getSpanBoundsOnLine(textLine:TextLine, blockProgression:String) : Array
      {
         var spanText:String = null;
         var line:TextFlowLine = TextFlowLine(textLine.userData);
         var paraStart:int = line.paragraph.getAbsoluteStart();
         var lineEnd:int = line.absoluteStart + line.textLength - paraStart;
         var spanStart:int = getAbsoluteStart() - paraStart;
         var endPos:int = spanStart + this.text.length;
         var startPos:int = Math.max(spanStart,line.absoluteStart - paraStart);
         if(endPos >= lineEnd)
         {
            endPos = lineEnd;
            spanText = this.text;
            while(Boolean(endPos > startPos) && Boolean(CharacterUtil.isWhitespace(spanText.charCodeAt(endPos - spanStart - 1))))
            {
               endPos--;
            }
         }
         var mainRects:Array = [];
         line.calculateSelectionBounds(textLine,mainRects,startPos,endPos,blockProgression,[line.textHeight,0]);
         return mainRects;
      }
      
      tlf_internal function updateIMEAdornments(line:TextFlowLine, blockProgression:String, imeStatus:String) : void
      {
         var imeLineThickness:int = 0;
         var imeLineColor:uint = 0;
         var imeLineStartX:Number = NaN;
         var imeLineStartY:Number = NaN;
         var imeLineEndX:Number = NaN;
         var imeLineEndY:Number = NaN;
         var spanBounds:Rectangle = null;
         var stOffset:Number = NaN;
         var ulOffset:Number = NaN;
         var selObj:Shape = null;
         var elemIdx:int = 0;
         var tcyParent:TCYElement = null;
         var tcyAdornBounds:Rectangle = null;
         var baseULAdjustment:Number = NaN;
         var tLine:TextLine = line.getTextLine();
         var metrics:FontMetrics = this.getComputedFontMetrics();
         var spanBoundsArray:Array = this.getSpanBoundsOnLine(tLine,blockProgression);
         for(var i:int = 0; i < spanBoundsArray.length; i++)
         {
            imeLineThickness = 1;
            imeLineColor = 0;
            imeLineStartX = 0;
            imeLineStartY = 0;
            imeLineEndX = 0;
            imeLineEndY = 0;
            if(Boolean(imeStatus == IMEStatus.SELECTED_CONVERTED) || Boolean(imeStatus == IMEStatus.SELECTED_RAW))
            {
               imeLineThickness = 2;
            }
            if(Boolean(imeStatus == IMEStatus.SELECTED_RAW) || Boolean(imeStatus == IMEStatus.NOT_SELECTED_RAW) || Boolean(imeStatus == IMEStatus.DEAD_KEY_INPUT_STATE))
            {
               imeLineColor = 10921638;
            }
            spanBounds = spanBoundsArray[i] as Rectangle;
            stOffset = this.calculateStrikeThrough(tLine,blockProgression,metrics);
            ulOffset = this.calculateUnderlineOffset(stOffset,blockProgression,metrics,tLine);
            if(blockProgression != BlockProgression.RL)
            {
               imeLineStartX = spanBounds.topLeft.x + 1;
               imeLineEndX = spanBounds.topLeft.x + spanBounds.width - 1;
               imeLineStartY = ulOffset;
               imeLineEndY = ulOffset;
            }
            else
            {
               elemIdx = this.getAbsoluteStart() - line.absoluteStart;
               imeLineStartY = spanBounds.topLeft.y + 1;
               imeLineEndY = spanBounds.topLeft.y + spanBounds.height - 1;
               if(Boolean(elemIdx < 0) || Boolean(tLine.atomCount <= elemIdx) || Boolean(tLine.getAtomTextRotation(elemIdx) != TextRotation.ROTATE_0))
               {
                  imeLineStartX = ulOffset;
                  imeLineEndX = ulOffset;
               }
               else
               {
                  tcyParent = this.getParentByType(TCYElement) as TCYElement;
                  if(this.getAbsoluteStart() + this.textLength == tcyParent.getAbsoluteStart() + tcyParent.textLength)
                  {
                     tcyAdornBounds = new Rectangle();
                     tcyParent.calculateAdornmentBounds(tcyParent,tLine,blockProgression,tcyAdornBounds);
                     baseULAdjustment = metrics.underlineOffset + metrics.underlineThickness / 2;
                     imeLineStartY = tcyAdornBounds.top + 1;
                     imeLineEndY = tcyAdornBounds.bottom - 1;
                     imeLineStartX = spanBounds.bottomRight.x + baseULAdjustment;
                     imeLineEndX = spanBounds.bottomRight.x + baseULAdjustment;
                  }
               }
            }
            selObj = new Shape();
            selObj.alpha = 1;
            selObj.graphics.beginFill(imeLineColor);
            selObj.graphics.lineStyle(imeLineThickness,imeLineColor,selObj.alpha);
            selObj.graphics.moveTo(imeLineStartX,imeLineStartY);
            selObj.graphics.lineTo(imeLineEndX,imeLineEndY);
            selObj.graphics.endFill();
            tLine.addChild(selObj);
         }
      }
      
      tlf_internal function updateAdornments(line:TextFlowLine, blockProgression:String) : int
      {
         var tLine:TextLine = null;
         var spanBoundsArray:Array = null;
         var i:int = 0;
         if(Boolean(_computedFormat.textDecoration == TextDecoration.UNDERLINE) || Boolean(_computedFormat.lineThrough) || Boolean(_computedFormat.backgroundAlpha > 0) && Boolean(_computedFormat.backgroundColor != BackgroundColor.TRANSPARENT))
         {
            tLine = line.getTextLine(true);
            spanBoundsArray = this.getSpanBoundsOnLine(tLine,blockProgression);
            for(i = 0; i < spanBoundsArray.length; i++)
            {
               this.updateAdornmentsOnBounds(line,tLine,blockProgression,spanBoundsArray[i]);
            }
            return spanBoundsArray.length;
         }
         return 0;
      }
      
      private function updateAdornmentsOnBounds(line:TextFlowLine, tLine:TextLine, blockProgression:String, spanBounds:Rectangle) : void
      {
         var elemIdx:int = 0;
         var tcyParent:TCYElement = null;
         var tcyPara:ParagraphElement = null;
         var lowerLocale:String = null;
         var adornRight:Boolean = false;
         var tcyAdornBounds:Rectangle = null;
         var baseULAdjustment:Number = NaN;
         var xCoor:Number = NaN;
         var tcyMid:Number = NaN;
         var selObj:Shape = new Shape();
         var metrics:FontMetrics = this.getComputedFontMetrics();
         selObj.alpha = Number(_computedFormat.textAlpha);
         selObj.graphics.beginFill(uint(_computedFormat.color));
         var stOffset:Number = this.calculateStrikeThrough(tLine,blockProgression,metrics);
         var ulOffset:Number = this.calculateUnderlineOffset(stOffset,blockProgression,metrics,tLine);
         if(blockProgression != BlockProgression.RL)
         {
            if(_computedFormat.textDecoration == TextDecoration.UNDERLINE)
            {
               selObj.graphics.lineStyle(metrics.underlineThickness,_computedFormat.color as uint,selObj.alpha);
               selObj.graphics.moveTo(spanBounds.topLeft.x,ulOffset);
               selObj.graphics.lineTo(spanBounds.topLeft.x + spanBounds.width,ulOffset);
            }
            if(_computedFormat.lineThrough)
            {
               selObj.graphics.lineStyle(metrics.strikethroughThickness,_computedFormat.color as uint,selObj.alpha);
               selObj.graphics.moveTo(spanBounds.topLeft.x,stOffset);
               selObj.graphics.lineTo(spanBounds.topLeft.x + spanBounds.width,stOffset);
            }
            this.addBackgroundRect(line,tLine,metrics,spanBounds,true);
         }
         else
         {
            elemIdx = this.getAbsoluteStart() - line.absoluteStart;
            if(Boolean(elemIdx < 0) || Boolean(tLine.atomCount <= elemIdx) || Boolean(tLine.getAtomTextRotation(elemIdx) != TextRotation.ROTATE_0))
            {
               if(_computedFormat.textDecoration == TextDecoration.UNDERLINE)
               {
                  selObj.graphics.lineStyle(metrics.underlineThickness,_computedFormat.color as uint,selObj.alpha);
                  selObj.graphics.moveTo(ulOffset,spanBounds.topLeft.y);
                  selObj.graphics.lineTo(ulOffset,spanBounds.topLeft.y + spanBounds.height);
               }
               if(_computedFormat.lineThrough == true)
               {
                  selObj.graphics.lineStyle(metrics.strikethroughThickness,_computedFormat.color as uint,selObj.alpha);
                  selObj.graphics.moveTo(-stOffset,spanBounds.topLeft.y);
                  selObj.graphics.lineTo(-stOffset,spanBounds.topLeft.y + spanBounds.height);
               }
               this.addBackgroundRect(line,tLine,metrics,spanBounds,false);
            }
            else
            {
               tcyParent = this.getParentByType(TCYElement) as TCYElement;
               tcyPara = this.getParentByType(ParagraphElement) as ParagraphElement;
               lowerLocale = tcyPara.computedFormat.locale.toLowerCase();
               adornRight = lowerLocale.indexOf("zh") != 0;
               this.addBackgroundRect(line,tLine,metrics,spanBounds,true,true);
               if(this.getAbsoluteStart() + this.textLength == tcyParent.getAbsoluteStart() + tcyParent.textLength)
               {
                  tcyAdornBounds = new Rectangle();
                  tcyParent.calculateAdornmentBounds(tcyParent,tLine,blockProgression,tcyAdornBounds);
                  if(_computedFormat.textDecoration == TextDecoration.UNDERLINE)
                  {
                     selObj.graphics.lineStyle(metrics.underlineThickness,_computedFormat.color as uint,selObj.alpha);
                     baseULAdjustment = metrics.underlineOffset + metrics.underlineThickness / 2;
                     xCoor = !!adornRight?Number(spanBounds.right):Number(spanBounds.left);
                     if(!adornRight)
                     {
                        baseULAdjustment = -baseULAdjustment;
                     }
                     selObj.graphics.moveTo(xCoor + baseULAdjustment,tcyAdornBounds.top);
                     selObj.graphics.lineTo(xCoor + baseULAdjustment,tcyAdornBounds.bottom);
                  }
                  if(_computedFormat.lineThrough == true)
                  {
                     tcyMid = spanBounds.bottomRight.x - tcyAdornBounds.x;
                     tcyMid = tcyMid / 2;
                     tcyMid = tcyMid + tcyAdornBounds.x;
                     selObj.graphics.lineStyle(metrics.strikethroughThickness,_computedFormat.color as uint,selObj.alpha);
                     selObj.graphics.moveTo(tcyMid,tcyAdornBounds.top);
                     selObj.graphics.lineTo(tcyMid,tcyAdornBounds.bottom);
                  }
               }
            }
         }
         selObj.graphics.endFill();
         tLine.addChild(selObj);
      }
      
      private function addBackgroundRect(line:TextFlowLine, tLine:TextLine, metrics:FontMetrics, spanBounds:Rectangle, horizontalText:Boolean, isTCY:Boolean = false) : void
      {
         var desiredExtent:Number = NaN;
         var baselineShift:Number = NaN;
         var fontSize:Number = NaN;
         var baseStrikethroughOffset:Number = NaN;
         var glyphAscent:Number = NaN;
         var lineDescent:Number = NaN;
         var glyphDescent:Number = NaN;
         var lineAscent:Number = NaN;
         if(Boolean(_computedFormat.backgroundAlpha == 0) || Boolean(_computedFormat.backgroundColor == BackgroundColor.TRANSPARENT))
         {
            return;
         }
         var tf:TextFlow = this.getTextFlow();
         if(Boolean(!tf.backgroundManager) && Boolean(tf.flowComposer is StandardFlowComposer))
         {
            tf.backgroundManager = StandardFlowComposer(tf.flowComposer).createBackgroundManager();
         }
         if(!tf.backgroundManager)
         {
            return;
         }
         var r:Rectangle = spanBounds.clone();
         if(Boolean(!isTCY) && (Boolean(_computedFormat.baselineShift == BaselineShift.SUPERSCRIPT) || Boolean(_computedFormat.baselineShift == BaselineShift.SUBSCRIPT)))
         {
            fontSize = this.getEffectiveFontSize();
            baseStrikethroughOffset = metrics.strikethroughOffset + metrics.strikethroughThickness / 2;
            if(_computedFormat.baselineShift == BaselineShift.SUPERSCRIPT)
            {
               glyphAscent = -3 * baseStrikethroughOffset;
               baselineShift = -metrics.superscriptOffset * fontSize;
               lineDescent = tLine.getBaselinePosition(TextBaseline.DESCENT) - tLine.getBaselinePosition(TextBaseline.ROMAN);
               desiredExtent = glyphAscent + baselineShift + lineDescent;
               if(horizontalText)
               {
                  if(desiredExtent > r.height)
                  {
                     r.y = r.y - (desiredExtent - r.height);
                     r.height = desiredExtent;
                  }
               }
               else if(desiredExtent > r.width)
               {
                  r.width = desiredExtent;
               }
            }
            else
            {
               glyphDescent = -baseStrikethroughOffset;
               baselineShift = metrics.subscriptOffset * fontSize;
               lineAscent = tLine.getBaselinePosition(TextBaseline.ROMAN) - tLine.getBaselinePosition(TextBaseline.ASCENT);
               desiredExtent = lineAscent + baselineShift + glyphDescent;
               if(horizontalText)
               {
                  if(desiredExtent > r.height)
                  {
                     r.height = desiredExtent;
                  }
               }
               else if(desiredExtent > r.width)
               {
                  r.x = r.x - (desiredExtent - r.width);
                  r.width = desiredExtent;
               }
            }
         }
         tf.backgroundManager.addRect(line,this,r,_computedFormat.backgroundColor,_computedFormat.backgroundAlpha);
      }
      
      tlf_internal function getEventMirror() : EventDispatcher
      {
         var para:ParagraphElement = null;
         if(!this._blockElement)
         {
            para = getParagraph();
            if(para)
            {
               para.getTextBlock();
            }
            else
            {
               this.createContentElement();
            }
         }
         if(this._blockElement.eventMirror == null)
         {
            this._blockElement.eventMirror = new EventDispatcher();
         }
         this._hasAttachedListeners = true;
         return this._blockElement.eventMirror;
      }
      
      tlf_internal function calculateStrikeThrough(textLine:TextLine, blockProgression:String, metrics:FontMetrics) : Number
      {
         var underlineAndStrikeThroughShift:int = 0;
         var effectiveFontSize:Number = this.getEffectiveFontSize();
         if(_computedFormat.baselineShift == BaselineShift.SUPERSCRIPT)
         {
            underlineAndStrikeThroughShift = -(metrics.superscriptOffset * effectiveFontSize);
         }
         else if(_computedFormat.baselineShift == BaselineShift.SUBSCRIPT)
         {
            underlineAndStrikeThroughShift = -(metrics.subscriptOffset * (effectiveFontSize / metrics.subscriptScale));
         }
         else
         {
            underlineAndStrikeThroughShift = TextLayoutFormat.baselineShiftProperty.computeActualPropertyValue(_computedFormat.baselineShift,effectiveFontSize);
         }
         var domBaselineString:String = this.resolveDomBaseline();
         var alignmentBaselineString:String = this.computedFormat.alignmentBaseline;
         var alignDomBaselineAdjustment:Number = textLine.getBaselinePosition(domBaselineString);
         if(Boolean(alignmentBaselineString != TextBaseline.USE_DOMINANT_BASELINE) && Boolean(alignmentBaselineString != domBaselineString))
         {
            alignDomBaselineAdjustment = textLine.getBaselinePosition(alignmentBaselineString);
         }
         var stOffset:Number = metrics.strikethroughOffset;
         if(domBaselineString == TextBaseline.IDEOGRAPHIC_CENTER)
         {
            stOffset = 0;
         }
         else if(Boolean(domBaselineString == TextBaseline.IDEOGRAPHIC_TOP) || Boolean(domBaselineString == TextBaseline.ASCENT))
         {
            stOffset = stOffset * -2;
            stOffset = stOffset - 2 * metrics.strikethroughThickness;
         }
         else if(Boolean(domBaselineString == TextBaseline.IDEOGRAPHIC_BOTTOM) || Boolean(domBaselineString == TextBaseline.DESCENT))
         {
            stOffset = stOffset * 2;
            stOffset = stOffset + 2 * metrics.strikethroughThickness;
         }
         else
         {
            stOffset = stOffset - metrics.strikethroughThickness;
         }
         stOffset = stOffset + (alignDomBaselineAdjustment - underlineAndStrikeThroughShift);
         return stOffset;
      }
      
      tlf_internal function calculateUnderlineOffset(stOffset:Number, blockProgression:String, metrics:FontMetrics, textLine:TextLine) : Number
      {
         var para:FlowElement = null;
         var lowerLocale:String = null;
         var ulOffset:Number = metrics.underlineOffset + metrics.underlineThickness;
         var baseSTAdjustment:Number = metrics.strikethroughOffset;
         if(blockProgression != BlockProgression.RL)
         {
            ulOffset = ulOffset + (stOffset - baseSTAdjustment + metrics.underlineThickness / 2);
         }
         else
         {
            para = this.parent;
            while(!(para is ParagraphElement))
            {
               para = para.parent;
            }
            lowerLocale = para.computedFormat.locale.toLowerCase();
            if(lowerLocale.indexOf("zh") == 0)
            {
               ulOffset = -ulOffset;
               ulOffset = ulOffset - (stOffset - baseSTAdjustment + metrics.underlineThickness * 2);
            }
            else
            {
               ulOffset = ulOffset - (-ulOffset + stOffset + baseSTAdjustment + metrics.underlineThickness / 2);
            }
         }
         return ulOffset;
      }
   }
}
