package flashx.textLayout.elements
{
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.tlf_internal;
   
   public class ContainerFormattedElement extends ParagraphFormattedElement
   {
       
      private var _display:String;
      
      public function ContainerFormattedElement()
      {
         super();
      }
      
      override public function shallowCopy(startPos:int = 0, endPos:int = -1) : FlowElement
      {
         if(endPos == -1)
         {
            endPos = textLength;
         }
         var retFlow:ContainerFormattedElement = super.shallowCopy(startPos,endPos) as ContainerFormattedElement;
         retFlow._display = this._display;
         return retFlow;
      }
      
      override public function get display() : String
      {
         return this._display;
      }
      
      public function set display(value:String) : void
      {
         this._display = value;
      }
      
      public function get flowComposer() : IFlowComposer
      {
         return null;
      }
      
      override tlf_internal function formatChanged(notifyModelChanged:Boolean = true) : void
      {
         var idx:int = 0;
         super.formatChanged(notifyModelChanged);
         if(this.flowComposer)
         {
            for(idx = 0; idx < this.flowComposer.numControllers; idx++)
            {
               this.flowComposer.getControllerAt(idx).formatChanged();
            }
         }
      }
      
      tlf_internal function preCompose() : void
      {
      }
      
      override tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
         var p:ParagraphElement = null;
         super.normalizeRange(normalizeStart,normalizeEnd);
         if(this.numChildren == 0)
         {
            p = new ParagraphElement();
            p.replaceChildren(0,0,new SpanElement());
            replaceChildren(0,0,p);
            p.normalizeRange(0,p.textLength);
         }
      }
   }
}
