package flashx.textLayout.edit
{
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.SubParagraphGroupElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.elements.ContainerFormattedElement;
   
   use namespace tlf_internal;
   
   public class ElementRange
   {
       
      private var _absoluteStart:int;
      
      private var _absoluteEnd:int;
      
      private var _firstLeaf:FlowLeafElement;
      
      private var _lastLeaf:FlowLeafElement;
      
      private var _firstParagraph:ParagraphElement;
      
      private var _lastParagraph:ParagraphElement;
      
      private var _textFlow:TextFlow;
      
      public function ElementRange()
      {
         super();
      }
      
      public static function createElementRange(textFlow:TextFlow, absoluteStart:int, absoluteEnd:int) : ElementRange
      {
         var rslt:ElementRange = new ElementRange();
         if(absoluteStart == absoluteEnd)
         {
            rslt.absoluteStart = rslt.absoluteEnd = absoluteStart;
            rslt.firstLeaf = rslt.lastLeaf = textFlow.findLeaf(rslt.absoluteStart);
            rslt.firstParagraph = rslt.lastParagraph = rslt.firstLeaf.getParagraph();
            adjustForLeanLeft(rslt);
         }
         else
         {
            if(absoluteStart < absoluteEnd)
            {
               rslt.absoluteStart = absoluteStart;
               rslt.absoluteEnd = absoluteEnd;
            }
            else
            {
               rslt.absoluteStart = absoluteEnd;
               rslt.absoluteEnd = absoluteStart;
            }
            rslt.firstLeaf = textFlow.findLeaf(rslt.absoluteStart);
            rslt.lastLeaf = textFlow.findLeaf(rslt.absoluteEnd);
            if(Boolean(rslt.lastLeaf == null) && Boolean(rslt.absoluteEnd == textFlow.textLength) || Boolean(rslt.absoluteEnd == rslt.lastLeaf.getAbsoluteStart()))
            {
               rslt.lastLeaf = textFlow.findLeaf(rslt.absoluteEnd - 1);
            }
            rslt.firstParagraph = rslt.firstLeaf.getParagraph();
            rslt.lastParagraph = rslt.lastLeaf.getParagraph();
            if(rslt.absoluteEnd == rslt.lastParagraph.getAbsoluteStart() + rslt.lastParagraph.textLength - 1)
            {
               rslt.absoluteEnd++;
               rslt.lastLeaf = rslt.lastParagraph.getLastLeaf();
            }
         }
         rslt.textFlow = textFlow;
         return rslt;
      }
      
      private static function adjustForLeanLeft(rslt:ElementRange) : void
      {
         var previousNode:FlowLeafElement = null;
         if(rslt.firstLeaf.getAbsoluteStart() == rslt.absoluteStart)
         {
            previousNode = rslt.firstLeaf.getPreviousLeaf(rslt.firstParagraph);
            if(Boolean(previousNode) && Boolean(previousNode.getParagraph() == rslt.firstLeaf.getParagraph()))
            {
               if((Boolean(!(previousNode.parent is SubParagraphGroupElement)) || Boolean((previousNode.parent as SubParagraphGroupElement).acceptTextAfter())) && (Boolean(!(rslt.firstLeaf.parent is SubParagraphGroupElement)) || Boolean(previousNode.parent === rslt.firstLeaf.parent)))
               {
                  rslt.firstLeaf = previousNode;
               }
            }
         }
      }
      
      public function get absoluteStart() : int
      {
         return this._absoluteStart;
      }
      
      public function set absoluteStart(value:int) : void
      {
         this._absoluteStart = value;
      }
      
      public function get absoluteEnd() : int
      {
         return this._absoluteEnd;
      }
      
      public function set absoluteEnd(value:int) : void
      {
         this._absoluteEnd = value;
      }
      
      public function get firstLeaf() : FlowLeafElement
      {
         return this._firstLeaf;
      }
      
      public function set firstLeaf(value:FlowLeafElement) : void
      {
         this._firstLeaf = value;
      }
      
      public function get lastLeaf() : FlowLeafElement
      {
         return this._lastLeaf;
      }
      
      public function set lastLeaf(value:FlowLeafElement) : void
      {
         this._lastLeaf = value;
      }
      
      public function get firstParagraph() : ParagraphElement
      {
         return this._firstParagraph;
      }
      
      public function set firstParagraph(value:ParagraphElement) : void
      {
         this._firstParagraph = value;
      }
      
      public function get lastParagraph() : ParagraphElement
      {
         return this._lastParagraph;
      }
      
      public function set lastParagraph(value:ParagraphElement) : void
      {
         this._lastParagraph = value;
      }
      
      public function get textFlow() : TextFlow
      {
         return this._textFlow;
      }
      
      public function set textFlow(value:TextFlow) : void
      {
         this._textFlow = value;
      }
      
      public function get containerFormat() : ITextLayoutFormat
      {
         var container:ContainerController = null;
         var flowComposer:IFlowComposer = this.firstParagraph.getTextFlow().flowComposer;
         if(Boolean(flowComposer) && Boolean(flowComposer.numControllers > 0))
         {
            container = flowComposer.getControllerAt(0);
         }
         if(!container)
         {
            return ContainerFormattedElement(this.firstParagraph.getParentByType(ContainerFormattedElement)).computedFormat;
         }
         return container.computedFormat;
      }
      
      public function get paragraphFormat() : ITextLayoutFormat
      {
         return this.firstParagraph.computedFormat;
      }
      
      public function get characterFormat() : ITextLayoutFormat
      {
         return this.firstLeaf.computedFormat;
      }
   }
}
