package flashx.textLayout.edit
{
   import flashx.textLayout.operations.InsertTextOperation;
   import flash.display.DisplayObjectContainer;
   import flashx.undo.IUndoManager;
   import flashx.textLayout.tlf_internal;
   import flash.events.Event;
   import flash.events.KeyboardEvent;
   import flashx.textLayout.elements.Configuration;
   import flash.system.Capabilities;
   import flash.ui.Keyboard;
   import flash.events.FocusEvent;
   import flash.events.TextEvent;
   import flash.events.IMEEvent;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.operations.FlowOperation;
   import flashx.textLayout.operations.CompositeOperation;
   import flashx.textLayout.events.FlowOperationEvent;
   import flashx.textLayout.operations.UndoOperation;
   import flashx.textLayout.operations.RedoOperation;
   import flash.errors.IllegalOperationError;
   import flashx.textLayout.elements.GlobalSettings;
   import flash.utils.getQualifiedClassName;
   import flashx.undo.IOperation;
   import flashx.textLayout.operations.SplitParagraphOperation;
   import flashx.textLayout.operations.DeleteTextOperation;
   import flashx.textLayout.utils.NavigationUtil;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.utils.CharacterUtil;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.operations.InsertInlineGraphicOperation;
   import flashx.textLayout.operations.ModifyInlineGraphicOperation;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.operations.ApplyFormatOperation;
   import flashx.textLayout.operations.ClearFormatOperation;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.operations.ApplyFormatToElementOperation;
   import flashx.textLayout.operations.ClearFormatOnElementOperation;
   import flashx.textLayout.operations.CutOperation;
   import flashx.textLayout.operations.PasteOperation;
   import flashx.textLayout.operations.ApplyTCYOperation;
   import flashx.textLayout.operations.ApplyLinkOperation;
   import flashx.textLayout.operations.ApplyElementIDOperation;
   import flashx.textLayout.operations.ApplyElementStyleNameOperation;
   
   use namespace tlf_internal;
   
   public class EditManager extends SelectionManager implements IEditManager
   {
      
      public static var overwriteMode:Boolean = false;
       
      private var pendingInsert:InsertTextOperation;
      
      private var enterFrameListener:DisplayObjectContainer;
      
      private var _undoManager:IUndoManager;
      
      private var _imeSession:flashx.textLayout.edit.IMEClient;
      
      private var _imeOperationInProgress:Boolean;
      
      tlf_internal var captureLevel:int = 0;
      
      private var captureOperations:Array;
      
      private var parentStack:Array;
      
      public function EditManager(undoManager:IUndoManager = null)
      {
         this.captureOperations = [];
         super();
         this._undoManager = undoManager;
      }
      
      public function get undoManager() : IUndoManager
      {
         return this._undoManager;
      }
      
      tlf_internal function setUndoManager(undoManager:IUndoManager) : void
      {
         this._undoManager = undoManager;
      }
      
      override public function editHandler(event:Event) : void
      {
         super.editHandler(event);
         switch(event.type)
         {
            case Event.CUT:
               if(activePosition != anchorPosition)
               {
                  TextClipboard.setContents(this.cutTextScrap());
               }
               break;
            case Event.CLEAR:
               if(activePosition != anchorPosition)
               {
                  this.deleteText(null);
               }
               break;
            case Event.PASTE:
               this.pasteTextScrap(TextClipboard.getContents());
         }
      }
      
      override public function keyDownHandler(event:KeyboardEvent) : void
      {
         var discretionaryHyphenString:String = null;
         if(Boolean(!hasSelection()) || Boolean(event.isDefaultPrevented()))
         {
            return;
         }
         super.keyDownHandler(event);
         if(event.ctrlKey)
         {
            if(!event.altKey)
            {
               switch(event.charCode)
               {
                  case 122:
                     if(Boolean(!Configuration.versionIsAtLeast(10,1)) && Boolean(Capabilities.os.search("Mac OS") > -1))
                     {
                        ignoreNextTextEvent = true;
                     }
                     this.undo();
                     event.preventDefault();
                     break;
                  case 121:
                     ignoreNextTextEvent = true;
                     this.redo();
                     event.preventDefault();
                     break;
                  case Keyboard.BACKSPACE:
                     if(this._imeSession)
                     {
                        this._imeSession.compositionAbandoned();
                     }
                     this.deletePreviousWord();
                     event.preventDefault();
               }
               if(event.keyCode == Keyboard.DELETE)
               {
                  if(this._imeSession)
                  {
                     this._imeSession.compositionAbandoned();
                  }
                  this.deleteNextWord();
                  event.preventDefault();
               }
               if(event.shiftKey)
               {
                  if(event.charCode == 95)
                  {
                     if(this._imeSession)
                     {
                        this._imeSession.compositionAbandoned();
                     }
                     discretionaryHyphenString = String.fromCharCode(173);
                     if(overwriteMode)
                     {
                        this.overwriteText(discretionaryHyphenString);
                     }
                     else
                     {
                        this.insertText(discretionaryHyphenString);
                     }
                     event.preventDefault();
                  }
               }
            }
         }
         else if(event.altKey)
         {
            if(event.charCode == Keyboard.BACKSPACE)
            {
               this.deletePreviousWord();
               event.preventDefault();
            }
            else if(event.keyCode == Keyboard.DELETE)
            {
               this.deleteNextWord();
               event.preventDefault();
            }
         }
         else if(event.keyCode == Keyboard.DELETE)
         {
            this.deleteNextCharacter();
            event.preventDefault();
         }
         else if(event.keyCode == Keyboard.INSERT)
         {
            overwriteMode = !overwriteMode;
            event.preventDefault();
         }
         else
         {
            switch(event.charCode)
            {
               case Keyboard.BACKSPACE:
                  this.deletePreviousCharacter();
                  event.preventDefault();
                  break;
               case Keyboard.ENTER:
                  if(textFlow.configuration.manageEnterKey)
                  {
                     this.splitParagraph();
                     event.preventDefault();
                     event.stopImmediatePropagation();
                  }
                  break;
               case Keyboard.TAB:
                  if(textFlow.configuration.manageTabKey)
                  {
                     if(overwriteMode)
                     {
                        this.overwriteText(String.fromCharCode(event.charCode));
                     }
                     else
                     {
                        this.insertText(String.fromCharCode(event.charCode));
                     }
                     event.preventDefault();
                  }
            }
         }
      }
      
      override public function keyUpHandler(event:KeyboardEvent) : void
      {
         if(Boolean(!hasSelection()) || Boolean(event.isDefaultPrevented()))
         {
            return;
         }
         super.keyUpHandler(event);
         if(Boolean(textFlow.configuration.manageEnterKey) && Boolean(event.charCode == Keyboard.ENTER) || Boolean(textFlow.configuration.manageTabKey) && Boolean(event.charCode == Keyboard.TAB))
         {
            event.stopImmediatePropagation();
         }
      }
      
      override public function keyFocusChangeHandler(event:FocusEvent) : void
      {
         if(textFlow.configuration.manageTabKey)
         {
            event.preventDefault();
         }
      }
      
      override public function textInputHandler(event:TextEvent) : void
      {
         var charCode:int = 0;
         if(!ignoreNextTextEvent)
         {
            charCode = event.text.charCodeAt(0);
            if(charCode >= 32)
            {
               if(overwriteMode)
               {
                  this.overwriteText(event.text);
               }
               else
               {
                  this.insertText(event.text);
               }
            }
         }
         ignoreNextTextEvent = false;
      }
      
      override public function focusOutHandler(event:FocusEvent) : void
      {
         super.focusOutHandler(event);
         if(Boolean(this._imeSession) && Boolean(selectionFormatState != SelectionFormatState.FOCUSED))
         {
            this._imeSession.compositionAbandoned();
         }
      }
      
      override public function deactivateHandler(event:Event) : void
      {
         super.deactivateHandler(event);
         if(this._imeSession)
         {
            this._imeSession.compositionAbandoned();
         }
      }
      
      override public function imeStartCompositionHandler(event:IMEEvent) : void
      {
         this.flushPendingOperations();
         if(!event["imeClient"])
         {
            this._imeSession = new flashx.textLayout.edit.IMEClient(this);
            this._imeOperationInProgress = false;
            event["imeClient"] = this._imeSession;
         }
      }
      
      override public function setFocus() : void
      {
         var flowComposer:IFlowComposer = Boolean(textFlow)?textFlow.flowComposer:null;
         if(Boolean(this._imeSession) && Boolean(flowComposer) && Boolean(flowComposer.numControllers > 1))
         {
            this._imeSession.setFocus();
            setSelectionFormatState(SelectionFormatState.FOCUSED);
         }
         else
         {
            super.setFocus();
         }
      }
      
      tlf_internal function endIMESession() : void
      {
         this._imeSession = null;
         var flowComposer:IFlowComposer = Boolean(textFlow)?textFlow.flowComposer:null;
         if(Boolean(flowComposer) && Boolean(flowComposer.numControllers > 1))
         {
            this.setFocus();
         }
      }
      
      tlf_internal function beginIMEOperation() : void
      {
         this._imeOperationInProgress = true;
         this.beginCompositeOperation();
      }
      
      tlf_internal function endIMEOperation() : void
      {
         this.endCompositeOperation();
         this._imeOperationInProgress = false;
      }
      
      override public function doOperation(operation:FlowOperation) : void
      {
         if(Boolean(this._imeSession) && Boolean(!this._imeOperationInProgress))
         {
            this._imeSession.compositionAbandoned();
         }
         this.flushPendingOperations();
         try
         {
            this.captureLevel++;
            var operation:FlowOperation = this.doInternal(operation);
         }
         catch(e:Error)
         {
            captureLevel--;
            throw e;
         }
         this.captureLevel--;
         if(operation)
         {
            this.finalizeDo(operation);
         }
      }
      
      private function finalizeDo(op:FlowOperation) : void
      {
         var parentOperation:CompositeOperation = null;
         var parent:Object = null;
         var lastOp:FlowOperation = null;
         var combinedOp:FlowOperation = null;
         var controllerIndex:int = 0;
         var opEvent:FlowOperationEvent = null;
         if(Boolean(this.parentStack) && Boolean(this.parentStack.length > 0))
         {
            parent = this.parentStack[this.parentStack.length - 1];
            if(parent.captureLevel == this.captureLevel)
            {
               parentOperation = parent.operation as CompositeOperation;
            }
         }
         if(parentOperation)
         {
            parentOperation.addOperation(op);
         }
         else if(this.captureLevel == 0)
         {
            this.captureOperations.length = 0;
            if(this._undoManager)
            {
               if(Boolean(this._undoManager.canUndo()) && Boolean(allowOperationMerge))
               {
                  lastOp = this._undoManager.peekUndo() as FlowOperation;
                  if(lastOp)
                  {
                     combinedOp = lastOp.merge(op);
                     if(combinedOp)
                     {
                        combinedOp.setGenerations(lastOp.beginGeneration,textFlow.generation);
                        this._undoManager.popUndo();
                        op = combinedOp;
                     }
                  }
               }
               if(op.canUndo())
               {
                  this._undoManager.pushUndo(op);
               }
               allowOperationMerge = true;
               this._undoManager.clearRedo();
            }
            this.updateAllControllers();
            if(hasSelection())
            {
               controllerIndex = textFlow.flowComposer.findControllerIndexAtPosition(activePosition);
               if(controllerIndex >= 0)
               {
                  textFlow.flowComposer.getControllerAt(controllerIndex).scrollToRange(activePosition,anchorPosition);
               }
            }
            if(!this._imeSession)
            {
               opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_COMPLETE,false,false,op,0,null);
               textFlow.dispatchEvent(opEvent);
            }
         }
      }
      
      private function doInternal(op:FlowOperation) : FlowOperation
      {
         var opEvent:FlowOperationEvent = null;
         var beforeGeneration:uint = 0;
         var index:int = 0;
         var captureStart:int = this.captureOperations.length;
         var success:Boolean = false;
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_BEGIN,false,true,op,this.captureLevel - 1,null);
            textFlow.dispatchEvent(opEvent);
            if(opEvent.isDefaultPrevented())
            {
               return null;
            }
            var op:FlowOperation = opEvent.operation;
            if(Boolean(op is UndoOperation) || Boolean(op is RedoOperation))
            {
               throw new IllegalOperationError(GlobalSettings.resourceStringFunction("illegalOperation",[getQualifiedClassName(op)]));
            }
         }
         var opError:Error = null;
         try
         {
            beforeGeneration = textFlow.generation;
            op.setGenerations(beforeGeneration,0);
            this.captureOperations.push(op);
            success = op.doOperation();
            if(success)
            {
               textFlow.normalize();
               op.setGenerations(beforeGeneration,textFlow.generation);
            }
            else
            {
               index = this.captureOperations.indexOf(op);
               if(index >= 0)
               {
                  this.captureOperations.splice(index,1);
               }
            }
         }
         catch(e:Error)
         {
            opError = e;
         }
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_END,false,true,op,this.captureLevel - 1,opError);
            textFlow.dispatchEvent(opEvent);
            opError = !!opEvent.isDefaultPrevented()?null:opEvent.error;
         }
         if(opError)
         {
            throw opError;
         }
         if(this.captureOperations.length - captureStart > 1)
         {
            op = new CompositeOperation(this.captureOperations.slice(captureStart));
            op.setGenerations(FlowOperation(CompositeOperation(op).operations[0]).beginGeneration,textFlow.generation);
            allowOperationMerge = false;
            this.captureOperations.length = captureStart;
         }
         return !!success?op:null;
      }
      
      protected function updateAllControllers() : void
      {
         if(textFlow.flowComposer)
         {
            textFlow.flowComposer.updateAllControllers();
         }
         this.selectionChanged(true,false);
      }
      
      override public function flushPendingOperations() : void
      {
         var pi0:InsertTextOperation = null;
         super.flushPendingOperations();
         if(this.pendingInsert)
         {
            pi0 = this.pendingInsert;
            this.pendingInsert = null;
            if(this.enterFrameListener)
            {
               this.enterFrameListener.removeEventListener(Event.ENTER_FRAME,enterFrameHandler);
               this.enterFrameListener = null;
            }
            this.doOperation(pi0);
         }
      }
      
      public function undo() : void
      {
         if(this._imeSession)
         {
            this._imeSession.compositionAbandoned();
         }
         if(this.undoManager)
         {
            this.undoManager.undo();
         }
      }
      
      public function performUndo(theop:IOperation) : void
      {
         var undoPsuedoOp:UndoOperation = null;
         var opEvent:FlowOperationEvent = null;
         var rslt:SelectionState = null;
         var controllerIndex:int = 0;
         var operation:FlowOperation = theop as FlowOperation;
         if(Boolean(!operation) || Boolean(operation.textFlow != textFlow))
         {
            return;
         }
         if(!this._imeSession)
         {
            undoPsuedoOp = new UndoOperation(operation);
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_BEGIN,false,true,undoPsuedoOp,0,null);
            textFlow.dispatchEvent(opEvent);
            if(opEvent.isDefaultPrevented())
            {
               this.undoManager.pushUndo(operation);
               return;
            }
            undoPsuedoOp = opEvent.operation as UndoOperation;
            if(!undoPsuedoOp)
            {
               throw new IllegalOperationError(GlobalSettings.resourceStringFunction("illegalOperation",[getQualifiedClassName(opEvent.operation)]));
            }
            operation = undoPsuedoOp.operation;
         }
         if(operation.endGeneration != textFlow.generation)
         {
            return;
         }
         var opError:Error = null;
         try
         {
            rslt = operation.undo();
            setSelectionState(rslt);
            if(this._undoManager)
            {
               this._undoManager.pushRedo(operation);
            }
         }
         catch(e:Error)
         {
            opError = e;
         }
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_END,false,true,undoPsuedoOp,0,opError);
            textFlow.dispatchEvent(opEvent);
            opError = !!opEvent.isDefaultPrevented()?null:opEvent.error;
         }
         if(opError)
         {
            throw opError;
         }
         this.updateAllControllers();
         textFlow.setGeneration(operation.beginGeneration);
         if(hasSelection())
         {
            controllerIndex = textFlow.flowComposer.findControllerIndexAtPosition(activePosition);
            if(controllerIndex >= 0)
            {
               textFlow.flowComposer.getControllerAt(controllerIndex).scrollToRange(activePosition,anchorPosition);
            }
         }
         opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_COMPLETE,false,false,undoPsuedoOp,0,null);
         textFlow.dispatchEvent(opEvent);
      }
      
      public function redo() : void
      {
         if(this._imeSession)
         {
            this._imeSession.compositionAbandoned();
         }
         if(this.undoManager)
         {
            this.undoManager.redo();
         }
      }
      
      public function performRedo(theop:IOperation) : void
      {
         var opEvent:FlowOperationEvent = null;
         var redoPsuedoOp:RedoOperation = null;
         var rslt:SelectionState = null;
         var controllerIndex:int = 0;
         var op:FlowOperation = theop as FlowOperation;
         if(Boolean(!op) || Boolean(op.textFlow != textFlow))
         {
            return;
         }
         if(!this._imeSession)
         {
            redoPsuedoOp = new RedoOperation(op);
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_BEGIN,false,true,redoPsuedoOp,0,null);
            textFlow.dispatchEvent(opEvent);
            if(Boolean(opEvent.isDefaultPrevented()) && Boolean(this._undoManager))
            {
               this._undoManager.pushRedo(op);
               return;
            }
            redoPsuedoOp = opEvent.operation as RedoOperation;
            if(!redoPsuedoOp)
            {
               throw new IllegalOperationError(GlobalSettings.resourceStringFunction("illegalOperation",[getQualifiedClassName(opEvent.operation)]));
            }
            op = redoPsuedoOp.operation;
         }
         if(op.beginGeneration != textFlow.generation)
         {
            return;
         }
         var opError:Error = null;
         try
         {
            rslt = op.redo();
            setSelectionState(rslt);
            if(this._undoManager)
            {
               this._undoManager.pushUndo(op);
            }
         }
         catch(e:Error)
         {
            opError = e;
         }
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_END,false,true,redoPsuedoOp,0,opError);
            textFlow.dispatchEvent(opEvent);
            opError = !!opEvent.isDefaultPrevented()?null:opEvent.error;
         }
         if(opError)
         {
            throw opError;
         }
         this.updateAllControllers();
         textFlow.setGeneration(op.endGeneration);
         if(hasSelection())
         {
            controllerIndex = textFlow.flowComposer.findControllerIndexAtPosition(activePosition);
            if(controllerIndex >= 0)
            {
               textFlow.flowComposer.getControllerAt(controllerIndex).scrollToRange(activePosition,anchorPosition);
            }
         }
         opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_COMPLETE,false,false,op,0,null);
         textFlow.dispatchEvent(opEvent);
      }
      
      override public function get editingMode() : String
      {
         return EditingMode.READ_WRITE;
      }
      
      tlf_internal function defaultOperationState(operationState:SelectionState = null) : SelectionState
      {
         var markActive:Mark = null;
         var markAnchor:Mark = null;
         if(operationState)
         {
            markActive = createMark();
            markAnchor = createMark();
            try
            {
               markActive.position = operationState.activePosition;
               markAnchor.position = operationState.anchorPosition;
               this.flushPendingOperations();
            }
            finally
            {
               removeMark(markActive);
               removeMark(markAnchor);
               operationState.activePosition = markActive.position;
               operationState.anchorPosition = markAnchor.position;
            }
         }
         else
         {
            this.flushPendingOperations();
            if(hasSelection())
            {
               var operationState:SelectionState = getSelectionState();
               operationState.selectionManagerOperationState = true;
            }
         }
         return operationState;
      }
      
      public function splitParagraph(operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new SplitParagraphOperation(operationState));
      }
      
      public function deleteText(operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new DeleteTextOperation(operationState,operationState,false));
      }
      
      public function deleteNextCharacter(operationState:SelectionState = null) : void
      {
         var deleteOp:DeleteTextOperation = null;
         var nextPosition:int = 0;
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         if(operationState.absoluteStart == operationState.absoluteEnd)
         {
            nextPosition = NavigationUtil.nextAtomPosition(textFlow,absoluteStart);
            deleteOp = new DeleteTextOperation(operationState,new SelectionState(textFlow,absoluteStart,nextPosition,pointFormat),true);
         }
         else
         {
            deleteOp = new DeleteTextOperation(operationState,operationState,false);
         }
         this.doOperation(deleteOp);
      }
      
      public function deleteNextWord(operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(Boolean(!operationState) || Boolean(operationState.anchorPosition == operationState.activePosition) && Boolean(operationState.anchorPosition >= textFlow.textLength - 1))
         {
            return;
         }
         var nextWordSelState:SelectionState = this.getNextWordForDelete(operationState.absoluteStart);
         if(nextWordSelState.anchorPosition == nextWordSelState.activePosition)
         {
            return;
         }
         setSelectionState(new SelectionState(textFlow,operationState.absoluteStart,operationState.absoluteStart,new TextLayoutFormat(textFlow.findLeaf(operationState.absoluteStart).format)));
         this.doOperation(new DeleteTextOperation(operationState,nextWordSelState,false));
      }
      
      private function getNextWordForDelete(absoluteStart:int) : SelectionState
      {
         var curPos:int = 0;
         var curPosCharCode:int = 0;
         var prevPosCharCode:int = 0;
         var nextPosCharCode:int = 0;
         var leafEl:FlowLeafElement = textFlow.findLeaf(absoluteStart);
         var paraEl:ParagraphElement = leafEl.getParagraph();
         var paraElAbsStart:int = paraEl.getAbsoluteStart();
         var nextPosition:int = -1;
         if(absoluteStart - paraElAbsStart >= paraEl.textLength - 1)
         {
            nextPosition = NavigationUtil.nextAtomPosition(textFlow,absoluteStart);
         }
         else
         {
            curPos = absoluteStart - paraElAbsStart;
            curPosCharCode = paraEl.getCharCodeAtPosition(curPos);
            prevPosCharCode = -1;
            if(curPos > 0)
            {
               prevPosCharCode = paraEl.getCharCodeAtPosition(curPos - 1);
            }
            nextPosCharCode = paraEl.getCharCodeAtPosition(curPos + 1);
            if(Boolean(!CharacterUtil.isWhitespace(curPosCharCode)) && (Boolean(curPos == 0) || Boolean(curPos > 0) && Boolean(CharacterUtil.isWhitespace(prevPosCharCode))))
            {
               nextPosition = NavigationUtil.nextWordPosition(textFlow,absoluteStart);
            }
            else
            {
               if(Boolean(CharacterUtil.isWhitespace(curPosCharCode)) && (Boolean(curPos > 0) && Boolean(!CharacterUtil.isWhitespace(prevPosCharCode))))
               {
                  curPos = paraEl.findNextWordBoundary(curPos);
               }
               nextPosition = paraElAbsStart + paraEl.findNextWordBoundary(curPos);
            }
         }
         return new SelectionState(textFlow,absoluteStart,nextPosition,pointFormat);
      }
      
      public function deletePreviousCharacter(operationState:SelectionState = null) : void
      {
         var deleteOp:DeleteTextOperation = null;
         var beginPrevious:int = 0;
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         if(operationState.absoluteStart == operationState.absoluteEnd)
         {
            beginPrevious = NavigationUtil.previousAtomPosition(textFlow,operationState.absoluteStart);
            deleteOp = new DeleteTextOperation(operationState,new SelectionState(textFlow,beginPrevious,operationState.absoluteStart),true);
         }
         else
         {
            deleteOp = new DeleteTextOperation(operationState);
         }
         this.doOperation(deleteOp);
      }
      
      public function deletePreviousWord(operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         var prevWordSelState:SelectionState = this.getPreviousWordForDelete(operationState.absoluteStart);
         if(prevWordSelState.anchorPosition == prevWordSelState.activePosition)
         {
            return;
         }
         setSelectionState(new SelectionState(textFlow,operationState.absoluteStart,operationState.absoluteStart,new TextLayoutFormat(textFlow.findLeaf(operationState.absoluteStart).format)));
         this.doOperation(new DeleteTextOperation(operationState,prevWordSelState,false));
      }
      
      private function getPreviousWordForDelete(absoluteStart:int) : SelectionState
      {
         var beginPrevious:int = 0;
         var leafEl:FlowLeafElement = textFlow.findLeaf(absoluteStart);
         var paraEl:ParagraphElement = leafEl.getParagraph();
         var paraElAbsStart:int = paraEl.getAbsoluteStart();
         if(absoluteStart == paraElAbsStart)
         {
            beginPrevious = NavigationUtil.previousAtomPosition(textFlow,absoluteStart);
            return new SelectionState(textFlow,beginPrevious,absoluteStart);
         }
         var curPos:int = absoluteStart - paraElAbsStart;
         var curPosCharCode:int = paraEl.getCharCodeAtPosition(curPos);
         var prevPosCharCode:int = paraEl.getCharCodeAtPosition(curPos - 1);
         var curAbsStart:int = absoluteStart;
         if(Boolean(CharacterUtil.isWhitespace(curPosCharCode)) && Boolean(curPos != paraEl.textLength - 1))
         {
            if(CharacterUtil.isWhitespace(prevPosCharCode))
            {
               curPos = paraEl.findPreviousWordBoundary(curPos);
            }
            if(curPos > 0)
            {
               curPos = paraEl.findPreviousWordBoundary(curPos);
               if(curPos > 0)
               {
                  prevPosCharCode = paraEl.getCharCodeAtPosition(curPos - 1);
                  if(CharacterUtil.isWhitespace(prevPosCharCode))
                  {
                     curPos = paraEl.findPreviousWordBoundary(curPos);
                  }
               }
            }
         }
         else if(CharacterUtil.isWhitespace(prevPosCharCode))
         {
            curPos = paraEl.findPreviousWordBoundary(curPos);
            if(curPos > 0)
            {
               curPos = paraEl.findPreviousWordBoundary(curPos);
               if(curPos > 0)
               {
                  prevPosCharCode = paraEl.getCharCodeAtPosition(curPos - 1);
                  if(!CharacterUtil.isWhitespace(prevPosCharCode))
                  {
                     curAbsStart--;
                  }
               }
            }
         }
         else
         {
            curPos = paraEl.findPreviousWordBoundary(curPos);
         }
         return new SelectionState(textFlow,paraElAbsStart + curPos,curAbsStart);
      }
      
      public function insertText(text:String, origOperationState:SelectionState = null) : void
      {
         var operationState:SelectionState = null;
         var controller:ContainerController = null;
         if(Boolean(origOperationState == null) && Boolean(this.pendingInsert))
         {
            this.pendingInsert.text = this.pendingInsert.text + text;
         }
         else
         {
            operationState = this.defaultOperationState(origOperationState);
            if(!operationState)
            {
               return;
            }
            this.pendingInsert = new InsertTextOperation(operationState,text);
            controller = textFlow.flowComposer.getControllerAt(0);
            if(Boolean(this.captureLevel == 0 && origOperationState == null) && Boolean(controller) && Boolean(controller.container))
            {
               this.enterFrameListener = controller.container;
               this.enterFrameListener.addEventListener(Event.ENTER_FRAME,enterFrameHandler,false,1,true);
            }
            else
            {
               this.flushPendingOperations();
            }
         }
      }
      
      public function overwriteText(text:String, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         var selState:SelectionState = getSelectionState();
         NavigationUtil.nextCharacter(selState,true);
         this.doOperation(new InsertTextOperation(operationState,text,selState));
      }
      
      public function insertInlineGraphic(source:Object, width:Object, height:Object, options:Object = null, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new InsertInlineGraphicOperation(operationState,source,width,height,options));
      }
      
      public function modifyInlineGraphic(source:Object, width:Object, height:Object, options:Object = null, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ModifyInlineGraphicOperation(operationState,source,width,height,options));
      }
      
      public function applyFormat(leafFormat:ITextLayoutFormat, paragraphFormat:ITextLayoutFormat, containerFormat:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ApplyFormatOperation(operationState,leafFormat,paragraphFormat,containerFormat));
      }
      
      public function clearFormat(leafFormat:ITextLayoutFormat, paragraphFormat:ITextLayoutFormat, containerFormat:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ClearFormatOperation(operationState,leafFormat,paragraphFormat,containerFormat));
      }
      
      public function applyLeafFormat(characterFormat:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         this.applyFormat(characterFormat,null,null,operationState);
      }
      
      public function applyParagraphFormat(paragraphFormat:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         this.applyFormat(null,paragraphFormat,null,operationState);
      }
      
      public function applyContainerFormat(containerFormat:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         this.applyFormat(null,null,containerFormat,operationState);
      }
      
      public function applyFormatToElement(targetElement:FlowElement, format:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ApplyFormatToElementOperation(operationState,targetElement,format));
      }
      
      public function clearFormatOnElement(targetElement:FlowElement, format:ITextLayoutFormat, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ClearFormatOnElementOperation(operationState,targetElement,format));
      }
      
      public function cutTextScrap(operationState:SelectionState = null) : TextScrap
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return null;
         }
         if(operationState.anchorPosition == operationState.activePosition)
         {
            return null;
         }
         var tScrap:TextScrap = TextFlowEdit.createTextScrap(operationState.textFlow,operationState.absoluteStart,operationState.absoluteEnd);
         var beforeOpLen:int = textFlow.textLength;
         this.doOperation(new CutOperation(operationState,tScrap));
         if(operationState.textFlow.textLength != beforeOpLen)
         {
            return tScrap;
         }
         return null;
      }
      
      public function pasteTextScrap(scrapToPaste:TextScrap, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new PasteOperation(operationState,scrapToPaste));
      }
      
      public function applyTCY(tcyOn:Boolean, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ApplyTCYOperation(operationState,tcyOn));
      }
      
      public function applyLink(href:String, targetString:String = null, extendToLinkBoundary:Boolean = false, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         if(operationState.absoluteStart == operationState.absoluteEnd)
         {
            return;
         }
         this.doOperation(new ApplyLinkOperation(operationState,href,targetString,extendToLinkBoundary));
      }
      
      public function changeElementID(newID:String, targetElement:FlowElement, relativeStart:int = 0, relativeEnd:int = -1, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         if(operationState.absoluteStart == operationState.absoluteEnd)
         {
            return;
         }
         this.doOperation(new ApplyElementIDOperation(operationState,targetElement,newID,relativeStart,relativeEnd));
      }
      
      public function changeStyleName(newName:String, targetElement:FlowElement, relativeStart:int = 0, relativeEnd:int = -1, operationState:SelectionState = null) : void
      {
         operationState = this.defaultOperationState(operationState);
         if(!operationState)
         {
            return;
         }
         this.doOperation(new ApplyElementStyleNameOperation(operationState,targetElement,newName,relativeStart,relativeEnd));
      }
      
      public function beginCompositeOperation() : void
      {
         var opEvent:FlowOperationEvent = null;
         this.flushPendingOperations();
         if(!this.parentStack)
         {
            this.parentStack = [];
         }
         var operation:CompositeOperation = new CompositeOperation();
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_BEGIN,false,false,operation,this.captureLevel,null);
            textFlow.dispatchEvent(opEvent);
         }
         operation.setGenerations(textFlow.generation,0);
         this.captureLevel++;
         var parent:Object = new Object();
         parent.operation = operation;
         parent.captureLevel = this.captureLevel;
         this.parentStack.push(parent);
      }
      
      public function endCompositeOperation() : void
      {
         var opEvent:FlowOperationEvent = null;
         this.captureLevel--;
         var parent:Object = this.parentStack.pop();
         var operation:FlowOperation = parent.operation;
         if(!this._imeSession)
         {
            opEvent = new FlowOperationEvent(FlowOperationEvent.FLOW_OPERATION_END,false,false,operation,this.captureLevel,null);
            textFlow.dispatchEvent(opEvent);
         }
         operation.setGenerations(operation.beginGeneration,textFlow.generation);
         this.finalizeDo(operation);
      }
      
      override tlf_internal function selectionChanged(doDispatchEvent:Boolean = true, resetPointFormat:Boolean = true) : void
      {
         if(this._imeSession)
         {
            this._imeSession.selectionChanged();
         }
         super.selectionChanged(doDispatchEvent,resetPointFormat);
      }
   }
}
