package flashx.textLayout.conversion
{
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.LinkElement;
   import flashx.textLayout.elements.DivElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.FlowValueHolder;
   import flashx.textLayout.elements.FlowElement;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   class TextLayoutExporter extends BaseTextLayoutExporter
   {
      
      private static var nameCounter:int = 0;
      
      private static var _formatDescription:Object = TextLayoutFormat.description;
      
      private static const brTabRegEx:RegExp = new RegExp("[" + " " + "\t" + "]");
       
      private var queuedExport:Object = null;
      
      function TextLayoutExporter()
      {
         super(new Namespace("http://ns.adobe.com/textLayout/2008"),null,TextLayoutImporter.defaultConfiguration);
      }
      
      public static function exportImage(exporter:BaseTextLayoutExporter, image:InlineGraphicElement) : XMLList
      {
         var output:XMLList = exportFlowElement(exporter,image);
         if(image.height !== undefined)
         {
            output.@height = image.height;
         }
         if(image.width !== undefined)
         {
            output.@width = image.width;
         }
         if(image.source != null)
         {
            output.@source = image.source;
         }
         return output;
      }
      
      public static function exportLink(exporter:BaseTextLayoutExporter, link:LinkElement) : XMLList
      {
         var output:XMLList = exportFlowGroupElement(exporter,link);
         if(link.href)
         {
            output.@href = link.href;
         }
         if(link.target)
         {
            output.@target = link.target;
         }
         return output;
      }
      
      public static function exportDiv(exporter:BaseTextLayoutExporter, div:DivElement) : XMLList
      {
         return exportContainerFormattedElement(exporter,div);
      }
      
      public static function exportTCY(exporter:BaseTextLayoutExporter, tcy:TCYElement) : XMLList
      {
         return exportFlowGroupElement(exporter,tcy);
      }
      
      private static function exportToName(exporter:BaseTextLayoutExporter, obj:Object) : String
      {
         var newName:String = "ObjectID" + nameCounter.toString();
         TextLayoutExporter(exporter).queueForExport(obj,newName);
         nameCounter++;
         return newName;
      }
      
      override protected function clear() : void
      {
         nameCounter = 0;
         this.queuedExport = null;
      }
      
      override protected function exportToXML(textFlow:TextFlow) : XML
      {
         var result:XML = super.exportToXML(textFlow);
         var queuedXML:XMLList = this.exportQueuedObjects();
         if(queuedXML)
         {
            result.appendChild(queuedXML);
         }
         return result;
      }
      
      private function exportQueuedObjects() : XMLList
      {
         var idName:* = null;
         var objectToExport:Object = null;
         var output:XMLList = null;
         var characterFormatXML:XML = null;
         if(!this.queuedExport)
         {
            return null;
         }
         var result:XMLList = new XMLList();
         for(idName in this.queuedExport)
         {
            objectToExport = this.queuedExport[idName];
            output = new XMLList();
            if(objectToExport is FlowValueHolder)
            {
               characterFormatXML = <format/>;
               characterFormatXML.setNamespace(flowNS);
               output = output + characterFormatXML;
               output.@id = idName;
               exportStyles(output,objectToExport.coreStyles,this.formatDescription);
               exportStyles(output,objectToExport.userStyles);
            }
            result = result + output;
         }
         return result;
      }
      
      private function queueForExport(object:Object, name:String) : void
      {
         if(!this.queuedExport)
         {
            this.queuedExport = new Object();
         }
         this.queuedExport[name] = object;
      }
      
      override protected function get spanTextReplacementRegex() : RegExp
      {
         return brTabRegEx;
      }
      
      override protected function getSpanTextReplacementXML(ch:String) : XML
      {
         var replacementXML:XML = null;
         if(ch == " ")
         {
            replacementXML = <br/>;
         }
         else if(ch == "\t")
         {
            replacementXML = <tab/>;
         }
         else
         {
            return null;
         }
         replacementXML.setNamespace(flowNS);
         return replacementXML;
      }
      
      override protected function exportFlowElement(flowElement:FlowElement) : XMLList
      {
         var rslt:XMLList = super.exportFlowElement(flowElement);
         var coreStyles:Object = flowElement.coreStyles;
         if(coreStyles)
         {
            delete coreStyles[TextLayoutFormat.whiteSpaceCollapseProperty.name];
            exportStyles(rslt,coreStyles,this.formatDescription);
         }
         if(flowElement.id != null)
         {
            rslt["id"] = flowElement.id;
         }
         if(flowElement.styleName != null)
         {
            rslt["styleName"] = flowElement.styleName;
         }
         var styles:Object = flowElement.userStyles;
         if(styles)
         {
            exportStyles(rslt,styles);
         }
         return rslt;
      }
      
      override protected function get formatDescription() : Object
      {
         return _formatDescription;
      }
   }
}
