package flashx.textLayout.compose
{
   import flash.display.Sprite;
   import flashx.textLayout.accessibility.TextAccImpl;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.ContainerFormattedElement;
   import flashx.textLayout.elements.TextFlow;
   import flash.system.Capabilities;
   import flashx.textLayout.edit.ISelectionManager;
   import flashx.textLayout.container.ScrollPolicy;
   import flashx.textLayout.events.CompositionCompleteEvent;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.text.engine.TextLine;
   import flashx.textLayout.elements.BackgroundManager;
   
   use namespace tlf_internal;
   
   [Exclude(kind="method",name="createBackgroundManager")]
   public class StandardFlowComposer extends FlowComposerBase implements IFlowComposer
   {
       
      tlf_internal var _rootElement:ContainerFormattedElement;
      
      private var _controllerList:Array;
      
      private var _composing:Boolean;
      
      private var lastBPDirectionScrollPosition:Number = -Infinity;
      
      public function StandardFlowComposer()
      {
         super();
         this._controllerList = new Array();
         this._composing = false;
      }
      
      private static function clearContainerAccessibilityImplementation(cont:Sprite) : void
      {
         if(cont.accessibilityImplementation)
         {
            if(cont.accessibilityImplementation is TextAccImpl)
            {
               TextAccImpl(cont.accessibilityImplementation).detachListeners();
            }
            cont.accessibilityImplementation = null;
         }
      }
      
      private static function getBPDirectionScrollPosition(bp:String, cont:ContainerController) : Number
      {
         return bp == BlockProgression.TB?Number(cont.verticalScrollPosition):Number(cont.horizontalScrollPosition);
      }
      
      public function get composing() : Boolean
      {
         return this._composing;
      }
      
      public function getAbsoluteStart(controller:ContainerController) : int
      {
         var stopIdx:int = this.getControllerIndex(controller);
         var rslt:int = this._rootElement.getAbsoluteStart();
         for(var idx:int = 0; idx < stopIdx; idx++)
         {
            rslt = rslt + this._controllerList[idx].textLength;
         }
         return rslt;
      }
      
      public function get rootElement() : ContainerFormattedElement
      {
         return this._rootElement;
      }
      
      public function setRootElement(newRootElement:ContainerFormattedElement) : void
      {
         if(this._rootElement != newRootElement)
         {
            if(Boolean(newRootElement is TextFlow) && Boolean(TextFlow(newRootElement).flowComposer != this))
            {
               TextFlow(newRootElement).flowComposer = this;
            }
            else
            {
               this.clearCompositionResults();
               this.detachAllContainers();
               this._rootElement = newRootElement;
               _textFlow = Boolean(this._rootElement)?this._rootElement.getTextFlow():null;
               this.attachAllContainers();
            }
         }
      }
      
      tlf_internal function detachAllContainers() : void
      {
         var cont:ContainerController = null;
         var firstContainerController:ContainerController = null;
         var firstContainer:Sprite = null;
         if(Boolean(this._controllerList.length > 0) && Boolean(_textFlow))
         {
            firstContainerController = this.getControllerAt(0);
            firstContainer = firstContainerController.container;
            if(firstContainer)
            {
               clearContainerAccessibilityImplementation(firstContainer);
            }
         }
         for each(cont in this._controllerList)
         {
            cont.clearSelectionShapes();
            cont.setRootElement(null);
         }
      }
      
      tlf_internal function attachAllContainers() : void
      {
         var cont:ContainerController = null;
         var curContainer:Sprite = null;
         var i:int = 0;
         var firstContainer:Sprite = null;
         for each(cont in this._controllerList)
         {
            ContainerController(cont).setRootElement(this._rootElement);
         }
         if(Boolean(this._controllerList.length > 0) && Boolean(_textFlow))
         {
            if(Boolean(textFlow.configuration.enableAccessibility) && Boolean(Capabilities.hasAccessibility))
            {
               firstContainer = this.getControllerAt(0).container;
               if(firstContainer)
               {
                  clearContainerAccessibilityImplementation(firstContainer);
                  firstContainer.accessibilityImplementation = new TextAccImpl(firstContainer,_textFlow);
               }
            }
            for(i = 0; i < this._controllerList.length; i++)
            {
               curContainer = this.getControllerAt(i).container;
               if(curContainer)
               {
                  curContainer.focusRect = false;
               }
            }
         }
         this.clearCompositionResults();
      }
      
      public function get numControllers() : int
      {
         return Boolean(this._controllerList)?int(this._controllerList.length):int(0);
      }
      
      public function addController(controller:ContainerController) : void
      {
         var curContainer:Sprite = null;
         var damageStart:int = 0;
         var damageLen:int = 0;
         this._controllerList.push(ContainerController(controller));
         if(this.numControllers == 1)
         {
            this.attachAllContainers();
         }
         else
         {
            controller.setRootElement(this._rootElement);
            curContainer = controller.container;
            if(curContainer)
            {
               curContainer.focusRect = false;
            }
            if(textFlow)
            {
               controller = this.getControllerAt(this.numControllers - 2);
               damageStart = controller.absoluteStart;
               damageLen = controller.textLength;
               if(damageLen == 0)
               {
                  if(damageStart != textFlow.textLength)
                  {
                     damageLen++;
                  }
                  else if(damageStart != 0)
                  {
                     damageStart--;
                     damageLen++;
                  }
               }
               if(damageLen)
               {
                  textFlow.damage(damageStart,damageLen,FlowDamageType.GEOMETRY,false);
               }
            }
         }
      }
      
      public function addControllerAt(controller:ContainerController, index:int) : void
      {
         this.detachAllContainers();
         this._controllerList.splice(index,0,ContainerController(controller));
         this.attachAllContainers();
      }
      
      private function fastRemoveController(index:int) : Boolean
      {
         var firstContainer:Sprite = null;
         if(index == -1)
         {
            return true;
         }
         var cont:ContainerController = this._controllerList[index];
         if(!cont)
         {
            return true;
         }
         if(Boolean(!_textFlow) || Boolean(cont.absoluteStart == _textFlow.textLength))
         {
            if(index == 0)
            {
               firstContainer = cont.container;
               if(firstContainer)
               {
                  clearContainerAccessibilityImplementation(firstContainer);
               }
            }
            cont.setRootElement(null);
            this._controllerList.splice(index,1);
            return true;
         }
         return false;
      }
      
      public function removeController(controller:ContainerController) : void
      {
         var index:int = this.getControllerIndex(controller);
         if(!this.fastRemoveController(index))
         {
            this.detachAllContainers();
            this._controllerList.splice(index,1);
            this.attachAllContainers();
         }
      }
      
      public function removeControllerAt(index:int) : void
      {
         if(!this.fastRemoveController(index))
         {
            this.detachAllContainers();
            this._controllerList.splice(index,1);
            this.attachAllContainers();
         }
      }
      
      public function removeAllControllers() : void
      {
         this.detachAllContainers();
         this._controllerList.splice(0,this._controllerList.length);
      }
      
      public function getControllerAt(index:int) : ContainerController
      {
         return this._controllerList[index];
      }
      
      public function getControllerIndex(controller:ContainerController) : int
      {
         for(var idx:int = 0; idx < this._controllerList.length; idx++)
         {
            if(this._controllerList[idx] == controller)
            {
               return idx;
            }
         }
         return -1;
      }
      
      public function findControllerIndexAtPosition(absolutePosition:int, preferPrevious:Boolean = false) : int
      {
         var mid:int = 0;
         var cont:ContainerController = null;
         var lo:int = 0;
         var hi:int = this._controllerList.length - 1;
         while(lo <= hi)
         {
            mid = (lo + hi) / 2;
            cont = this._controllerList[mid];
            if(cont.absoluteStart <= absolutePosition)
            {
               if(preferPrevious)
               {
                  if(cont.absoluteStart + cont.textLength >= absolutePosition)
                  {
                     while(Boolean(mid != 0) && Boolean(cont.absoluteStart == absolutePosition))
                     {
                        mid--;
                        cont = this._controllerList[mid];
                     }
                     return mid;
                  }
               }
               else
               {
                  if(Boolean(cont.absoluteStart == absolutePosition) && Boolean(cont.textLength != 0))
                  {
                     while(mid != 0)
                     {
                        cont = this._controllerList[mid - 1];
                        if(cont.textLength != 0)
                        {
                           break;
                        }
                        mid--;
                     }
                     return mid;
                  }
                  if(cont.absoluteStart + cont.textLength > absolutePosition)
                  {
                     return mid;
                  }
               }
               lo = mid + 1;
            }
            else
            {
               hi = mid - 1;
            }
         }
         return -1;
      }
      
      tlf_internal function clearCompositionResults() : void
      {
         var cont:ContainerController = null;
         initializeLines();
         for each(cont in this._controllerList)
         {
            cont.clearCompositionResults();
         }
      }
      
      public function updateAllControllers() : Boolean
      {
         return this.updateToController();
      }
      
      public function updateToController(index:int = 2.147483647E9) : Boolean
      {
         if(this._composing)
         {
            return false;
         }
         var sm:ISelectionManager = textFlow.interactionManager;
         if(sm)
         {
            sm.flushPendingOperations();
         }
         var startController:ContainerController = !!this._composing?null:this.internalCompose(-1,index);
         var shapesDamaged:Boolean = this.areShapesDamaged();
         if(shapesDamaged)
         {
            this.updateCompositionShapes();
         }
         if(sm)
         {
            sm.refreshSelection();
         }
         this.releaseLines(startController);
         return shapesDamaged;
      }
      
      public function setFocus(absolutePosition:int, leanLeft:Boolean = false) : void
      {
         var idx:int = this.findControllerIndexAtPosition(absolutePosition,leanLeft);
         if(idx == -1)
         {
            idx = this.numControllers - 1;
         }
         if(idx != -1)
         {
            this._controllerList[idx].setFocus();
         }
      }
      
      public function interactionManagerChanged(newInteractionManager:ISelectionManager) : void
      {
         var controller:ContainerController = null;
         for each(controller in this._controllerList)
         {
            controller.interactionManagerChanged(newInteractionManager);
         }
      }
      
      private function updateCompositionShapes() : void
      {
         var controller:ContainerController = null;
         for each(controller in this._controllerList)
         {
            controller.updateCompositionShapes();
         }
      }
      
      override public function isDamaged(absolutePosition:int) : Boolean
      {
         var container:ContainerController = null;
         if(!super.isDamaged(absolutePosition))
         {
            if(absolutePosition == _textFlow.textLength)
            {
               container = this.getControllerAt(this.numControllers - 1);
               if(Boolean(container) && (Boolean(container.verticalScrollPolicy != ScrollPolicy.OFF) || Boolean(container.horizontalScrollPolicy != ScrollPolicy.OFF)))
               {
                  return true;
               }
            }
            return false;
         }
         return true;
      }
      
      protected function preCompose() : Boolean
      {
         this.rootElement.preCompose();
         if(numLines == 0)
         {
            initializeLines();
         }
         return this.isDamaged(this.rootElement.getAbsoluteStart() + this.rootElement.textLength);
      }
      
      tlf_internal function getComposeState() : ComposeState
      {
         return ComposeState.getComposeState();
      }
      
      tlf_internal function releaseComposeState(state:ComposeState) : void
      {
         ComposeState.releaseComposeState(state);
      }
      
      tlf_internal function callTheComposer(composeToPosition:int, controllerEndIndex:int) : ContainerController
      {
         if(_damageAbsoluteStart == this.rootElement.getAbsoluteStart() + this.rootElement.textLength)
         {
            return this.getControllerAt(this.numControllers - 1);
         }
         var state:ComposeState = this.getComposeState();
         var lastComposedPosition:int = state.composeTextFlow(textFlow,composeToPosition,controllerEndIndex);
         if(_damageAbsoluteStart < lastComposedPosition)
         {
            _damageAbsoluteStart = lastComposedPosition;
         }
         finalizeLinesAfterCompose();
         var startController:ContainerController = state.startController;
         this.releaseComposeState(state);
         if(textFlow.hasEventListener(CompositionCompleteEvent.COMPOSITION_COMPLETE))
         {
            textFlow.dispatchEvent(new CompositionCompleteEvent(CompositionCompleteEvent.COMPOSITION_COMPLETE,false,false,textFlow,0,lastComposedPosition));
         }
         return startController;
      }
      
      private function internalCompose(composeToPosition:int = -1, composeToControllerIndex:int = -1) : ContainerController
      {
         var lastController:ContainerController = null;
         var bp:String = null;
         var startController:ContainerController = null;
         var controller:ContainerController = null;
         var lastVisibleLine:TextFlowLine = null;
         var cont:ContainerController = null;
         var idx:int = 0;
         var sm:ISelectionManager = textFlow.interactionManager;
         if(sm)
         {
            sm.flushPendingOperations();
         }
         if(this.numControllers == 0)
         {
            return null;
         }
         if(composeToControllerIndex < 0)
         {
            if(Boolean(composeToPosition >= 0) && Boolean(damageAbsoluteStart >= composeToPosition))
            {
               return null;
            }
         }
         else
         {
            controller = this.getControllerAt(Math.min(composeToControllerIndex,this.numControllers - 1));
            if(damageAbsoluteStart > controller.absoluteStart + controller.textLength)
            {
               return null;
            }
         }
         if(composeToControllerIndex == this.numControllers - 1)
         {
            lastController = this.getControllerAt(this.numControllers - 1);
            lastVisibleLine = lastController.getLastVisibleLine();
            if(lastVisibleLine)
            {
               bp = this.rootElement.computedFormat.blockProgression;
               if(Boolean(getBPDirectionScrollPosition(bp,lastController) == this.lastBPDirectionScrollPosition) && Boolean(damageAbsoluteStart >= lastVisibleLine.absoluteStart + lastVisibleLine.textLength))
               {
                  return null;
               }
            }
         }
         this.lastBPDirectionScrollPosition = Number.NEGATIVE_INFINITY;
         this._composing = true;
         try
         {
            if(Boolean(textFlow) && Boolean(this.numControllers != 0))
            {
               if(this.preCompose())
               {
                  startController = this.callTheComposer(composeToPosition,composeToControllerIndex);
                  if(startController)
                  {
                     idx = this.getControllerIndex(startController);
                     while(idx < this.numControllers)
                     {
                        this.getControllerAt(idx++).shapesInvalid = true;
                     }
                  }
               }
            }
         }
         catch(e:Error)
         {
            _composing = false;
            throw e;
         }
         this._composing = false;
         if(lastController)
         {
            this.lastBPDirectionScrollPosition = getBPDirectionScrollPosition(bp,lastController);
         }
         return startController;
      }
      
      tlf_internal function areShapesDamaged() : Boolean
      {
         var cont:ContainerController = null;
         for each(cont in this._controllerList)
         {
            if(cont.shapesInvalid)
            {
               return true;
            }
         }
         return false;
      }
      
      public function compose() : Boolean
      {
         return !!this._composing?Boolean(false):Boolean(this.internalCompose() != null);
      }
      
      public function composeToPosition(absolutePosition:int = 2.147483647E9) : Boolean
      {
         return !!this._composing?Boolean(false):Boolean(this.internalCompose(absolutePosition,-1) != null);
      }
      
      public function composeToController(index:int = 2.147483647E9) : Boolean
      {
         return !!this._composing?Boolean(false):Boolean(this.internalCompose(-1,index) != null);
      }
      
      private function releaseLines(startController:ContainerController) : void
      {
         var line:TextFlowLine = null;
         var paragraph:ParagraphElement = null;
         var textLine:TextLine = null;
         var currentParagraph:ParagraphElement = null;
         var inUse:Boolean = false;
         var lastLine:int = lines.length;
         for(var lineIndex:int = Boolean(startController)?int(findLineIndexAtPosition(startController.absoluteStart)):int(0); lineIndex < lastLine; lineIndex++)
         {
            line = lines[lineIndex];
            paragraph = line.paragraph;
            if(paragraph != currentParagraph)
            {
               if(Boolean(!inUse) && Boolean(currentParagraph))
               {
                  currentParagraph.releaseTextBlock();
               }
               currentParagraph = paragraph;
               inUse = false;
            }
            if(Boolean(!inUse) && Boolean(!line.isDamaged()))
            {
               textLine = line.peekTextLine();
               if(Boolean(textLine != null) && Boolean(textLine.parent != null))
               {
                  inUse = true;
               }
            }
         }
         if(Boolean(!inUse) && Boolean(currentParagraph))
         {
            currentParagraph.releaseTextBlock();
         }
      }
      
      public function createBackgroundManager() : BackgroundManager
      {
         return new BackgroundManager();
      }
   }
}
