package flashx.textLayout.compose
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.VerticalAlign;
   import flashx.textLayout.elements.TextFlow;
   import flash.text.engine.TextLine;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.geom.Rectangle;
   import flash.text.engine.TextBlock;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.Direction;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class SimpleCompose extends BaseCompose
   {
       
      protected var workingLine:flashx.textLayout.compose.TextFlowLine;
      
      public var _lines:Array;
      
      private var _vjLines:Array;
      
      private var vjBeginLineIndex:int = 0;
      
      private var vjDisableThisParcel:Boolean = false;
      
      private var vjParcel:flashx.textLayout.compose.Parcel;
      
      private var vjType:String;
      
      private var _totalLength:Number;
      
      public function SimpleCompose()
      {
         this.workingLine = new flashx.textLayout.compose.TextFlowLine(null,null);
         super();
         this._lines = new Array();
         this._vjLines = new Array();
      }
      
      override protected function createParcelList() : IParcelList
      {
         return ParcelList.getParcelList();
      }
      
      override protected function releaseParcelList(list:IParcelList) : void
      {
         ParcelList.releaseParcelList(list);
      }
      
      override protected function initializeForComposer(composer:IFlowComposer, composeToPosition:int, controllerEndIndex:int) : void
      {
         super.initializeForComposer(composer,composeToPosition,controllerEndIndex);
         this._vjLines.splice(0);
         this.vjBeginLineIndex = 0;
         this.vjParcel = parcelList.currentParcel;
         this.vjDisableThisParcel = false;
         this.vjType = Boolean(this.vjParcel)?this.vjParcel.controller.computedFormat.verticalAlign:VerticalAlign.TOP;
         _startController = composer.getControllerAt(0);
         _startComposePosition = 0;
      }
      
      override public function composeTextFlow(textFlow:TextFlow, composeToPosition:int, controllerEndIndex:int) : int
      {
         _flowComposer = textFlow.flowComposer as StandardFlowComposer;
         this._lines.splice(0);
         this._totalLength = 0;
         return super.composeTextFlow(textFlow,composeToPosition,controllerEndIndex);
      }
      
      override protected function doVerticalAlignment(canVerticalAlign:Boolean, nextParcel:flashx.textLayout.compose.Parcel) : Boolean
      {
         var result:Boolean = false;
         if(Boolean(canVerticalAlign) && Boolean(this.vjType != VerticalAlign.TOP) && Boolean(this.vjBeginLineIndex != this._lines.length) && Boolean(!this.vjDisableThisParcel) && Boolean(this.vjParcel.columnCoverage == Parcel.FULL_COLUMN))
         {
            applyVerticalAlignmentToColumn(this.vjParcel.controller,this.vjType,this._vjLines,0,this._vjLines.length);
            result = true;
         }
         this._vjLines.splice(0);
         this.vjBeginLineIndex = this._lines.length;
         this.vjParcel = nextParcel;
         this.vjDisableThisParcel = false;
         if(nextParcel)
         {
            this.vjType = this.vjParcel.controller.computedFormat.verticalAlign;
         }
         return result;
      }
      
      private function finalizeLine(curLine:flashx.textLayout.compose.TextFlowLine) : void
      {
         var line:TextLine = curLine.createShape(_blockProgression);
         if(this.textFlow.backgroundManager)
         {
            this.textFlow.backgroundManager.finalizeLine(curLine);
         }
         line.userData = this._totalLength;
         this._totalLength = this._totalLength + line.rawTextLength;
         this._lines.push(line);
         if(this.vjType != VerticalAlign.TOP)
         {
            this._vjLines.push(new VJHelper(line,curLine.height));
         }
         commitLastLineState(curLine);
      }
      
      public function get textFlow() : TextFlow
      {
         return _textFlow;
      }
      
      override protected function composeParagraphElement(elem:ParagraphElement, absStart:int) : Boolean
      {
         _curParaElement = elem;
         _curParaStart = absStart;
         _curParaFormat = elem.computedFormat;
         _curElement = elem.getFirstLeaf();
         _curElementStart = _curParaStart;
         return composeParagraphElementIntoLines();
      }
      
      override protected function composeNextLine() : flashx.textLayout.compose.TextFlowLine
      {
         var curLine:flashx.textLayout.compose.TextFlowLine = null;
         var startCompose:int = _curElementStart + _curElementOffset - _curParaStart;
         var prevLine:TextLine = startCompose != 0?this.workingLine.getTextLine():null;
         var finishLineSlug:Rectangle = _parcelList.currentParcel;
         while(true)
         {
            if(true)
            {
               while(true)
               {
                  curLine = this.createTextLine(prevLine,startCompose,_parcelList.getComposeXCoord(finishLineSlug),_parcelList.getComposeYCoord(finishLineSlug),_parcelList.getComposeWidth(finishLineSlug));
                  if(curLine != null)
                  {
                     break;
                  }
                  if(!_parcelList.next())
                  {
                     return null;
                  }
               }
               curLine = fitLineToParcel(curLine,true);
               if(!Boolean(curLine))
               {
                  if(_parcelList.atEnd())
                  {
                     break;
                  }
                  finishLineSlug = _lineSlug;
                  continue;
               }
            }
            this.finalizeLine(curLine);
            return curLine;
         }
         return null;
      }
      
      protected function createTextLine(prevLine:TextLine, lineStart:int, x:Number, y:Number, targetWidth:Number) : flashx.textLayout.compose.TextFlowLine
      {
         var lineOffset:Number = Number(_curParaFormat.paragraphStartIndent);
         if(prevLine == null)
         {
            lineOffset = lineOffset + Number(_curParaFormat.textIndent);
         }
         var outerTargetWidth:Number = targetWidth;
         targetWidth = targetWidth - (Number(_curParaFormat.paragraphEndIndent) + lineOffset);
         targetWidth = targetWidth < 0?Number(0):Number(targetWidth);
         if(targetWidth > TextLine.MAX_LINE_WIDTH)
         {
            targetWidth = TextLine.MAX_LINE_WIDTH;
         }
         var textLine:TextLine = TextLineRecycler.getLineForReuse();
         var textBlock:TextBlock = _curParaElement.getTextBlock();
         if(textLine)
         {
            textLine = swfContext.callInContext(textBlock["recreateTextLine"],textBlock,[textLine,prevLine,targetWidth,lineOffset,true]);
         }
         else
         {
            textLine = swfContext.callInContext(textBlock.createTextLine,textBlock,[prevLine,targetWidth,lineOffset,true]);
         }
         if(textLine == null)
         {
            return null;
         }
         this.workingLine.initialize(_curParaElement,outerTargetWidth,lineOffset,lineStart + _curParaStart,textLine.rawTextLength,textLine);
         return this.workingLine;
      }
      
      tlf_internal function swapLines(lines:Array) : Array
      {
         var current:Array = this._lines;
         this._lines = lines;
         return current;
      }
      
      override protected function finalParcelAdjustment(controller:ContainerController) : void
      {
         var textLine:TextLine = null;
         var leaf:FlowLeafElement = null;
         var para:ParagraphElement = null;
         var inlineAscent:Number = NaN;
         var edgeAdjust:Number = NaN;
         var curParaFormat:ITextLayoutFormat = null;
         var leafStart:int = 0;
         var minX:Number = TextLine.MAX_LINE_WIDTH;
         var minY:Number = TextLine.MAX_LINE_WIDTH;
         var maxX:Number = -TextLine.MAX_LINE_WIDTH;
         var maxY:Number = -TextLine.MAX_LINE_WIDTH;
         var verticalText:Boolean = _blockProgression == BlockProgression.RL;
         var startPos:int = controller.absoluteStart;
         for each(textLine in this._lines)
         {
            leaf = controller.textFlow.findLeaf(startPos);
            para = leaf.getParagraph();
            inlineAscent = 0;
            if(textLine.numChildren > 0)
            {
               leafStart = leaf.getAbsoluteStart();
               inlineAscent = TextFlowLine.getTextLineTypographicAscent(textLine,leaf,leafStart,startPos + textLine.rawTextLength,para);
            }
            edgeAdjust = 0;
            curParaFormat = para.computedFormat;
            if(curParaFormat.direction == Direction.LTR)
            {
               edgeAdjust = curParaFormat.paragraphStartIndent + Math.max(curParaFormat.textIndent,0);
            }
            else
            {
               edgeAdjust = curParaFormat.paragraphEndIndent;
            }
            if(verticalText)
            {
               minX = Math.min(textLine.x - textLine.descent,minX);
               maxX = Math.max(textLine.x + Math.max(inlineAscent,textLine.ascent),maxX);
               minY = Math.min(textLine.y - edgeAdjust,minY);
            }
            else
            {
               if(inlineAscent < textLine.ascent)
               {
                  inlineAscent = textLine.ascent;
               }
               minX = Math.min(textLine.x - edgeAdjust,minX);
               minY = Math.min(textLine.y - inlineAscent,minY);
            }
            startPos = startPos + textLine.rawTextLength;
         }
         if(Boolean(minX != TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(minX - _parcelLeft) >= 1))
         {
            _parcelLeft = minX;
         }
         if(Boolean(maxX != -TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(maxX - _parcelRight) >= 1))
         {
            _parcelRight = maxX;
         }
         if(Boolean(minY != TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(minY - _parcelTop) >= 1))
         {
            _parcelTop = minY;
         }
         if(Boolean(maxY != -TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(maxY - _parcelBottom) >= 1))
         {
            _parcelBottom = maxY;
         }
      }
      
      override tlf_internal function releaseAnyReferences() : void
      {
         super.releaseAnyReferences();
         this.workingLine.initialize(null,0,0,0,0,null);
      }
   }
}

import flashx.textLayout.compose.IVerticalJustificationLine;
import flash.text.engine.TextLine;

class VJHelper implements IVerticalJustificationLine
{
    
   private var _line:TextLine;
   
   private var _height:Number;
   
   function VJHelper(line:TextLine, h:Number)
   {
      super();
      this._line = line;
      this._height = h;
   }
   
   public function get x() : Number
   {
      return this._line.x;
   }
   
   public function set x(val:Number) : void
   {
      this._line.x = val;
   }
   
   public function get y() : Number
   {
      return this._line.y;
   }
   
   public function set y(val:Number) : void
   {
      this._line.y = val;
   }
   
   public function get ascent() : Number
   {
      return this._line.ascent;
   }
   
   public function get descent() : Number
   {
      return this._line.descent;
   }
   
   public function get height() : Number
   {
      return this._height;
   }
}
