package com.beka.util
{
   import com.beka.util.calc.Calc_ew;
   import com.beka.util.calc.Calc_ei;
   import com.beka.util.calc.Calc_tf;
   import com.beka.util.calc.Calc_td;
   import com.beka.util.calc.Calc_ti;
   import com.beka.util.calc.Calc_tw;
   
   public class EECalculator
   {
      
      public static const MAX_ITERATIONS:int = 5000;
       
      private var cew:Calc_ew;
      
      private var cei:Calc_ei;
      
      private var ctf:Calc_tf;
      
      private var ctd:Calc_td;
      
      private var cti:Calc_ti;
      
      private var ctw:Calc_tw;
      
      public function EECalculator()
      {
         super();
         this.cew = new Calc_ew();
         this.cei = new Calc_ei();
         this.ctf = new Calc_tf(this.cei);
         this.ctd = new Calc_td(this.cew);
         this.cti = new Calc_ti(this.cei);
         this.ctw = new Calc_tw(this.cew);
      }
      
      public function getEForTd(p:Number, td:Number, clean:Boolean) : Number
      {
         return this.cew.calculate(p,td,clean);
      }
      
      public function getEForTf(p:Number, tf:Number, clean:Boolean) : Number
      {
         return this.cei.calculate(p,tf,clean);
      }
      
      public function getEForTi(p:Number, t:Number, ti:Number, clean:Boolean) : Number
      {
         return this.cei.calculate(p,ti,clean) - 0.000575 * p * (t - ti);
      }
      
      public function getEForTw(p:Number, t:Number, tw:Number, clean:Boolean) : Number
      {
         return this.cew.calculate(p,tw,clean) - 0.000653 * 1.000944 * p * (t - tw);
      }
      
      public function calc_ew(p:Number, t:Number, clean:Boolean) : Number
      {
         return this.cew.calculate(p,t,clean);
      }
      
      public function calc_ei(p:Number, t:Number, clean:Boolean) : Number
      {
         return this.cei.calculate(p,t,clean);
      }
      
      public function calc_rs(p:Number, t:Number, ew:Number, ei:Number) : Number
      {
         if(ew > p)
         {
            return NaN;
         }
         if(t > 0.01)
         {
            return 621.978 * (ew / (p - ew));
         }
         return 621.978 * (ei / (p - ei));
      }
      
      public function calc_h(t:Number, r:Number) : Number
      {
         var cp_a:Number = NaN;
         var cp_v:Number = NaN;
         var lw:Number = NaN;
         if(r < 0)
         {
            return NaN;
         }
         cp_a = 1.00545;
         cp_v = 1.85894;
         lw = 2500.827;
         return cp_a * t + (lw + cp_v * t) * r / 1000;
      }
      
      public function calc_ti(p:Number, t:Number, e:Number) : Number
      {
         return this.cti.calculate(p,t,e);
      }
      
      public function calc_tw(p:Number, t:Number, e:Number) : Number
      {
         return this.ctw.calculate(p,t,e);
      }
      
      public function calc_qv(p:Number, e:Number) : Number
      {
         return 621.978 * (e / (p - 0.378022 * e));
      }
      
      public function calc_wv(p:Number, e:Number) : Number
      {
         return e / p * 100;
      }
      
      public function calc_dv(t:Number, e:Number) : Number
      {
         t = t + 273.15;
         return 216.673 * (e / t);
      }
      
      public function calc_r(p:Number, e:Number) : Number
      {
         return 621.978 * (e / (p - e));
      }
      
      public function calc_tf(p:Number, e:Number) : Number
      {
         return this.ctf.calculate(p,e);
      }
      
      public function calc_td(p:Number, e:Number) : Number
      {
         return this.ctd.calculate(p,e);
      }
      
      public function calc_ui(e:Number, ei:Number) : Number
      {
         return e / ei * 100;
      }
      
      public function calc_uw(e:Number, ew:Number) : Number
      {
         return e / ew * 100;
      }
   }
}
