package caurina.transitions
{
   public class TweenListObj
   {
       
      public var hasStarted:Boolean;
      
      public var onUpdate:Function;
      
      public var useFrames:Boolean;
      
      public var count:Number;
      
      public var onOverwriteParams:Array;
      
      public var timeStart:Number;
      
      public var timeComplete:Number;
      
      public var onStartParams:Array;
      
      public var onUpdateScope:Object;
      
      public var rounded:Boolean;
      
      public var onUpdateParams:Array;
      
      public var properties:Object;
      
      public var onComplete:Function;
      
      public var transitionParams:Object;
      
      public var updatesSkipped:Number;
      
      public var onStart:Function;
      
      public var onOverwriteScope:Object;
      
      public var skipUpdates:Number;
      
      public var onStartScope:Object;
      
      public var scope:Object;
      
      public var isCaller:Boolean;
      
      public var timePaused:Number;
      
      public var transition:Function;
      
      public var onCompleteParams:Array;
      
      public var onError:Function;
      
      public var timesCalled:Number;
      
      public var onErrorScope:Object;
      
      public var onOverwrite:Function;
      
      public var isPaused:Boolean;
      
      public var waitFrames:Boolean;
      
      public var onCompleteScope:Object;
      
      public function TweenListObj(p_scope:Object, p_timeStart:Number, p_timeComplete:Number, p_useFrames:Boolean, p_transition:Function, p_transitionParams:Object)
      {
         super();
         scope = p_scope;
         timeStart = p_timeStart;
         timeComplete = p_timeComplete;
         useFrames = p_useFrames;
         transition = p_transition;
         transitionParams = p_transitionParams;
         properties = new Object();
         isPaused = false;
         timePaused = undefined;
         isCaller = false;
         updatesSkipped = 0;
         timesCalled = 0;
         skipUpdates = 0;
         hasStarted = false;
      }
      
      public static function makePropertiesChain(p_obj:Object) : Object
      {
         var chainedObject:Object = null;
         var chain:Object = null;
         var currChainObj:Object = null;
         var len:Number = NaN;
         var i:Number = NaN;
         var k:Number = NaN;
         var baseObject:Object = p_obj.base;
         if(baseObject)
         {
            chainedObject = {};
            if(baseObject is Array)
            {
               chain = [];
               for(k = 0; k < baseObject.length; chain.push(baseObject[k]),k++)
               {
               }
            }
            else
            {
               chain = [baseObject];
            }
            chain.push(p_obj);
            len = chain.length;
            for(i = 0; i < len; i++)
            {
               if(chain[i]["base"])
               {
                  currChainObj = AuxFunctions.concatObjects(makePropertiesChain(chain[i]["base"]),chain[i]);
               }
               else
               {
                  currChainObj = chain[i];
               }
               chainedObject = AuxFunctions.concatObjects(chainedObject,currChainObj);
            }
            if(chainedObject["base"])
            {
               delete chainedObject["base"];
            }
            return chainedObject;
         }
         return p_obj;
      }
      
      public function clone(omitEvents:Boolean) : TweenListObj
      {
         var pName:* = null;
         var nTween:TweenListObj = new TweenListObj(scope,timeStart,timeComplete,useFrames,transition,transitionParams);
         nTween.properties = new Array();
         for(pName in properties)
         {
            nTween.properties[pName] = properties[pName].clone();
         }
         nTween.skipUpdates = skipUpdates;
         nTween.updatesSkipped = updatesSkipped;
         if(!omitEvents)
         {
            nTween.onStart = onStart;
            nTween.onUpdate = onUpdate;
            nTween.onComplete = onComplete;
            nTween.onOverwrite = onOverwrite;
            nTween.onError = onError;
            nTween.onStartParams = onStartParams;
            nTween.onUpdateParams = onUpdateParams;
            nTween.onCompleteParams = onCompleteParams;
            nTween.onOverwriteParams = onOverwriteParams;
            nTween.onStartScope = onStartScope;
            nTween.onUpdateScope = onUpdateScope;
            nTween.onCompleteScope = onCompleteScope;
            nTween.onOverwriteScope = onOverwriteScope;
            nTween.onErrorScope = onErrorScope;
         }
         nTween.rounded = rounded;
         nTween.isPaused = isPaused;
         nTween.timePaused = timePaused;
         nTween.isCaller = isCaller;
         nTween.count = count;
         nTween.timesCalled = timesCalled;
         nTween.waitFrames = waitFrames;
         nTween.hasStarted = hasStarted;
         return nTween;
      }
      
      public function toString() : String
      {
         var i:* = null;
         var returnStr:String = "\n[TweenListObj ";
         returnStr = returnStr + ("scope:" + String(scope));
         returnStr = returnStr + ", properties:";
         var isFirst:Boolean = true;
         for(i in properties)
         {
            if(!isFirst)
            {
               returnStr = returnStr + ",";
            }
            returnStr = returnStr + ("[name:" + properties[i].name);
            returnStr = returnStr + (",valueStart:" + properties[i].valueStart);
            returnStr = returnStr + (",valueComplete:" + properties[i].valueComplete);
            returnStr = returnStr + "]";
            isFirst = false;
         }
         returnStr = returnStr + (", timeStart:" + String(timeStart));
         returnStr = returnStr + (", timeComplete:" + String(timeComplete));
         returnStr = returnStr + (", useFrames:" + String(useFrames));
         returnStr = returnStr + (", transition:" + String(transition));
         returnStr = returnStr + (", transitionParams:" + String(transitionParams));
         if(skipUpdates)
         {
            returnStr = returnStr + (", skipUpdates:" + String(skipUpdates));
         }
         if(updatesSkipped)
         {
            returnStr = returnStr + (", updatesSkipped:" + String(updatesSkipped));
         }
         if(Boolean(onStart))
         {
            returnStr = returnStr + (", onStart:" + String(onStart));
         }
         if(Boolean(onUpdate))
         {
            returnStr = returnStr + (", onUpdate:" + String(onUpdate));
         }
         if(Boolean(onComplete))
         {
            returnStr = returnStr + (", onComplete:" + String(onComplete));
         }
         if(Boolean(onOverwrite))
         {
            returnStr = returnStr + (", onOverwrite:" + String(onOverwrite));
         }
         if(Boolean(onError))
         {
            returnStr = returnStr + (", onError:" + String(onError));
         }
         if(onStartParams)
         {
            returnStr = returnStr + (", onStartParams:" + String(onStartParams));
         }
         if(onUpdateParams)
         {
            returnStr = returnStr + (", onUpdateParams:" + String(onUpdateParams));
         }
         if(onCompleteParams)
         {
            returnStr = returnStr + (", onCompleteParams:" + String(onCompleteParams));
         }
         if(onOverwriteParams)
         {
            returnStr = returnStr + (", onOverwriteParams:" + String(onOverwriteParams));
         }
         if(onStartScope)
         {
            returnStr = returnStr + (", onStartScope:" + String(onStartScope));
         }
         if(onUpdateScope)
         {
            returnStr = returnStr + (", onUpdateScope:" + String(onUpdateScope));
         }
         if(onCompleteScope)
         {
            returnStr = returnStr + (", onCompleteScope:" + String(onCompleteScope));
         }
         if(onOverwriteScope)
         {
            returnStr = returnStr + (", onOverwriteScope:" + String(onOverwriteScope));
         }
         if(onErrorScope)
         {
            returnStr = returnStr + (", onErrorScope:" + String(onErrorScope));
         }
         if(rounded)
         {
            returnStr = returnStr + (", rounded:" + String(rounded));
         }
         if(isPaused)
         {
            returnStr = returnStr + (", isPaused:" + String(isPaused));
         }
         if(timePaused)
         {
            returnStr = returnStr + (", timePaused:" + String(timePaused));
         }
         if(isCaller)
         {
            returnStr = returnStr + (", isCaller:" + String(isCaller));
         }
         if(count)
         {
            returnStr = returnStr + (", count:" + String(count));
         }
         if(timesCalled)
         {
            returnStr = returnStr + (", timesCalled:" + String(timesCalled));
         }
         if(waitFrames)
         {
            returnStr = returnStr + (", waitFrames:" + String(waitFrames));
         }
         if(hasStarted)
         {
            returnStr = returnStr + (", hasStarted:" + String(hasStarted));
         }
         returnStr = returnStr + "]\n";
         return returnStr;
      }
   }
}
