/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.CompletionHandler;

public class SingleTaskCompletionSynchronizer
implements CompletionHandler {
    protected int state = 0;
    protected int completionCode;
    protected int theExceptionCC;

    public SingleTaskCompletionSynchronizer() {
        this.theExceptionCC = 0;
    }

    public SingleTaskCompletionSynchronizer(int anExceptionCC) {
        this.theExceptionCC = anExceptionCC;
    }

    protected final boolean inState(int aState) {
        return (this.state & aState) == aState;
    }

    public synchronized int setCompletionCode(int theCompletionCode) {
        if (this.inState(2)) {
            throw new CompletionHandler.ObjectInUse("Completion code has already been set.");
        }
        int observedState = this.state;
        if (this.state == 1) {
            this.notify();
        }
        this.state = 2;
        this.completionCode = theCompletionCode;
        return observedState;
    }

    public synchronized int getCompletionCode(int timeout) {
        if (this.inState(1)) {
            if (this.inState(2)) {
                throw new CompletionHandler.ObjectInUse("The completion code has been retrieved already.");
            }
            throw new CompletionHandler.ObjectInUse("A task is already waiting for the completion.");
        }
        if (this.state != 2) {
            this.state = 1;
            try {
                this.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.state != 2) {
                this.state = 4;
                return this.theExceptionCC;
            }
        }
        this.state = 3;
        return this.completionCode;
    }

    public int getCompletionCode() {
        return this.getCompletionCode(0);
    }

    public synchronized int checkCompletionCode() {
        if (this.inState(2)) {
            return this.completionCode;
        }
        return this.theExceptionCC;
    }

    public int checkState() {
        return this.state;
    }

    public synchronized void recycle() {
        if (!this.inState(3)) {
            throw new CompletionHandler.ObjectInUse("The object is still in use.");
        }
        this.state = 0;
    }
}

