/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.IncorrectUsageException;
import dim.Memory;

public class MutableMemory
extends Memory {
    public MutableMemory() {
        this.dataAddress = 0L;
        this.allocatedSize = 0;
    }

    public MutableMemory(int size) {
        this.dataAddress = MutableMemory.allocateNativeDataBlock(size);
        if (this.dataAddress == 0L) {
            throw new OutOfMemoryError("Native malloc failure");
        }
        this.allocatedSize = size;
    }

    public MutableMemory(Memory source) {
        this.dataAddress = MutableMemory.allocateNativeDataBlock(source.highWaterMark);
        if (this.dataAddress == 0L) {
            throw new OutOfMemoryError("Native malloc failure");
        }
        this.allocatedSize = source.highWaterMark;
        this.copyFromMemory(source);
    }

    protected void finalize() {
        if (this.allocatedSize != 0) {
            MutableMemory.releaseNativeDataBlock(this.dataAddress);
        }
    }

    public void setSize(int size) throws IllegalOffsetException {
        boolean copyIt = false;
        if (size > this.allocatedSize) {
            MutableMemory tmpData = new MutableMemory(size);
            if (this.allocatedSize != 0) {
                MutableMemory.copyNativeDataBlock(tmpData.dataAddress, this.dataAddress, this.highWaterMark);
                MutableMemory.releaseNativeDataBlock(this.dataAddress);
                copyIt = true;
            }
            this.dataAddress = MutableMemory.allocateNativeDataBlock(size);
            if (this.dataAddress == 0L) {
                throw new OutOfMemoryError("Native malloc failure");
            }
            this.allocatedSize = size;
            if (copyIt) {
                MutableMemory.copyNativeDataBlock(this.dataAddress, tmpData.dataAddress, this.highWaterMark);
            }
        }
        this.dataStoreOffset = 0;
        this.dataFetchOffset = 0;
    }

    public MutableMemory setDataStoreOffset(int newOffset) throws IllegalOffsetException {
        if (newOffset < 0 || newOffset > this.allocatedSize) {
            throw new IllegalOffsetException();
        }
        if (newOffset > this.highWaterMark) {
            this.highWaterMark = newOffset;
        }
        this.dataStoreOffset = newOffset;
        return this;
    }

    public MutableMemory moveDataStoreOffset(int delta) throws IllegalOffsetException {
        return this.setDataStoreOffset(this.dataStoreOffset + delta);
    }

    public MutableMemory restoreDataStoreOffset(int delta) {
        this.dataStoreOffset = this.highWaterMark;
        return this;
    }

    public MutableMemory setDataSize(int newSize) throws IllegalOffsetException {
        if (newSize < 0 || newSize > this.allocatedSize) {
            throw new IllegalOffsetException();
        }
        this.highWaterMark = newSize;
        this.dataStoreOffset = newSize;
        return this;
    }

    private static native long allocateNativeDataBlock(int var0);

    private static native void releaseNativeDataBlock(long var0);

    private static native void copyNativeDataBlock(long var0, long var2, int var4);

    private static native void setBoolean(long var0, boolean var2);

    private static native void setChar(long var0, char var2);

    private static native void setByte(long var0, byte var2);

    private static native void setShort(long var0, short var2);

    private static native void setInt(long var0, int var2);

    private static native void setLong(long var0, long var2);

    private static native void setFloat(long var0, float var2);

    private static native void setDouble(long var0, double var2);

    private static native void setString(long var0, String var2);

    private static native void copyFromBooleanArray(long var0, boolean[] var2, int var3, int var4);

    private static native void copyFromCharArray(long var0, char[] var2, int var3, int var4);

    private static native void copyFromByteArray(long var0, byte[] var2, int var3, int var4);

    private static native void copyFromShortArray(long var0, short[] var2, int var3, int var4);

    private static native void copyFromIntArray(long var0, int[] var2, int var3, int var4);

    private static native void copyFromLongArray(long var0, long[] var2, int var3, int var4);

    private static native void copyFromFloatArray(long var0, float[] var2, int var3, int var4);

    private static native void copyFromDoubleArray(long var0, double[] var2, int var3, int var4);

    public MutableMemory copyFromMemory(Memory source) throws NoRoomException {
        if (this.dataStoreOffset + source.highWaterMark > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyNativeDataBlock(this.dataAddress + (long)this.dataStoreOffset, source.dataAddress, source.highWaterMark);
        this.dataStoreOffset += source.highWaterMark;
        this.highWaterMark = this.dataStoreOffset;
        return this;
    }

    public MutableMemory copyBoolean(boolean data) throws NoRoomException {
        if (this.dataStoreOffset + 1 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setBoolean(this.dataAddress + (long)this.dataStoreOffset, data);
        ++this.dataStoreOffset;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyChar(char data) throws NoRoomException {
        if (this.dataStoreOffset + 2 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setChar(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 2;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyByte(byte data) throws NoRoomException {
        if (this.dataStoreOffset + 1 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setByte(this.dataAddress + (long)this.dataStoreOffset, data);
        ++this.dataStoreOffset;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyShort(short data) throws NoRoomException {
        if (this.dataStoreOffset + 2 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setShort(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 2;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyInt(int data) throws NoRoomException {
        if (this.dataStoreOffset + 4 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setInt(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 4;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyLong(long data) throws NoRoomException {
        if (this.dataStoreOffset + 8 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setLong(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 8;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFloat(float data) throws NoRoomException {
        if (this.dataStoreOffset + 4 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setFloat(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 4;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyDouble(double data) throws NoRoomException {
        if (this.dataStoreOffset + 8 > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setDouble(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += 8;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyString(String data) throws NoRoomException {
        int length = data.length() + 1;
        if (this.dataStoreOffset + length > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.setString(this.dataAddress + (long)this.dataStoreOffset, data);
        this.dataStoreOffset += length;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromBooleanArray(boolean[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 1;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromBooleanArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromCharArray(char[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 2;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromCharArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromByteArray(byte[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 1;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromByteArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromShortArray(short[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 2;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromShortArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromIntArray(int[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 4;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromIntArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromLongArray(long[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 8;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromLongArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromFloatArray(float[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 4;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromFloatArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromDoubleArray(double[] array, int arrayOffset, int length) throws NoRoomException {
        int size = length * 8;
        if (this.dataStoreOffset + size > this.allocatedSize) {
            throw new NoRoomException();
        }
        MutableMemory.copyFromDoubleArray(this.dataAddress + (long)this.dataStoreOffset, array, arrayOffset, length);
        this.dataStoreOffset += size;
        if (this.dataStoreOffset > this.highWaterMark) {
            this.highWaterMark = this.dataStoreOffset;
        }
        return this;
    }

    public MutableMemory copyFromBooleanArray(boolean[] array) throws NoRoomException {
        return this.copyFromBooleanArray(array, 0, array.length);
    }

    public MutableMemory copyFromByteArray(byte[] array) throws NoRoomException {
        return this.copyFromByteArray(array, 0, array.length);
    }

    public MutableMemory copyFromCharArray(char[] array) throws NoRoomException {
        return this.copyFromCharArray(array, 0, array.length);
    }

    public MutableMemory copyFromShortArray(short[] array) throws NoRoomException {
        return this.copyFromShortArray(array, 0, array.length);
    }

    public MutableMemory copyFromIntArray(int[] array) throws NoRoomException {
        return this.copyFromIntArray(array, 0, array.length);
    }

    public MutableMemory copyFromLongArray(long[] array) throws NoRoomException {
        return this.copyFromLongArray(array, 0, array.length);
    }

    public MutableMemory copyFromFloatArray(float[] array) throws NoRoomException {
        return this.copyFromFloatArray(array, 0, array.length);
    }

    public MutableMemory copyFromDoubleArray(double[] array) throws NoRoomException {
        return this.copyFromDoubleArray(array, 0, array.length);
    }

    static class NoRoomException
    extends IncorrectUsageException {
        NoRoomException() {
        }

        public String toString() {
            return "There is no more room to accomodate the requested store.";
        }
    }

    class IllegalOffsetException
    extends IncorrectUsageException {
        IllegalOffsetException() {
        }

        public String toString() {
            return "The specified offset exceeds the allocated size of " + MutableMemory.this.allocatedSize;
        }
    }
}

