/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.CompletionHandler;
import dim.SingleTaskCompletionSynchronizer;

public class MultipleTaskCompletionSynchronizer {
    protected int state = 0;
    protected int completionCode;
    protected int theExceptionCC;
    protected CompletionHandler[] theCompletionHandlers = new CompletionHandler[32];

    public MultipleTaskCompletionSynchronizer() {
        this.theExceptionCC = 0;
    }

    public MultipleTaskCompletionSynchronizer(int aNotCompletedCode) {
        this.theExceptionCC = aNotCompletedCode;
    }

    CompletionHandler getCompletionHandler(int identifier, Object taskPointer) {
        SingleTaskCompletionSynchronizer aCompletionHandler = new SingleTaskCompletionSynchronizer();
        this.theCompletionHandlers[identifier] = aCompletionHandler;
        return aCompletionHandler;
    }

    public int wait(int mask, int count) {
        return 0;
    }

    public synchronized int setCompletionCode(int theCompletionCode) {
        int observedState = this.state;
        if ((this.state & 2) != 0) {
            new CompletionHandler.ObjectInUse("Completion Code has been set already.").report();
        }
        if (this.state == 1) {
            this.notify();
        }
        this.state = 2;
        this.completionCode = theCompletionCode;
        return observedState;
    }

    public synchronized int getCompletionCode(int timeout) {
        if (this.state == 1) {
            new CompletionHandler.ObjectInUse("A task is already waiting for the completion.").report();
        }
        if (this.state == 3) {
            new CompletionHandler.ObjectInUse("The completion code has already been retrieved.").report();
        }
        if (this.state != 2) {
            this.state = 1;
            try {
                this.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.state != 2) {
                this.state = 4;
                return this.theExceptionCC;
            }
        }
        this.state = 3;
        return this.completionCode;
    }

    public int getCompletionCode() {
        return this.getCompletionCode(0);
    }

    public synchronized int checkCompletionCode() {
        if ((this.state & 2) != 0) {
            return this.completionCode;
        }
        return this.theExceptionCC;
    }

    public int checkState() {
        return this.state;
    }

    public synchronized void recycle() {
        if (this.state != 3) {
            new CompletionHandler.ObjectInUse("The object has not been CONSUMED yet.").report();
        }
        this.state = 0;
    }
}

