/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.DataDecoder;
import dim.IncorrectUsageException;
import dim.Native;

public class Memory {
    long dataAddress;
    int allocatedSize;
    int dataFetchOffset;
    int dataStoreOffset;
    int highWaterMark;

    static {
        Native.loadNativeLibrary();
    }

    Memory() {
    }

    private void decodeData(long newDataAddress, int newDataSize, DataDecoder theDecoder) {
        this.dataAddress = newDataAddress;
        this.highWaterMark = newDataSize;
        this.dataFetchOffset = 0;
        theDecoder.decodeData(this);
        this.dataAddress = 0L;
        this.highWaterMark = 0;
    }

    public long getDataAddress() {
        return this.dataAddress;
    }

    public int getAllocatedSize() {
        return this.allocatedSize;
    }

    public int getDataSize() {
        return this.highWaterMark;
    }

    public int getDataStoreOffset() {
        return this.dataStoreOffset;
    }

    public int getDataFetchOffset() {
        return this.dataFetchOffset;
    }

    public void setDataFetchOffset(int newDataFetchOffset) throws IllegalOffsetException {
        if (newDataFetchOffset < 0 || newDataFetchOffset > this.highWaterMark) {
            throw new IllegalOffsetException();
        }
        this.dataFetchOffset = newDataFetchOffset;
    }

    public void moveDataFetchOffset(int delta) throws IllegalOffsetException {
        this.setDataFetchOffset(this.dataFetchOffset + delta);
    }

    static native void dumpInternalData(long var0, int var2, int var3);

    public void dumpInternalData(int dumpOptions) {
        Memory.dumpInternalData(this.dataAddress, this.highWaterMark, dumpOptions);
    }

    private static native boolean getBoolean(long var0);

    private static native char getChar(long var0);

    private static native byte getByte(long var0);

    private static native short getShort(long var0);

    private static native int getInt(long var0);

    private static native long getLong(long var0);

    private static native float getFloat(long var0);

    private static native double getDouble(long var0);

    private static native String getString(long var0, int var2);

    private static native void copyIntoBooleanArray(long var0, boolean[] var2, int var3, int var4);

    private static native void copyIntoCharArray(long var0, char[] var2, int var3, int var4);

    private static native void copyIntoByteArray(long var0, byte[] var2, int var3, int var4);

    private static native void copyIntoShortArray(long var0, short[] var2, int var3, int var4);

    private static native void copyIntoIntArray(long var0, int[] var2, int var3, int var4);

    private static native void copyIntoLongArray(long var0, long[] var2, int var3, int var4);

    private static native void copyIntoFloatArray(long var0, float[] var2, int var3, int var4);

    private static native void copyIntoDoubleArray(long var0, double[] var2, int var3, int var4);

    public boolean getBoolean() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 1 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        boolean theData = Memory.getBoolean(this.dataAddress + (long)this.dataFetchOffset);
        ++this.dataFetchOffset;
        return theData;
    }

    public char getChar() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 1 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        char theData = Memory.getChar(this.dataAddress + (long)this.dataFetchOffset);
        ++this.dataFetchOffset;
        return theData;
    }

    public byte getByte() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 1 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        byte theData = Memory.getByte(this.dataAddress + (long)this.dataFetchOffset);
        ++this.dataFetchOffset;
        return theData;
    }

    public short getShort() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 2 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        short theData = Memory.getShort(this.dataAddress + (long)this.dataFetchOffset);
        this.dataFetchOffset += 2;
        return theData;
    }

    public int getInt() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 4 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        int theData = Memory.getInt(this.dataAddress + (long)this.dataFetchOffset);
        this.dataFetchOffset += 4;
        return theData;
    }

    public long getLong() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 8 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        long theData = Memory.getLong(this.dataAddress + (long)this.dataFetchOffset);
        this.dataFetchOffset += 8;
        return theData;
    }

    public float getFloat() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 4 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        float theData = Memory.getFloat(this.dataAddress + (long)this.dataFetchOffset);
        this.dataFetchOffset += 4;
        return theData;
    }

    public double getDouble() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset + 8 > this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        double theData = Memory.getDouble(this.dataAddress + (long)this.dataFetchOffset);
        this.dataFetchOffset += 8;
        return theData;
    }

    public String getString() throws ReadingOutOfBoundException {
        if (this.dataFetchOffset >= this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        String theData = Memory.getString(this.dataAddress + (long)this.dataFetchOffset, 0);
        this.dataFetchOffset += theData.length() + 1;
        return theData;
    }

    public String getString(int max_size) throws ReadingOutOfBoundException {
        if (this.dataFetchOffset >= this.highWaterMark) {
            this.dataFetchOffset = 0;
        }
        String theData = Memory.getString(this.dataAddress + (long)this.dataFetchOffset, 0);
        this.dataFetchOffset += max_size;
        return theData;
    }

    public boolean[] getBooleanArray(int length) throws ReadingOutOfBoundException {
        int size = length * 1;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        boolean[] array = new boolean[length];
        Memory.copyIntoBooleanArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public boolean[] getBooleanArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0) {
            throw new ReadingOutOfBoundException();
        }
        if (this.dataFetchOffset + size > this.highWaterMark) {
            this.highWaterMark = 0;
        }
        boolean[] array = new boolean[size];
        Memory.copyIntoBooleanArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size);
        this.dataFetchOffset += size;
        return array;
    }

    public char[] getCharArray(int length) throws ReadingOutOfBoundException {
        int size = length * 2;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        char[] array = new char[length];
        Memory.copyIntoCharArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public byte[] getByteArray(int length) throws ReadingOutOfBoundException {
        int size = length * 1;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        byte[] array = new byte[length];
        Memory.copyIntoByteArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public byte[] getByteArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0) {
            throw new ReadingOutOfBoundException();
        }
        if (this.dataFetchOffset + size > this.highWaterMark) {
            this.highWaterMark = 0;
        }
        byte[] array = new byte[size];
        Memory.copyIntoByteArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size);
        this.dataFetchOffset += size;
        return array;
    }

    public short[] getShortArray(int length) throws ReadingOutOfBoundException {
        int size = length * 2;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        short[] array = new short[length];
        Memory.copyIntoShortArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public short[] getShortArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0) {
            throw new ReadingOutOfBoundException();
        }
        if (this.dataFetchOffset + size > this.highWaterMark) {
            this.highWaterMark = 0;
        }
        short[] array = new short[size / 2];
        Memory.copyIntoShortArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size / 2);
        this.dataFetchOffset += size;
        return array;
    }

    public int[] getIntArray(int length) throws ReadingOutOfBoundException {
        int size = length * 4;
        if (size < 0) {
            throw new ReadingOutOfBoundException();
        }
        if (this.dataFetchOffset + size > this.highWaterMark) {
            this.highWaterMark = 0;
        }
        int[] array = new int[length];
        Memory.copyIntoIntArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public int[] getIntArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        int[] array = new int[size / 4];
        Memory.copyIntoIntArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size / 4);
        this.dataFetchOffset += size;
        return array;
    }

    public long[] getLongArray(int length) throws ReadingOutOfBoundException {
        int size = length * 8;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        long[] array = new long[length];
        Memory.copyIntoLongArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public long[] getLongArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        long[] array = new long[size / 8];
        Memory.copyIntoLongArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size / 8);
        this.dataFetchOffset += size;
        return array;
    }

    public float[] getFloatArray(int length) throws ReadingOutOfBoundException {
        int size = length * 4;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        float[] array = new float[length];
        Memory.copyIntoFloatArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public float[] getFloatArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0) {
            throw new ReadingOutOfBoundException();
        }
        if (this.dataFetchOffset + size > this.highWaterMark) {
            this.highWaterMark = 0;
        }
        float[] array = new float[size / 4];
        Memory.copyIntoFloatArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size / 4);
        this.dataFetchOffset += size;
        return array;
    }

    public double[] getDoubleArray(int length) throws ReadingOutOfBoundException {
        int size = length * 8;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        double[] array = new double[length];
        Memory.copyIntoDoubleArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, length);
        this.dataFetchOffset += size;
        return array;
    }

    public double[] getDoubleArray() throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        double[] array = new double[size / 8];
        Memory.copyIntoDoubleArray(this.dataAddress + (long)this.dataFetchOffset, array, 0, size / 8);
        this.dataFetchOffset += size;
        return array;
    }

    public String[] getStringArray() throws ReadingOutOfBoundException {
        int len = 0;
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        int offset = this.dataFetchOffset;
        while (size > 0) {
            String str = Memory.getString(this.dataAddress + (long)this.dataFetchOffset, 0);
            this.dataFetchOffset += str.length() + 1;
            size -= str.length() + 1;
            ++len;
        }
        String[] array = new String[len];
        this.dataFetchOffset = offset;
        int i = 0;
        while (i < len) {
            array[i] = Memory.getString(this.dataAddress + (long)this.dataFetchOffset, 0);
            this.dataFetchOffset += array[i].length() + 1;
            ++i;
        }
        return array;
    }

    public String[] getStringArray(int num) throws ReadingOutOfBoundException {
        int size = this.getDataSize();
        if ((size -= this.dataFetchOffset) < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        String[] array = new String[num];
        int i = 0;
        while (i < num) {
            array[i] = Memory.getString(this.dataAddress + (long)this.dataFetchOffset, 0);
            this.dataFetchOffset += array[i].length() + 1;
            if (this.dataFetchOffset > this.highWaterMark) {
                throw new ReadingOutOfBoundException();
            }
            ++i;
        }
        return array;
    }

    public void copyIntoBooleanArray(boolean[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 1;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoBooleanArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoCharArray(char[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 2;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoCharArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoByteArray(byte[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 1;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoByteArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoShortArray(short[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 2;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoShortArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoIntArray(int[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 4;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoIntArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoLongArray(long[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 8;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoLongArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoFloatArray(float[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 4;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoFloatArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public void copyIntoDoubleArray(double[] array, int arrayOffset, int length) throws ReadingOutOfBoundException {
        int size = length * 8;
        if (size < 0 || this.dataFetchOffset + size > this.highWaterMark) {
            throw new ReadingOutOfBoundException();
        }
        Memory.copyIntoDoubleArray(this.dataAddress + (long)this.dataFetchOffset, array, arrayOffset, length);
        this.dataFetchOffset += size;
    }

    public int getSize() {
        int size = this.getDataSize();
        return size -= this.dataFetchOffset;
    }

    static class ReadingOutOfBoundException
    extends IncorrectUsageException {
        ReadingOutOfBoundException() {
        }

        public String toString() {
            return "Attempt to read outside the written area.";
        }
    }

    class IllegalOffsetException
    extends IncorrectUsageException {
        IllegalOffsetException() {
        }

        public String toString() {
            return "The specified offset is outside the written area.";
        }
    }
}

