/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.DimCurrentInfo;
import dim.DimRpcInfo;
import java.util.Vector;

public class DimBrowser {
    static DimRpcInfo dnsRpc = null;
    static String serverAnswer;
    static Vector allServers;
    static String[] allNodes;
    static String[] allPids;
    static DimCurrentInfo serverSrvc;
    static String serviceAnswer;
    static Vector allServices;
    static String[] allQuals;
    static String[] allFormats;

    static {
        allServers = new Vector();
        serverSrvc = null;
        allServices = new Vector();
    }

    private DimBrowser() {
    }

    public static synchronized String[] getServers() {
        serverSrvc = new DimCurrentInfo("DIS_DNS/SERVER_LIST", "__DIM_NO_LINK__"){

            public void infoHandler() {
                serverAnswer = this.getString();
                allPids = this.getString().split("\\|");
                if (serverAnswer.compareTo("__DIM_NO_LINK__") == 0) {
                    serverAnswer = "";
                }
            }
        };
        String[] serverInfo = serverAnswer.length() != 0 ? serverAnswer.split("\\|") : new String[]{};
        allServers.clear();
        allNodes = new String[serverInfo.length];
        int i = 0;
        while (i < serverInfo.length) {
            String[] tmp = serverInfo[i].split("@");
            if (tmp.length == 2) {
                allServers.add(tmp[0]);
                DimBrowser.allNodes[i] = tmp[1];
            }
            ++i;
        }
        return allServers.toArray(new String[0]);
    }

    public static String getServerNode(String server) {
        int index = allServers.indexOf(server);
        if (index >= 0) {
            return allNodes[index];
        }
        return "";
    }

    public static int getServerPid(String server) {
        int pid = 0;
        int index = allServers.indexOf(server);
        if (index >= 0) {
            String pidstr = allPids[index];
            pid = Integer.parseInt(pidstr.trim());
        }
        return pid;
    }

    public static synchronized String[] getServices(String pattern) {
        if (dnsRpc == null) {
            dnsRpc = new DimRpcInfo("DIS_DNS/SERVICE_INFO", "");
        }
        dnsRpc.setData(pattern);
        serviceAnswer = dnsRpc.getString();
        String[] services = serviceAnswer.length() != 0 ? serviceAnswer.split("\n") : new String[]{};
        allQuals = new String[services.length];
        allFormats = new String[services.length];
        allServices.clear();
        int i = 0;
        while (i < services.length) {
            String[] tmp = (String.valueOf(services[i]) + " ").split("\\|");
            if (tmp.length == 3) {
                allServices.add(tmp[0]);
                DimBrowser.allFormats[i] = tmp[1];
                DimBrowser.allQuals[i] = tmp[2].trim();
                services[i] = tmp[0];
            }
            ++i;
        }
        return services;
    }

    public static synchronized boolean isCommand(String service) {
        int index = allServices.indexOf(service);
        if (index == -1) {
            return false;
        }
        return allQuals[index].equals("CMD");
    }

    public static synchronized String getFormat(String service) {
        int index = allServices.indexOf(service);
        if (index == -1) {
            return null;
        }
        return allFormats[index];
    }

    public static void stopBrowsing() {
    }
}

