////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWKIT.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// SQL Database Browser.                                                      //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20250727 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

program sqlook;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 {$IFDEF WINDOWS} shellapi, {$ENDIF}
 sysutils, classes, math,
 Forms, Interfaces, StdCtrls, zcomponent,
 _crw_alloc, _crw_str, _crw_rtc, _crw_fio, _crw_sesman,
 _crw_wmctrl, _crw_apputils, _crw_dbcon, _crw_dbapi,
 form_databasebrowser,
 unit_sqlook;

{$R *.res}

begin
  if not StartSession('$ 1') then
  with SessionManager do begin
   if (DetectRunningPid(0)>0)
   then writeln('SessionManager: ',SessionID,' already running.')
   else writeln('SessionManager: Could not init '+SessionID+'.');
   if (DetectRunningPid(0)>0) then
   if FindAppActivate(SQLookWndClass,SQLookWndTitle,true)
   then writeln('PID ',FindAppPid(SQLookWndClass,SQLookWndTitle),' activated.');
   if (DetectRunningPid(0)=0) then ExitCode:=1;
   Exit;
  end;
  RequireDerivedFormResource:=True;
  Application.Scaled:=True;
  Application.Initialize;
  Application.CreateForm(TFormSQLook,FormSQLook);
  FormSQLook.PrepareForRun;
  Application.Run;
end.

//////////////
// END OF FILE
//////////////

