#!/bin/bash

function alse_repo_mount()(
 function note(){ return 0; };
 echo "##########################################################";
 echo "# Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru";
 echo "##########################################################";
 echo "# Tool to mount Astra Linux Special Edition iso images    ";
 echo "# located in /srv/public/mirror/astra/alse/iso/current    ";
 echo "# into /mnt/repo/alse                                     ";
 echo "##########################################################";
 note "#############################################################################################################################";
 note "# https://stackoverflow.com/questions/1763891/is-it-possible-to-make-stdout-and-stderr-output-be-of-different-colors-in-xterm";
 note "#############################################################################################################################";
 function colorize_norm()( set -o pipefail; ( "$@" 2>&1>&3 | sed $'s,.*,\e[31m&\e[m,'   >&2 ) 3>&1 | sed $'s,.*,\e[32m&\e[m,'   );
 function colorize_bold()( set -o pipefail; ( "$@" 2>&1>&3 | sed $'s,.*,\e[1;31m&\e[m,' >&2 ) 3>&1 | sed $'s,.*,\e[1;32m&\e[m,' );
 function colorize_head()( set -o pipefail; ( "$@" 2>&1>&3 | sed $'s,.*,\e[1;35m&\e[m,' >&2 ) 3>&1 | sed $'s,.*,\e[1;37m&\e[m,' );
 function colorize_none()( "$@"; );
 readonly repo_dir="/mnt/repo/alse";
 readonly repo_lnk="/srv/public/repo";
 readonly iso_dir="/srv/public/mirror/astra/alse/iso/current";
 readonly iso_list="installation.iso installation-di.iso documentation.iso devel.iso extended.iso";
 readonly iso_home="$(realpath -m "$iso_dir")";
 declare -i opt_umount=0;
 colorize_head echo "Try to mount $iso_home to $repo_dir.";
 function print_stderr(){
  1>&2 echo -ne "$1";
 };
 function fatal(){
  if [ -t 1 ] && [ -t 2 ]; then
   colorize_bold print_stderr "\n\n$2\n\n";
  else
   colorize_none print_stderr "\n\n$2\n\n";
  fi;
  exit $1;
 };
 function check_iso_home(){
  colorize_head echo "Check $iso_home:";
  if [ -d "$iso_home" ]; then
   for iso in $iso_list; do
    if [ -f "$(realpath $iso_home/$iso)" ]; then
     colorize_bold echo -ne "Found: "; echo "$iso_home/$iso";
    else
     fatal 1 "Error: not found $iso_home/$iso.";
    fi;
   done;
  else
   fatal 1 "Error: not found $iso_dir";
  fi;
 };
 function make_dir(){
  local dir="$1";
  if [ -z "$dir" ]; then return 1; fi;
  if [ -e "$dir" ]; then
   colorize_bold echo "Already exists: $dir";
   return 0;
  fi;
  colorize_bold sudo -n mkdir -pv "$dir";
 };
 function make_lnk(){
  local dir="$1"; local lnk="$2";
  if [ -z "$dir" ]; then return 1; fi;
  if [ -z "$lnk" ]; then return 1; fi;
  if [ -L "$lnk" ]; then
   if [ "$(realpath -m "$dir")" = "$(realpath -m "$lnk")" ]; then
    echo "Link already exists: $lnk -> $dir";
    return 0;
   fi;
   colorize_bold sudo -n rm -fv "$lnk";
  fi;
  if [ -e "$lnk" ]; then
   colorize_bold print_stderr "Could not create link $lnk.\n";
  else
   colorize_bold sudo -n ln -sv -T "$dir" "$lnk";
  fi;
 };
 function mount_repo_alse(){
  make_dir "$repo_dir";
  make_lnk "$(dirname "$repo_dir")" "$repo_lnk";
  for iso in $iso_list; do
   local item="$(basename $iso .iso)";
   make_dir "$repo_dir/$item";
   if [ $(ls $repo_dir/$item | wc -l) -gt 1 ]; then
    colorize_head sudo -n env LANG=en umount -vd $repo_dir/$item;
   fi;
   if [ $opt_umount -eq 0 ]; then
    colorize_head sudo -n env LANG=en mount $iso_dir/$iso $repo_dir/$item -o loop;
   fi;
  done;
  for iso in $iso_list; do
   local item="$(basename $iso .iso)";
   colorize_head printf "%-30s : %s\n" "$repo_dir/$item" "$(ls $repo_dir/$item | wc -l)";
  done;
  colorize_bold echo -ne "\n\n Done. \n\n"
 };
 function parse_arg(){
  for arg in "$@"; do
   case $arg in
    -h|-help|--help) fatal 0 "$scriptname -m*|--mount|-u|--umount|-h|--help";  ;;
    -m|-mount|--mount)   let opt_umount=0; ;;
    -u|-umount|--umount) let opt_umount=1; ;;
    -*) fatal 1 "Error: unknown option $arg."; ;;
   esac;
  done;
 };
 parse_arg "$@";
 check_iso_home;
 mount_repo_alse;
);
alse_repo_mount -m;
