#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function find_lhelp_dir(){
 local lnk="$(dirname $(realpath $(unix which crwdaq)))/resource/fpcupdeluxe.desktop";
 if [ ! -e "$lnk" ]; then fatal 1 "Error: not found resource/fpcupdeluxe.desktop"; fi;
 local dir="$(dirname $(unix catlnk "$lnk" | grep 'Exec=' | sed 's|Exec=||' | xargs | cut -d ' ' -f 1))";
 if [ ! -d "$dir" ]; then fatal 1 "Error: not found lazarus directory"; fi;
 for f in $(find "$dir/.." -type f -executable -name lhelp); do realpath $(dirname $f); done;
};

function main(){
 local lhelp_dir="$(find_lhelp_dir | head -n 1)";
 if [ -x "$lhelp_dir/lhelp" ]; then
  if pushd "$scriptHOME" > /dev/null 2>&1; then
   cp -fvu $lhelp_dir/lhelp ./linux/;
   cp -fvu $lhelp_dir/lhelp.ico ./linux/;
   if [ ! -d ./linux/languages ]; then mkdir -v ./linux/languages; fi;
   cp -fvu $lhelp_dir/languages/* ./linux/languages/;
  fi;
  popd > /dev/null 2>&1;
 else
  fatal 1 "Error: not found lhelp.";
 fi;
};

main "$@";

##############
## END OF FILE
##############
