#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################
# crwlib_file.sh library to be included into bash scripts.
##########################################################
# Use this library with the 'crwlib_base.sh' library only.
#
# usage:
#  . $(crwkit which crwlib_base.sh)
#  . $(crwkit which crwlib_file.sh)
# or
#  source $(crwkit which crwlib_base.sh)
#  source $(crwkit which crwlib_file.sh)
##########################################################

##########################################################
# Check this script included but not executing directly.
##########################################################
if [ "${FUNCNAME[0]}" = "main" ] || [ -z "${BASH_SOURCE[1]}" ]; then
 1>&2 echo -ne "\n\nError: $(basename ${BASH_SOURCE[0]}) designed as included file but not for direct execution.\n\n";
 exit 1;
fi;

###################################################################
# Check is file description $1 contains any/all words in {$2,$3,…}.
###################################################################
function file_desc_match_any(){
 local desc="$1"; shift;
 if [ -n "$desc" ] && [ -n "$*" ]; then
  for item in $*; do
   if [ -n "$(echo "$desc" | grep -i "\b$item\b")" ]; then return 0; fi;
  done;
 fi;
 return 1;
};
function file_desc_match_all(){
 local desc="$1"; shift;
 if [ -n "$desc" ] && [ -n "$*" ]; then
  for item in $*; do
   if [ -z "$(echo "$desc" | grep -i "\b$item\b")" ]; then return 1; fi;
  done;
  return 0;
 fi;
 return 1;
};

###################################################################
# Check is file $1 description contains any/all words in {$2,$3,…}.
###################################################################
function file_type_match_any(){
 local fname="$1"; shift;
 if [ -e "$fname" ]; then
  local desc="$(file -b -L "$fname")";
  if [ -n "$desc" ] && file_desc_match_any "$desc" $*; then return 0; fi;
 fi;
 return 1;
};
function file_type_match_all(){
 local fname="$1"; shift;
 if [ -e "$fname" ]; then
  local desc="$(file -b -L "$fname")";
  if [ -n "$desc" ] && file_desc_match_all "$desc" $*; then return 0; fi;
 fi;
 return 1;
};

##############
## END OF FILE
##############
