////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zon Fit Edit Ground.                                           //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfiteditground; // Form Spectr Zon Fit Edit Ground

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 lcltype, lclintf,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormSpectrZonFitEditGround }

  TFormSpectrZonFitEditGround = class(TMasterForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Memo1: TMemo;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    UpDown3: TUpDown;
    Label5: TLabel;
    UpDown4: TUpDown;
    UpDown5: TUpDown;
    UpDown6: TUpDown;
    Label6: TLabel;
    procedure EditExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UpDownChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: SmallInt; Direction: TUpDownDirection);
  private
    { Private declarations }
  public
    { Public declarations }
    Zone : TZone;
    procedure UpdatePoly(Pow:Integer; Delta:Double);
  end;

function FormSpectrZonFitEditGroundExecute(Zone:TZone):Integer;

implementation

{$R *.lfm}

function FormSpectrZonFitEditGroundExecute(Zone:TZone):Integer;
const
 TheForm : TFormSpectrZonFitEditGround = nil;
var
 Save : packed record Param:TZonParams; Fixed:TZonFixParams; end;
begin
 Result:=mrCancel;
 if Zone.Ok then
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormSpectrZonFitEditGround, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   TheForm.Zone:=Zone;
   TheForm.Memo1.Text:=RusEng('Фон описывается полиномом:','Background defined as polynom:')+EOL+
                    'Ground(Channel)=G(t)'+EOL+
                    'G(t)=C0+C1*t+C2*t^2+C3*t^3'+EOL+
                    Format('t=(Channel-%d)/%d',[Zone.Left,Zone.Right-Zone.Left+1]);
   TheForm.Edit1.Text:=Format('%g',[Zone.CurrParam.Poly[0]]);
   TheForm.Edit2.Text:=Format('%g',[Zone.CurrParam.Poly[1]]);
   TheForm.Edit3.Text:=Format('%g',[Zone.CurrParam.Poly[2]]);
   TheForm.Edit4.Text:=Format('%g',[Zone.CurrParam.Poly[3]]);
   TheForm.CheckBox1.Checked:=Zone.CurrFixed.Poly[0];
   TheForm.CheckBox2.Checked:=Zone.CurrFixed.Poly[1];
   TheForm.CheckBox3.Checked:=Zone.CurrFixed.Poly[2];
   TheForm.CheckBox4.Checked:=Zone.CurrFixed.Poly[3];
   Save.Param:=Zone.CurrParam;
   Save.Fixed:=Zone.CurrFixed;
   if (mrVoice(TheForm.ShowModal)=mrOk) then begin
    Result:=mrOk;
    SmartStr2Real(TheForm.Edit1.Text,Zone.CurrParam.Poly[0]);
    SmartStr2Real(TheForm.Edit2.Text,Zone.CurrParam.Poly[1]);
    SmartStr2Real(TheForm.Edit3.Text,Zone.CurrParam.Poly[2]);
    SmartStr2Real(TheForm.Edit4.Text,Zone.CurrParam.Poly[3]);
    Zone.CurrFixed.Poly[0]:=TheForm.CheckBox1.Checked;
    Zone.CurrFixed.Poly[1]:=TheForm.CheckBox2.Checked;
    Zone.CurrFixed.Poly[2]:=TheForm.CheckBox3.Checked;
    Zone.CurrFixed.Poly[3]:=TheForm.CheckBox4.Checked;
   end else begin
    Zone.CurrParam:=Save.Param;
    Zone.CurrFixed:=Save.Fixed;
   end;
   TheForm.Zone:=nil;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormSpectrZonFitEditGroundExecute');
 end;
end;

procedure TFormSpectrZonFitEditGround.UpdatePoly(Pow:Integer; Delta:Double);
begin
 if Ok and Zone.Ok and (Pow in [0..MaxZonPoly-1]) then
 try
  Zone.CurrParam.Poly[Pow]:=Zone.CurrParam.Poly[Pow]+Delta;
  Edit1.Text:=Format('%g',[Zone.CurrParam.Poly[0]]);
  Edit2.Text:=Format('%g',[Zone.CurrParam.Poly[1]]);
  Edit3.Text:=Format('%g',[Zone.CurrParam.Poly[2]]);
  Edit4.Text:=Format('%g',[Zone.CurrParam.Poly[3]]);
  Zone.SpecWin.DrawView;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitEditGround.EditExit(Sender: TObject);
begin
 if Ok and Zone.Ok and (Sender is TEdit) then
 try
  SmartStr2Real(Edit1.Text,Zone.CurrParam.Poly[0]);
  SmartStr2Real(Edit2.Text,Zone.CurrParam.Poly[1]);
  SmartStr2Real(Edit3.Text,Zone.CurrParam.Poly[2]);
  SmartStr2Real(Edit4.Text,Zone.CurrParam.Poly[3]);
  Zone.SpecWin.DrawView;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitEditGround.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Редактировать фон зоны','Edit zone background');
 CheckBox1.Caption:=RusEng('Фикс.','Fixed');
 CheckBox2.Caption:=RusEng('Фикс.','Fixed');
 CheckBox3.Caption:=RusEng('Фикс.','Fixed');
 CheckBox4.Caption:=RusEng('Фикс.','Fixed');
 BitBtnOk.Caption:=mrCaption(mrOk);
 BitBtnCancel.Caption:=mrCaption(mrCancel);
end;

procedure TFormSpectrZonFitEditGround.UpDownChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: SmallInt; Direction: TUpDownDirection);
var n,p,d:Integer;
begin
 case Direction of
  updUp:   d:=+1;
  updDown: d:=-1;
  else     Exit;
 end;
 if (Sender is TUpDown) then
 if (ActiveControl is TEdit) then
 if Str2Int(Copy((Sender as TUpDown).Name,Length('UpDown')+1,255),n) then
 if Str2Int(Copy((ActiveControl as TEdit).Name,Length('Edit')+1,255),p) then
 if (n in [1..6]) and (p in [1..4]) then UpdatePoly(p-1,d*Power(10,4-n));
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfiteditground;
begin
end;

procedure Free_form_spectrzonfiteditground;
begin
end;

initialization

 Init_form_spectrzonfiteditground;

finalization

 Free_form_spectrzonfiteditground;

end.

//////////////
// END OF FILE
//////////////

