////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zon Fit Diagnos.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfitdiagnos; // Form Spectr Zon Fit Diagnos

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm, _crw_funmin,
 _crw_curves, _crw_calib, _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrZonFitDiagnos = class(TMasterForm)
    MemoDiagnos: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Win : TFormSpectrZonFitWindow;
    procedure UpdateControls(Flags:Integer);
  end;

procedure OpenFormSpectrZonFitDiagnos(Win:TFormSpectrZonFitWindow);

implementation

{$R *.lfm}

procedure OpenFormSpectrZonFitDiagnos(Win:TFormSpectrZonFitWindow);
begin
 if (Win is TFormSpectrZonFitWindow) then begin
  Application.CreateForm(TFormSpectrZonFitDiagnos, Win.ZonFit.Diagnos);
  if Win.ZonFit.Diagnos.Ok then begin
   (Win.ZonFit.Diagnos as TFormSpectrZonFitDiagnos).Win:=Win;
   Win.ZonFit.Diagnos.Master:=@Win.ZonFit.Diagnos;
   (Win.ZonFit.Diagnos as TFormSpectrZonFitDiagnos).UpdateControls(ucUpdate+ucShow+ucHome);
  end;
 end;
end;

procedure TFormSpectrZonFitDiagnos.UpdateControls(Flags:Integer);
var List:TText;
begin
 if Ok then
 if Win.Ok then
 try
  if HasFlags(Flags,ucUpdate) then begin
   Caption:=Format(RusEng('Диагностика - [%s]','Diagnos - [%s]'),[Win.Caption]);
   List:=NewText;
   Win.ZonFit.Roi.GetDiagnos(List);
   MemoDiagnos.Text:=List.Text;
   Kill(List);
  end;
  if HasFlags(Flags,ucClick) then begin
  end;
  if HasFlags(Flags,ucMarker) then begin
  end;
  if HasFlags(Flags,ucHome) then begin
   Top:=120;
   Left:=250;
   Width:=Screen.Width-250;
  end;
  if HasFlags(Flags,ucShow) then begin
   Show;
   BringToFront;
   WindowState:=wsNormal;
  end;
  if HasFlags(Flags,ucHide) then begin
   Hide;
  end;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitDiagnos.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitdiagnos;
begin
end;

procedure Free_form_spectrzonfitdiagnos;
begin
end;

initialization

 Init_form_spectrzonfitdiagnos;

finalization

 Free_form_spectrzonfitdiagnos;

end.

//////////////
// END OF FILE
//////////////

