////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr PeakIn Preset.                                                 //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231203 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrpeakinpreset; // Form Spectr PeakIn Preset

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_daqsys, _crw_peaksearch,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrPeakInPreset = class(TMasterForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    Edit3: TEdit;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function FormSpectrPeakInPresetExecute:Integer;

implementation

{$R *.lfm}

function FormSpectrPeakInPresetExecute:Integer;
var Form:TFormSpectrPeakInPreset;
begin
 Result:=mrCancel;
 if CanShowModal then
 try
  Application.CreateForm(TFormSpectrPeakInPreset, Form);
  if Form.Ok then
  try
   SetStandardFont(Form);
   SetAllButtonsCursor(Form,crHandPoint);
   LocateFormToCenterOfScreen(Form);
   Form.Caption:=RusEng('Параметры поиска пиков','Peak search parameters');
   Form.Label1.Caption:='Tinp';
   Form.Label2.Caption:='FwMin';
   Form.Label3.Caption:='FwMax';
   Form.Label4.Caption:='Correct_Deriv';
   Form.Label5.Caption:='Delta_Peak_Old';
   Form.Label6.Caption:='Tkf';
   Form.Label7.Caption:='Tkp';
   Form.Label8.Caption:='DeltaFon_Gauss';
   Form.Label9.Caption:='Gauss_Ampl_Border';
   Form.Label10.Caption:='Border_Koef_T';
   Form.BitBtnOk.Caption:=mrCaption(mrOk);
   Form.BitBtnCancel.Caption:=mrCaption(mrCancel);
   Form.Edit1.Text:=Format('%g',[PeakInParams.Tinp]);
   Form.Edit2.Text:=Format('%g',[PeakInParams.FwMin]);
   Form.Edit3.Text:=Format('%g',[PeakInParams.FwMax]);
   Form.Edit4.Text:=Format('%g',[PeakInParams.Correct_Deriv]);
   Form.Edit5.Text:=Format('%g',[PeakInParams.Delta_Peak_Old]);
   Form.Edit6.Text:=Format('%g',[PeakInParams.Tkf]);
   Form.Edit7.Text:=Format('%g',[PeakInParams.Tkp]);
   Form.Edit8.Text:=Format('%g',[PeakInParams.DeltaFon_Gauss]);
   Form.Edit9.Text:=Format('%g',[PeakInParams.Gauss_Ampl_Border]);
   Form.Edit10.Text:=Format('%g',[PeakInParams.Border_Koef_T]);
   if (mrVoice(Form.ShowModal)=mrOk) then begin
    Result:=mrOk;
    SmartStr2Real(Form.Edit1.Text,PeakInParams.Tinp);
    SmartStr2Real(Form.Edit2.Text,PeakInParams.FwMin);
    SmartStr2Real(Form.Edit3.Text,PeakInParams.FwMax);
    SmartStr2Real(Form.Edit4.Text,PeakInParams.Correct_Deriv);
    SmartStr2Real(Form.Edit5.Text,PeakInParams.Delta_Peak_Old);
    SmartStr2Real(Form.Edit6.Text,PeakInParams.Tkf);
    SmartStr2Real(Form.Edit7.Text,PeakInParams.Tkp);
    SmartStr2Real(Form.Edit8.Text,PeakInParams.DeltaFon_Gauss);
    SmartStr2Real(Form.Edit9.Text,PeakInParams.Gauss_Ampl_Border);
    SmartStr2Real(Form.Edit10.Text,PeakInParams.Border_Koef_T);
   end;
  except
   on E:Exception do Daq.Report(E.Message);
  end;
  Kill(TForm(Form));
 except
  on E:Exception do BugReport(E,nil,'FormSpectrPeakInPresetExecute');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrpeakinpreset;
begin
end;

procedure Free_form_spectrpeakinpreset;
begin
end;

initialization

 Init_form_spectrpeakinpreset;

finalization

 Free_form_spectrpeakinpreset;

end.

//////////////
// END OF FILE
//////////////

