////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// PT fonts embedding. Windows only.                                          //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20160426 - Creation & test                                                 //
// 20160916 - Uses FullEmbeddedFontList and TTF files connected via INI file  //
// 20231117 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit ptembed; // PT Fonts embedding routines.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_sect,
 _crw_dynar, _crw_snd, _crw_guard, _crw_fonts;

 // {$DEFINE ptfonts.res}  // Uncomment to use fonts embedded in EXE resources.

 ///////////////////////////////////////////////////////////////////////////////
 // In case of using font resources embedded to EXE file use: brcc32 ptfonts.rc
 // to generate ptfonts.res. Use {$DEFINE ptfonts.res} to add ptfonts.res to EXE.
 ///////////////////////////////////////////////////////////////////////////////
 // ptfonts.rc content:
 ///////////////////////////////////////////////////////////////////////////////
 //  #pragma code_page(1251)
 //  LANGUAGE LANG_NEUTRAL, SUBLANG_NEUTRAL
 //  FONT_TTF_PTM55F RCDATA ..\Resource\Fonts\www.paratype.ru\PTMono\PTM55F.ttf
 //  FONT_TTF_PTM75F RCDATA ..\Resource\Fonts\www.paratype.ru\PTMono\PTM75F.ttf
 //  FONT_TTF_PTN57F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTN57F.ttf
 //  FONT_TTF_PTN77F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTN77F.ttf
 //  FONT_TTF_PTS55F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTS55F.ttf
 //  FONT_TTF_PTS56F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTS56F.ttf
 //  FONT_TTF_PTS75F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTS75F.ttf
 //  FONT_TTF_PTS76F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSans\PTS76F.ttf
 //  FONT_TTF_PTF55F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSerif\PTF55F.ttf
 //  FONT_TTF_PTF56F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSerif\PTF56F.ttf
 //  FONT_TTF_PTF75F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSerif\PTF75F.ttf
 //  FONT_TTF_PTF76F RCDATA ..\Resource\Fonts\www.paratype.ru\PTSerif\PTF76F.ttf
 ///////////////////////////////////////////////////////////////////////////////
 // CRW32.INI content:
 ///////////////////////////////////////////////////////////////////////////////
 //  ;**********************
 //  ;*** Embedded Fonts ***
 //  ;**********************
 //  [EmbeddedFontList]
 //  EmbeddedFont = FONT_TTF_PTM55F
 //  EmbeddedFont = FONT_TTF_PTM75F
 //  EmbeddedFont = FONT_TTF_PTN57F
 //  EmbeddedFont = FONT_TTF_PTN77F
 //  EmbeddedFont = FONT_TTF_PTS55F
 //  EmbeddedFont = FONT_TTF_PTS56F
 //  EmbeddedFont = FONT_TTF_PTS75F
 //  EmbeddedFont = FONT_TTF_PTS76F
 //  EmbeddedFont = FONT_TTF_PTF55F
 //  EmbeddedFont = FONT_TTF_PTF56F
 //  EmbeddedFont = FONT_TTF_PTF75F
 //  EmbeddedFont = FONT_TTF_PTF76F
 //  [EmbeddedFontName]
 //  FONT_TTF_PTM55F = PT Mono
 //  FONT_TTF_PTM75F = PT Mono Bold
 //  FONT_TTF_PTN57F = PT Sans Narrow
 //  FONT_TTF_PTN77F = PT Sans Narrow Bold
 //  FONT_TTF_PTS55F = PT Sans
 //  FONT_TTF_PTS56F = PT Sans Italic
 //  FONT_TTF_PTS75F = PT Sans Bold
 //  FONT_TTF_PTS76F = PT Sans Bold Italic
 //  FONT_TTF_PTF55F = PT Serif
 //  FONT_TTF_PTF56F = PT Serif Italic
 //  FONT_TTF_PTF75F = PT Serif Bold
 //  FONT_TTF_PTF76F = PT Serif Bold Italic
 //  [EmbeddedFontTarget]
 //  FONT_TTF_PTM55F = PTM55F.ttf
 //  FONT_TTF_PTM75F = PTM75F.ttf
 //  FONT_TTF_PTN57F = PTN57F.ttf
 //  FONT_TTF_PTN77F = PTN77F.ttf
 //  FONT_TTF_PTS55F = PTS55F.ttf
 //  FONT_TTF_PTS56F = PTS56F.ttf
 //  FONT_TTF_PTS75F = PTS75F.ttf
 //  FONT_TTF_PTS76F = PTS76F.ttf
 //  FONT_TTF_PTF55F = PTF55F.ttf
 //  FONT_TTF_PTF56F = PTF56F.ttf
 //  FONT_TTF_PTF75F = PTF75F.ttf
 //  FONT_TTF_PTF76F = PTF76F.ttf
 //  [EmbeddedFontSource]
 //  FONT_TTF_PTM55F = Crw32.exe
 //  FONT_TTF_PTM75F = Crw32.exe
 //  FONT_TTF_PTN57F = Crw32.exe
 //  FONT_TTF_PTN77F = Crw32.exe
 //  FONT_TTF_PTS55F = Crw32.exe
 //  FONT_TTF_PTS56F = Crw32.exe
 //  FONT_TTF_PTS75F = Crw32.exe
 //  FONT_TTF_PTS76F = Crw32.exe
 //  FONT_TTF_PTF55F = Crw32.exe
 //  FONT_TTF_PTF56F = Crw32.exe
 //  FONT_TTF_PTF75F = Crw32.exe
 //  FONT_TTF_PTF76F = Crw32.exe
 ///////////////////////////////////////////////////////////////////////////////

 ///////////////////////////////////////////////////////////////////////////////
 // In case of using TTF files use CRW32.INI file to find files
 ///////////////////////////////////////////////////////////////////////////////
 // CRW32.INI content:
 ///////////////////////////////////////////////////////////////////////////////
 //  ;**********************
 //  ;*** Embedded Fonts ***
 //  ;**********************
 //  [EmbeddedFontList]
 //  EmbeddedFont = FONT_TTF_PTM55F
 //  EmbeddedFont = FONT_TTF_PTM75F
 //  EmbeddedFont = FONT_TTF_PTN57F
 //  EmbeddedFont = FONT_TTF_PTN77F
 //  EmbeddedFont = FONT_TTF_PTS55F
 //  EmbeddedFont = FONT_TTF_PTS56F
 //  EmbeddedFont = FONT_TTF_PTS75F
 //  EmbeddedFont = FONT_TTF_PTS76F
 //  EmbeddedFont = FONT_TTF_PTF55F
 //  EmbeddedFont = FONT_TTF_PTF56F
 //  EmbeddedFont = FONT_TTF_PTF75F
 //  EmbeddedFont = FONT_TTF_PTF76F
 //  [EmbeddedFontName]
 //  FONT_TTF_PTM55F = PT Mono
 //  FONT_TTF_PTM75F = PT Mono Bold
 //  FONT_TTF_PTN57F = PT Sans Narrow
 //  FONT_TTF_PTN77F = PT Sans Narrow Bold
 //  FONT_TTF_PTS55F = PT Sans
 //  FONT_TTF_PTS56F = PT Sans Italic
 //  FONT_TTF_PTS75F = PT Sans Bold
 //  FONT_TTF_PTS76F = PT Sans Bold Italic
 //  FONT_TTF_PTF55F = PT Serif
 //  FONT_TTF_PTF56F = PT Serif Italic
 //  FONT_TTF_PTF75F = PT Serif Bold
 //  FONT_TTF_PTF76F = PT Serif Bold Italic
 //  [EmbeddedFontTarget]
 //  FONT_TTF_PTM55F = PTM55F.ttf
 //  FONT_TTF_PTM75F = PTM75F.ttf
 //  FONT_TTF_PTN57F = PTN57F.ttf
 //  FONT_TTF_PTN77F = PTN77F.ttf
 //  FONT_TTF_PTS55F = PTS55F.ttf
 //  FONT_TTF_PTS56F = PTS56F.ttf
 //  FONT_TTF_PTS75F = PTS75F.ttf
 //  FONT_TTF_PTS76F = PTS76F.ttf
 //  FONT_TTF_PTF55F = PTF55F.ttf
 //  FONT_TTF_PTF56F = PTF56F.ttf
 //  FONT_TTF_PTF75F = PTF75F.ttf
 //  FONT_TTF_PTF76F = PTF76F.ttf
 //  [EmbeddedFontSource]
 //  FONT_TTF_PTM55F = Resource\Fonts\www.paratype.ru\PTMono\PTM55F.ttf
 //  FONT_TTF_PTM75F = Resource\Fonts\www.paratype.ru\PTMono\PTM75F.ttf
 //  FONT_TTF_PTN57F = Resource\Fonts\www.paratype.ru\PTSans\PTN57F.ttf
 //  FONT_TTF_PTN77F = Resource\Fonts\www.paratype.ru\PTSans\PTN77F.ttf
 //  FONT_TTF_PTS55F = Resource\Fonts\www.paratype.ru\PTSans\PTS55F.ttf
 //  FONT_TTF_PTS56F = Resource\Fonts\www.paratype.ru\PTSans\PTS56F.ttf
 //  FONT_TTF_PTS75F = Resource\Fonts\www.paratype.ru\PTSans\PTS75F.ttf
 //  FONT_TTF_PTS76F = Resource\Fonts\www.paratype.ru\PTSans\PTS76F.ttf
 //  FONT_TTF_PTF55F = Resource\Fonts\www.paratype.ru\PTSerif\PTF55F.ttf
 //  FONT_TTF_PTF56F = Resource\Fonts\www.paratype.ru\PTSerif\PTF56F.ttf
 //  FONT_TTF_PTF75F = Resource\Fonts\www.paratype.ru\PTSerif\PTF75F.ttf
 //  FONT_TTF_PTF76F = Resource\Fonts\www.paratype.ru\PTSerif\PTF76F.ttf
 ///////////////////////////////////////////////////////////////////////////////

procedure TheSystemFontsInit;
procedure ScreenFontsUpdate;

implementation

{$IFDEF WINDOWS}

{$IFDEF ptfonts.res} {$R ptfonts.res} {$ENDIF}

procedure Print(const S:LongString);
begin
 DebugOut(stdfDebug,S);
end;

procedure PrintFonts(Charset,Pitch:Integer; const Fonts:AnsiString);
var List:TStringList; i,m:Integer; S:LongString;
const MaxLen = 80;
begin
 List:=TStringList.Create;
 try
  Print(Format('TheSystemFonts[%s=%d,%s=%d]:',
        [CharsetToString(Charset),Charset,PitchToString(Pitch),Pitch]));
  S:=''; m:=0;
  List.Sorted:=True;
  List.Duplicates:=dupIgnore;
  List.Text:=TheSystemFonts; for i:=0 to List.Count-1 do m:=Max(m,Length(List[i]));
  List.Text:=Fonts;          for i:=0 to List.Count-1 do m:=Max(m,Length(List[i]));
  if m=0 then Print('Not found fonts of this kind.');
  if m>0 then
  for i:=0 to List.Count-1 do begin
   S:=S+Format('%-*s'#9,[m,List[i]]);
   if (Length(S)>=MaxLen) or (i=List.Count-1) then begin Print(S); S:=''; end;
  end;
  Print('');
 finally
  List.Free;
 end;
end;

procedure TheSystemFontsInit;
var Charset,Pitch:Integer; i,em,sm,en,sn:LongInt;
begin
 try
  em:=0; sm:=0;
  Print('');
  Print('TheSystemFonts initialization:');
  Print('******************************');
  for Charset:=ANSI_CHARSET to OEM_CHARSET do
  for Pitch:=DEFAULT_PITCH to VARIABLE_PITCH do
  if (Charset in AvailFontCharsets) and (Pitch in AvailFontPitches)
  then PrintFonts(Charset,Pitch,TheSystemFonts(Charset,Pitch));
  Print('');
  Print('Embedded fonts initialization:');
  Print('******************************');
  if not ReadIniFileLongInt(SysIniFile,SectSystem,'PtFontsEmbeddingMode%d',em)
  then em:=0;
  if not ReadIniFileLongInt(SysIniFile,SectSystem,'PtFontsSavingMode%d',sm)
  then sm:=0;
  Print(Format('PtFontsEmbeddingMode = %d',[em]));
  Print(Format('PtFontsSavingMode = %d',[sm]));
  FullEmbeddedFontList.FontKill;
  FullEmbeddedFontList.ReadIniFile(SysIniFile);
  case em of
   1:   FullEmbeddedFontList.FontEmbed;
   2:   FullEmbeddedFontList.SmartEmbed;
   else Print('Skip PT fonts embedding.');
  end;
  en:=FullEmbeddedFontList.Embedded;
  if sm=1 then sn:=FullEmbeddedFontList.FontSave(True,True) else sn:=0;
  Print(Format('%d font(s) embedded, %d fonts(s) saved to %s.',[en,sn,GetSystemFontsPath]));
  for i:=0 to FullEmbeddedFontList.Count-1 do
  Print(Format('%s : %-20s : %s : %s : %d embedded, %d found',[
        FullEmbeddedFontList[i].NickName,
        FullEmbeddedFontList[i].FontName,
        FullEmbeddedFontList[i].FontTarget,
        FullEmbeddedFontList[i].FontSource,
        FullEmbeddedFontList[i].Embedded,
        FullEmbeddedFontList[i].Found]));
  FullEmbeddedFontList.DataFree; Print('Resources unloaded.');
 except
  on E:Exception do BugReport(E,nil,'TheSystemFontsInit');
 end;
end;

procedure ScreenFontsUpdate;
var i:Integer;
begin
 try
  for i:=0 to FullEmbeddedFontList.Count-1 do
  if (FullEmbeddedFontList[i].Embedded>0) then
  if Screen.Fonts.IndexOf(FullEmbeddedFontList[i].FontFamily)<0 then
  Screen.Fonts.Add(FullEmbeddedFontList[i].FontFamily);
 except
  on E:Exception do BugReport(E,nil,'ScreenFontsUpdate');
 end;
end;
{$ENDIF ~WINDOWS}

{$IFDEF UNIX}
procedure TheSystemFontsInit;
begin
end;

procedure ScreenFontsUpdate;
begin
end;
{$ENDIF ~UNIX}

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_ptembed;
begin
end;

procedure Free_ptembed;
begin
 {$IFDEF WINDOWS}
 FullEmbeddedFontList.FontKill;
 {$ENDIF ~WINDOWS}
end;

initialization

 Init_ptembed;

finalization

 Free_ptembed;

end.

//////////////
// END OF FILE
//////////////

