////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Create New Data Analysis Plugin.                                      //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_createnewdataanalysisplugin; // Form Create New Data Analysis Plugin

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCreateNewDataAnalysisPlugin = class(TMasterForm)
    PanelControls: TPanel;
    PanelButtons: TPanel;
    GroupBoxListBox: TGroupBox;
    ListBox: TListBox;
    GroupBoxName: TGroupBox;
    EditName: TEdit;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    function  isGoodName:Boolean;
  public
    { Public declarations }
  end;

function EnterNewDataAnalysisPluginName(const PluginList:LongString;
                                        var Template:LongString;
                                        var PluginName:LongString;
                                        Params:LongString=''):TModalResult;
implementation

{$R *.lfm}

function EnterNewDataAnalysisPluginName(const PluginList:LongString;
                                        var Template:LongString;
                                        var PluginName:LongString;
                                        Params:LongString=''):TModalResult;
const
 TheForm : TFormCreateNewDataAnalysisPlugin = nil;
begin
 Result:=mrCancel;
 Template:='';
 PluginName:='';
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormCreateNewDataAnalysisPlugin, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then with TheForm do begin
   ListBox.Items.Text:=PluginList;
   if (ListBox.Items.Count>0) then ListBox.ItemIndex:=0;
   EditName.Text:='new_plugin';
   if (Params<>'') then ApplyParams(Params);
   if (ShowModal=mrOk) then begin
    if InRange(ListBox.ItemIndex,0,ListBox.Items.Count-1)
    then Template:=ListBox.Items[ListBox.ItemIndex];
    PluginName:=LowerCase(Trim(EditName.Text));
    if (Length(Template)>0) and (Length(PluginName)>0)
    then Result:=mrOk;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'EnterNewDataAnalysisPluginName');
 end;
end;

procedure TFormCreateNewDataAnalysisPlugin.FormCreate(Sender: TObject);
begin
 inherited;
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(GroupBoxListBox,RusEng('Выбрать в качестве шаблона утилиту:','Use as template next plugins:'));
 SmartUpdate(GroupBoxName,RusEng('Задать имя создаваемой утилиты:','Set name of plugin to create:'));
 Caption:=RusEng('Создание утилиты анализа данных','Create data analysis plugin');
 EditName.Text:='new_plugin';
end;

procedure TFormCreateNewDataAnalysisPlugin.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 if (ModalResult=mrOk) then CanClose:=isGoodName;
end;

function  TFormCreateNewDataAnalysisPlugin.isGoodName:Boolean;
var
 i : Integer;
begin
 Result:=false;
 EditName.Text:=Trim(EditName.Text);
 if IsEmptyStr(EditName.Text) then begin
  Warning(RusEng('Имя не задано!','Name is not specified!'));
  ActiveControl:=EditName;
  Exit;
 end;
 if not IsLexeme(EditName.Text,lex_Name) then begin
  Warning(RusEng('Имя недопустимо!','Name is invalid!'));
  ActiveControl:=EditName;
  Exit;
 end;
 for i:=0 to ListBox.Items.Count-1 do
 if SameText(UnifyAlias(ListBox.Items[i]),UnifyAlias(EditName.Text)) then begin
  Warning(RusEng('Утилита с таким именем уже есть!','Plugin with such name is already exists!'));
  ActiveControl:=EditName;
  Exit;
 end;
 Result:=true;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_createnewdataanalysisplugin;
begin
end;

procedure Free_form_createnewdataanalysisplugin;
begin
end;

initialization

 Init_form_createnewdataanalysisplugin;

finalization

 Free_form_createnewdataanalysisplugin;

end.

//////////////
// END OF FILE
//////////////

