////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form CRW-DAQ LOGO.                                                         //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20201123 - Converted from CRW32 by A.K.                                    //
////////////////////////////////////////////////////////////////////////////////

unit form_crwdaqlogo; // Form CRW-DAQ LOGO

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 _crw_alloc, _crw_str, _crw_eldraw,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCrwDaqLogo = class(TMasterForm)
    PanelImage: TPanel;
    Image: TImage;
    PanelLogo: TPanel;
    LabelLogo: TLabel;
    LabelCopyright: TLabel;
    LabelMail: TLabel;
    BitBtnExit: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtnExitClick(Sender: TObject);
  private
    { Private declarations }
    myCloseAction : TCloseAction;
  public
    { Public declarations }
  end;

procedure ShowFormCrwDaqLogo(const aCaption :LongString='CRW-DAQ LOGO';
                             const aLogoText:LongString='';
                             const aFileName:LongString='';
                                   aVisible:Boolean=False);
procedure HideFormCrwDaqLogo;
procedure KillFormCrwDaqLogo;

const // Splash screen
 SolidCrwDaqLogo : Boolean = False;

implementation

{$R *.lfm}

uses
 Form_CrwDaq;

const
  FormCrwDaqLogo: TFormCrwDaqLogo = nil;

procedure ShowFormCrwDaqLogo(const aCaption :LongString='CRW-DAQ LOGO';
                             const aLogoText:LongString='';
                             const aFileName:LongString='';
                                   aVisible:Boolean=False);
begin
 try
  if not FormCrwDaqLogo.Ok then begin
   Application.CreateForm(TFormCrwDaqLogo, FormCrwDaqLogo);
   FormCrwDaqLogo.Master:=@FormCrwDaqLogo;
  end;
  if FormCrwDaqLogo.Ok then with FormCrwDaqLogo do begin
   if FileExists(aFileName) then begin
    Image.Picture.LoadFromFile(aFileName);
    Image.Stretch:=(Image.Picture.Width>Image.Width) or (Image.Picture.Height>Image.Height);
    FormCrwDaqLogo.LocateToCenterOfScreen;
    LabelLogo.Caption:=aLogoText;
    WindowState:=wsNormal;
    Caption:=aCaption;
    Visible:=aVisible;
    BringToFront;
    Update;
    SafeApplicationProcessMessages;
   end else Hide;
  end;
 except
  on E:Exception do BugReport(E,nil,'ShowFormCrwDaqLogo');
 end;
end;

procedure HideFormCrwDaqLogo;
begin
 try
  if FormCrwDaqLogo.Ok then begin
   FormCrwDaqLogo.Caption:='CRW-DAQ LOGO';
   FormCrwDaqLogo.Image.Picture.Assign(nil);
   FormCrwDaqLogo.WindowState:=wsMinimized;
   FormCrwDaqLogo.Hide;
  end;
 except
  on E:Exception do BugReport(E,nil,'HideFormCrwDaqLogo');
 end;
end;

procedure KillFormCrwDaqLogo;
begin
 Kill(TForm(FormCrwDaqLogo));
end;

procedure TFormCrwDaqLogo.FormCreate(Sender: TObject);
begin
 inherited;
 myCloseAction:=caHide;
 Icon:=Application.Icon;
end;

procedure TFormCrwDaqLogo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action:=myCloseAction;
end;

procedure TFormCrwDaqLogo.BitBtnExitClick(Sender: TObject);
begin
 myCloseAction:=caFree;
 Close;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_crwdaqlogo;
begin
end;

procedure Free_form_crwdaqlogo;
begin
end;

initialization

 Init_form_crwdaqlogo;

finalization

 Free_form_crwdaqlogo;

end.

//////////////
// END OF FILE
//////////////

