////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Win Oper Dialog.                                                  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231202 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqwinoperdialog; // Form DAQ Win Oper Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 lcltype, lclintf, CheckLst,
 Form_TabWindow, Form_CurveWindow,
 Form_CircuitWindow, Form_SpectrWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_daqsys,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormDaqWinOperDialog }

  TFormDaqWinOperDialog = class(TMasterForm)
    CheckListBoxWho: TCheckListBox;
    GroupBoxWho: TGroupBox;
    PanelWhatWho: TPanel;
    PanelWinOper: TPanel;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    GroupBoxMonitorPeriod: TGroupBox;
    LabelCurveMonitorPeriod: TLabel;
    LabelTableMonitorPeriod: TLabel;
    LabelCircuitMonitorPeriod: TLabel;
    LabelSpectrMonitorPeriod: TLabel;
    RadioGroupWhat: TRadioGroup;
    SpinEditCurveMonitorPeriod: TSpinEdit;
    SpinEditTableMonitorPeriod: TSpinEdit;
    SpinEditCircuitMonitorPeriod: TSpinEdit;
    SpinEditSpectrMonitorPeriod: TSpinEdit;
    ButtonSetMonitorPeriod: TButton;
    ButtonResetMonitorPeriod: TButton;
    GroupBoxDaqTopList: TGroupBox;
    LabelDaqTopListHead: TLabel;
    SpinEditCurveTopListLimit: TSpinEdit;
    SpinEditTableTopListLimit: TSpinEdit;
    SpinEditCircuitTopListLimit: TSpinEdit;
    SpinEditSpectrTopListLimit: TSpinEdit;
    LabelCurveTopListLimit: TLabel;
    LabelTableTopListLimit: TLabel;
    LabelCircuitTopListLimit: TLabel;
    LabelSpectrTopListLimit: TLabel;
    LabelDaqTopListPeriod: TLabel;
    SpinEditDaqTopListPeriod: TSpinEdit;
    LabelDaqTopListComment: TLabel;
    LabelDaqTopListZeroComment: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ButtonSetMonitorPeriodClick(Sender: TObject);
    procedure ButtonResetMonitorPeriodClick(Sender: TObject);
    procedure BitBtnOkClick(Sender: TObject);
    procedure BitBtnCancelClick(Sender: TObject);
    procedure SpinEditCurveMonitorPeriodChange(Sender: TObject);
    procedure SpinEditTableMonitorPeriodChange(Sender: TObject);
    procedure SpinEditCircuitMonitorPeriodChange(Sender: TObject);
    procedure SpinEditSpectrMonitorPeriodChange(Sender: TObject);
    procedure SpinEditCurveTopListLimitChange(Sender: TObject);
    procedure SpinEditTableTopListLimitChange(Sender: TObject);
    procedure SpinEditCircuitTopListLimitChange(Sender: TObject);
    procedure SpinEditSpectrTopListLimitChange(Sender: TObject);
    procedure SpinEditDaqTopListPeriodChange(Sender: TObject);
  private
    { Private declarations }
    myCurWinMonPer : Integer;
    myTabWinMonPer : Integer;
    myCirWinMonPer : Integer;
    mySpeWinMonPer : Integer;
  public
    { Public declarations }
  end;

function  FormDaqWinOperDialogExecute(var What,Who:Integer; const Params:LongString=''):Integer;
procedure KillFormDaqWinOperDialog;

implementation

uses
 Form_CrwDaqSysChild;

{$R *.lfm}

const
  FormDaqWinOperDialog : TFormDaqWinOperDialog = nil;

function FormDaqWinOperDialogExecute(var What,Who:Integer; const Params:LongString=''):Integer;
var i:Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormDaqWinOperDialog) then
 try
  if not Assigned(FormDaqWinOperDialog) then begin
   Application.CreateForm(TFormDaqWinOperDialog, FormDaqWinOperDialog);
   FormDaqWinOperDialog.Master:=@FormDaqWinOperDialog;
  end;
  if Assigned(FormDaqWinOperDialog) then with FormDaqWinOperDialog do begin
   myCurWinMonPer:=Daq.MonitorPeriod[wtCurWin];
   myTabWinMonPer:=Daq.MonitorPeriod[wtTabWin];
   myCirWinMonPer:=Daq.MonitorPeriod[wtCirWin];
   mySpeWinMonPer:=Daq.MonitorPeriod[wtSpeWin];
   SpinEditCurveMonitorPeriod.Value:=myCurWinMonPer;
   SpinEditTableMonitorPeriod.Value:=myTabWinMonPer;
   SpinEditCircuitMonitorPeriod.Value:=myCirWinMonPer;
   SpinEditSpectrMonitorPeriod.Value:=mySpeWinMonPer;
   SpinEditCurveTopListLimit.Value:=CurveTopListLimit;
   SpinEditTableTopListLimit.Value:=TableTopListLimit;
   SpinEditCircuitTopListLimit.Value:=CircuitTopListLimit;
   SpinEditSpectrTopListLimit.Value:=SpectrTopListLimit;
   SpinEditDaqTopListPeriod.Value:=DaqTopListPeriod;
   if IsNonEmptyStr(Params) then ApplyParams(Params);
   if (mrVoice(ShowModal)=mrOk) then begin
    Result:=mrOk;
    What:=RadioGroupWhat.ItemIndex;
    Who:=0;
    for i:=0 to CheckListBoxWho.Items.Count-1 do
    if CheckListBoxWho.Checked[i] then Who:=Who or (Integer(1) shl i);
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqWinOperDialogExecute');
 end;
end;

procedure KillFormDaqWinOperDialog;
begin
 Kill(TObject(FormDaqWinOperDialog));
end;

procedure TFormDaqWinOperDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Операции с окнами DAQ','DAQ windows operations');
 RadioGroupWhat.Caption:=RusEng('Что сделать','What to do');
 RadioGroupWhat.Items.Text:=RusEng('Показать'+EOL+ {0}
                                   'Открыть'+EOL+  {1}
                                   'Восстан.'+EOL+ {2}
                                   'Спрятать'+EOL+ {3}
                                   'Закрыть'+EOL+  {4}
                                   'Сохран.',      {5}
                                   'Show'+EOL+     {0}
                                   'Open'+EOL+     {1}
                                   'Load pos'+EOL+ {2}
                                   'Hide'+EOL+     {3}
                                   'Close'+EOL+    {4}
                                   'Save pos');    {5}
 GroupBoxWho.Caption:=RusEng('Над чем сделать','Destination');
 CheckListBoxWho.Items.Text:=RusEng('Окна - графики'+EOL+
                                    'Окна - таблицы'+EOL+
                                    'Окна - мнемосхемы'+EOL+
                                    'Окна - спектры',
                                    'Curve   windows'+EOL+
                                    'Table   windows'+EOL+
                                    'Circuit windows'+EOL+
                                    'Spectr  windows');
 GroupBoxMonitorPeriod.Caption:=RusEng('Период обновления, миллисекунд','Update period, msec');
 LabelCurveMonitorPeriod.Caption:=RusEng('Графики','Curves');
 LabelTableMonitorPeriod.Caption:=RusEng('Таблицы','Tables');
 LabelCircuitMonitorPeriod.Caption:=RusEng('Мнемосхемы','Circuits');
 LabelSpectrMonitorPeriod.Caption:=RusEng('Спектры','Spectrums');
 ButtonSetMonitorPeriod.Caption:=RusEng('Принять новые','Accept new');
 ButtonResetMonitorPeriod.Caption:=RusEng('Вернуть начальные','Restore initial');
 GroupBoxDaqTopList.Caption:=RusEng('Топ-лист отображения окон','Top-list of visible windows');
 LabelDaqTopListHead.Caption:=RusEng('Прятать все (лишние) окна, кроме топ-листа:','Hide (excess) windows except top-list:');
 LabelCurveTopListLimit.Caption:=RusEng('Графики','Curves');
 LabelTableTopListLimit.Caption:=RusEng('Таблицы','Tables');
 LabelCircuitTopListLimit.Caption:=RusEng('Мнемосхемы','Circuits');
 LabelSpectrTopListLimit.Caption:=RusEng('Спектры','Spectrums');
 LabelDaqTopListPeriod.Caption:=RusEng('Период проверки, сек.','Checking period, sec.');
 LabelDaqTopListZeroComment.Caption:=RusEng(' 0 = запрет.',' O = disable.');
 LabelDaqTopListZeroComment.Font.Style:=[fsBold];
 LabelDaqTopListZeroComment.Font.Color:=clNavy;
 LabelDaqTopListComment.Caption:=RusEng('Топ-лист ограничивает число одновременно видимых окон заданным числом.',
                                        'Top-list limited number of simultaneously opened windows as specified.');
 LabelDaqTopListComment.Font.Name:=DefaultSansNarrowFont.Name;
 LabelDaqTopListComment.Font.Size:=9;
 LabelDaqTopListComment.Font.Color:=clGray;
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

procedure TFormDaqWinOperDialog.ButtonSetMonitorPeriodClick(Sender: TObject);
begin
 if Ok and Daq.Ok then
 try
  Daq.MonitorPeriod[wtCurWin]:=SpinEditCurveMonitorPeriod.Value;
  Daq.MonitorPeriod[wtTabWin]:=SpinEditTableMonitorPeriod.Value;
  Daq.MonitorPeriod[wtCirWin]:=SpinEditCircuitMonitorPeriod.Value;
  Daq.MonitorPeriod[wtSpeWin]:=SpinEditSpectrMonitorPeriod.Value;
 except
  on E:Exception do BugReport(E,Self,'ButtonSetMonitorPeriodClick');
 end;
end;

procedure TFormDaqWinOperDialog.ButtonResetMonitorPeriodClick(Sender: TObject);
begin
 if Ok and Daq.Ok then
 try
  SpinEditCurveMonitorPeriod.Value:=myCurWinMonPer;
  SpinEditTableMonitorPeriod.Value:=myTabWinMonPer;
  SpinEditCircuitMonitorPeriod.Value:=myCirWinMonPer;
  SpinEditSpectrMonitorPeriod.Value:=mySpeWinMonPer;
  ButtonSetMonitorPeriodClick(Sender);
 except
  on E:Exception do BugReport(E,Self,'ButtonResetMonitorPeriodClick');
 end;
end;

procedure TFormDaqWinOperDialog.BitBtnOkClick(Sender: TObject);
begin
 ButtonSetMonitorPeriodClick(Sender);
end;

procedure TFormDaqWinOperDialog.BitBtnCancelClick(Sender: TObject);
begin
 ButtonResetMonitorPeriodClick(Sender);
end;

function GetStepByValue(Value:Integer):Integer;
begin
 Result:=1;
 if Value>=4     then Result:=2;
 if Value>=10    then Result:=5;
 if Value>=40    then Result:=20;
 if Value>=100   then Result:=50;
 if Value>=400   then Result:=200;
 if Value>=1000  then Result:=500;
 if Value>=4000  then Result:=2000;
 if Value>=10000 then Result:=5000;
 if Value>=40000 then Result:=20000;
end;

procedure TFormDaqWinOperDialog.SpinEditCurveMonitorPeriodChange(Sender: TObject);
begin
 try
  if (Sender is TSpinEdit) then with TSpinEdit(Sender) do Increment:=GetStepByValue(Value);
 except
  on E:Exception do BugReport(E,Self,'SpinEditCurveMonitorPeriodChange');
 end;
end;

procedure TFormDaqWinOperDialog.SpinEditTableMonitorPeriodChange(Sender: TObject);
begin
 try
  if (Sender is TSpinEdit) then with TSpinEdit(Sender) do Increment:=GetStepByValue(Value);
 except
  on E:Exception do BugReport(E,Self,'SpinEditTableMonitorPeriodChange');
 end;
end;

procedure TFormDaqWinOperDialog.SpinEditCircuitMonitorPeriodChange(Sender: TObject);
begin
 try
  if (Sender is TSpinEdit) then with TSpinEdit(Sender) do Increment:=GetStepByValue(Value);
 except
  on E:Exception do BugReport(E,Self,'SpinEditCircuitMonitorPeriodChange');
 end;
end;

procedure TFormDaqWinOperDialog.SpinEditSpectrMonitorPeriodChange(Sender: TObject);
begin
 try
  if (Sender is TSpinEdit) then with TSpinEdit(Sender) do Increment:=GetStepByValue(Value);
 except
  on E:Exception do BugReport(E,Self,'SpinEditSpectrMonitorPeriodChange');
 end;
end;

procedure TFormDaqWinOperDialog.SpinEditCurveTopListLimitChange(Sender: TObject);
begin
 CurveTopListLimit:=SpinEditCurveTopListLimit.Value;
end;

procedure TFormDaqWinOperDialog.SpinEditTableTopListLimitChange(Sender: TObject);
begin
 TableTopListLimit:=SpinEditTableTopListLimit.Value;
end;

procedure TFormDaqWinOperDialog.SpinEditCircuitTopListLimitChange(Sender: TObject);
begin
 CircuitTopListLimit:=SpinEditCircuitTopListLimit.Value;
end;

procedure TFormDaqWinOperDialog.SpinEditSpectrTopListLimitChange(Sender: TObject);
begin
 SpectrTopListLimit:=SpinEditSpectrTopListLimit.Value;
end;

procedure TFormDaqWinOperDialog.SpinEditDaqTopListPeriodChange(Sender: TObject);
begin
 DaqTopListPeriod:=SpinEditDaqTopListPeriod.Value;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqwinoperdialog;
begin
end;

procedure Free_form_daqwinoperdialog;
begin
end;

initialization

 Init_form_daqwinoperdialog;

finalization

 Free_form_daqwinoperdialog;

end.

//////////////
// END OF FILE
//////////////

