////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Median Filter Dialog.                                             //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqmedianfilterdialog; // Form DAQ Median Filter Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Spin,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqMedianFilterDialog = class(TMasterForm)
    PanelParams: TPanel;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    LabelWidth: TLabel;
    LabelAbsEps: TLabel;
    LabelRelEps: TLabel;
    SpinEditWidth: TSpinEdit;
    EditAbsEps: TEdit;
    EditRelEps: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure LabelWidthClick(Sender: TObject);
    procedure LabelAbsEpsClick(Sender: TObject);
    procedure LabelRelEpsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function  FormDaqMedianFilterDialogExecute(var aWidth:Integer; var aAbsEps,aRelEps:Double; const Params:LongString=''):Integer;
procedure KillFormDaqMedianFilterDialog;

implementation

{$R *.lfm}

const
  FormDaqMedianFilterDialog : TFormDaqMedianFilterDialog = nil;

function FormDaqMedianFilterDialogExecute(var aWidth:Integer; var aAbsEps,aRelEps:Double; const Params:LongString=''):Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormDaqMedianFilterDialog) then
 try
  if not Assigned(FormDaqMedianFilterDialog) then begin
   Application.CreateForm(TFormDaqMedianFilterDialog, FormDaqMedianFilterDialog);
   FormDaqMedianFilterDialog.Master:=@FormDaqMedianFilterDialog;
  end;
  if FormDaqMedianFilterDialog.Ok then with FormDaqMedianFilterDialog do begin
   aWidth:=0;
   aAbsEps:=0;
   aRelEps:=0;
   if IsNonEmptyStr(Params) then ApplyParams(Params);
   if (mrVoice(ShowModal)=mrOk) then
   if Str2Int(SpinEditWidth.Text,aWidth) then
   if Str2Real(EditAbsEps.Text,aAbsEps) then
   if Str2Real(EditRelEps.Text,aRelEps) then Result:=mrOk;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqMedianFilterDialogExecute');
 end;
end;

procedure KillFormDaqMedianFilterDialog;
begin
 Kill(TObject(FormDaqMedianFilterDialog));
end;

procedure TFormDaqMedianFilterDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Медианный фильтр','Median filter');
 LabelWidth.Caption:=RusEng('Полуширина','Halfwidth');
 LabelAbsEps.Caption:=RusEng('Абс. порог','Abs.threshold');
 LabelRelEps.Caption:=RusEng('Отн. порог','Rel.threshold');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

procedure TFormDaqMedianFilterDialog.LabelWidthClick(Sender: TObject);
begin
 SmartFocus(SpinEditWidth);
end;

procedure TFormDaqMedianFilterDialog.LabelAbsEpsClick(Sender: TObject);
begin
 SmartFocus(EditAbsEps);
end;

procedure TFormDaqMedianFilterDialog.LabelRelEpsClick(Sender: TObject);
begin
 SmartFocus(EditRelEps);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqmedianfilterdialog;
begin
end;

procedure Free_form_daqmedianfilterdialog;
begin
end;

initialization

 Init_form_daqmedianfilterdialog;

finalization

 Free_form_daqmedianfilterdialog;

end.

//////////////
// END OF FILE
//////////////

