////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Device Common Property Dialog.                                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231202 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqdevicecommonpropertydialog; // Form DAQ Device Common Property Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Printers,
 lcltype, lclintf, Spin,
 Form_CrwDaqSysChild,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_ef,
 _crw_curves, _crw_pio, _crw_calib, _crw_couple,
 _crw_daqdev, _crw_polling, _crw_riff,
 _crw_daqtags, _crw_daqevnt, _crw_daqsys,
 _crw_softdev,
 _crw_adamdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqDeviceCommonPropertyDialog = class(TDaqDeviceCommonPropertyDialog)
    GroupBoxInquiryPeriod: TGroupBox;
    SpinEditInquiryPeriod: TSpinEdit;
    LabelInquiryPeriod: TLabel;
    GroupBoxAOParams: TGroupBox;
    LabelAONum: TLabel;
    ComboBoxAONum: TComboBox;
    LabelAOAbsTol: TLabel;
    EditAOAbsTol: TEdit;
    LabelAORelTol: TLabel;
    EditAORelTol: TEdit;
    LabelAOHistLen: TLabel;
    SpinEditAOHistLen: TSpinEdit;
    GroupBoxDOParams: TGroupBox;
    LabelDONum: TLabel;
    ComboBoxDONum: TComboBox;
    LabelDOHistLen: TLabel;
    SpinEditDOHistLen: TSpinEdit;
    GroupBoxAIParams: TGroupBox;
    LabelAINum: TLabel;
    ComboBoxAINum: TComboBox;
    LabelAIWindow: TLabel;
    EditAIWindow: TEdit;
    LabelAIMethod: TLabel;
    ComboBoxAIMethod: TComboBox;
    LabelAIK1: TLabel;
    SpinEditAIK1: TSpinEdit;
    LabelAIK2: TLabel;
    SpinEditAIK2: TSpinEdit;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    BitBtnClose: TBitBtn;
    SpinEditDevicePolling: TSpinEdit;
    LabelDevicePolling: TLabel;
    ComboBoxDevicePriority: TComboBox;
    LabelDevicePriority: TLabel;
    ComboBoxDeviceState: TComboBox;
    LabelDeviceState: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtnOkClick(Sender: TObject);
    procedure BitBtnCancelClick(Sender: TObject);
    procedure ComboBoxAONumChange(Sender: TObject);
    procedure ComboBoxDONumChange(Sender: TObject);
    procedure ComboBoxAINumChange(Sender: TObject);
  private
    { Private declarations }
    myHaveToUpdate : Boolean;
  public
    { Public declarations }
    procedure UpdateControls(Flags:Integer);
    function  HaveToUpdate:Boolean;
  end;

function NewFormDaqDeviceCommonPropertyDialog(aDevice:TDaqDevice):TFormDaqDeviceCommonPropertyDialog;

implementation

{$R *.lfm}

function NewFormDaqDeviceCommonPropertyDialog(aDevice:TDaqDevice):TFormDaqDeviceCommonPropertyDialog;
begin
 Result:=nil;
 if (aDevice is TDaqDevice) then begin
  Application.CreateForm(TFormDaqDeviceCommonPropertyDialog, Result);
  Result.LinkedDevice:=aDevice;
  Result.UpdateControls(1);
  Result.UpdateControls(2);
 end;
end;

procedure TFormDaqDeviceCommonPropertyDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 myHaveToUpdate:=false;
end;

procedure TFormDaqDeviceCommonPropertyDialog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action:=caFree;
 mrVoice(mrCancel);
end;

procedure TFormDaqDeviceCommonPropertyDialog.BitBtnOkClick(Sender: TObject);
begin
 UpdateControls(4);
 UpdateControls(2);
 mrVoice(mrOk);
end;

procedure TFormDaqDeviceCommonPropertyDialog.BitBtnCancelClick(Sender: TObject);
begin
 UpdateControls(2);
 mrVoice(mrCancel);
end;

procedure TFormDaqDeviceCommonPropertyDialog.ComboBoxAONumChange(Sender: TObject);
begin
 UpdateControls(2);
end;

procedure TFormDaqDeviceCommonPropertyDialog.ComboBoxDONumChange(Sender: TObject);
begin
 UpdateControls(2);
end;

procedure TFormDaqDeviceCommonPropertyDialog.ComboBoxAINumChange(Sender: TObject);
begin
 UpdateControls(2);
end;

procedure TFormDaqDeviceCommonPropertyDialog.UpdateControls(Flags:Integer);
var i,j,k:Integer; a,r:Double; tp:TThreadPriority;
 function CrvId(crv:TCurve):LongString;
 begin
  if Assigned(crv) and crv.Ok
  then Result:=Format(' - %s',[crv.Name])
  else Result:='';
 end;
 procedure ChooseComboFont(Combo:TComboBox);
 var i,w:Integer;
 begin
  w:=0;
  if Assigned(Combo) then begin
   for i:=0 to Combo.Items.Count-1 do w:=Max(w,Canvas.TextWidth(Combo.Items[i])+16);
   if (w>Combo.Width*2) then RestoreFont(Combo.Font,DefaultSansNarrowFont) else
   if (w>Combo.Width*1) then RestoreFont(Combo.Font,DefaultSansFont) else
   RestoreFont(Combo.Font,StandardFont);
  end;
 end;
begin
 if Ok then
 if LinkedDevice.Ok then
 try
  {}
  if HasFlags(Flags,1) then begin
   {}
   Caption:=RusEng('Общие свойства ','Common property ')+LinkedDevice.Name;
   GroupBoxInquiryPeriod.Caption:=RusEng('Опрос устройства','Device polling');
   LabelInquiryPeriod.Caption:='InquiryPeriod, ms';
   LabelDevicePolling.Caption:='DevicePolling, ms';
   LabelDevicePriority.Caption:=RusEng('Приоритет потока','Thread priority');
   LabelDeviceState.Caption:=RusEng('Состояние устройства','Device state');
   GroupBoxAOParams.Caption:=RusEng('Округление данных','Data rounding');
   LabelAONum.Caption:=RusEng('Выход','Output');
   LabelAOAbsTol.Caption:=RusEng('Абсолют.','Absolute');
   LabelAORelTol.Caption:=RusEng('Относит.','Relative');
   LabelAOHistLen.Caption:=RusEng('История','History');
   GroupBoxDOParams.Caption:=RusEng('Цифровой набор','Digital outputs');
   LabelDONum.Caption:=RusEng('Выход','Output');
   LabelDOHistLen.Caption:=RusEng('История','History');
   GroupBoxAIParams.Caption:=RusEng('Сглаживание данных','Data smoothing');
   LabelAINum.Caption:=RusEng('Вход','Input');
   LabelAIWindow.Caption:=RusEng('Окно сглаж.','Window');
   LabelAIMethod.Caption:=RusEng('Метод','Method');
   LabelAIK1.Caption:=RusEng('Ядро сглаживания (1-x^','Smoothing kernel (1-x^');
   LabelAIK2.Caption:=')^';
   BitBtnOk.Caption:=RusEng('Принять','Accept');
   BitBtnCancel.Caption:=mrCaption(mrCancel);
   BitBtnClose.Caption:=RusEng('Закрыть','Close');
   {}
   ComboBoxDeviceState.Items.Clear;
   ComboBoxDeviceState.Items.Add(RusEng('Остановлено','Stopped'));
   ComboBoxDeviceState.Items.Add(RusEng('Работает','Running'));
   ComboBoxDeviceState.ItemIndex:=0;
   ComboBoxDeviceState.Enabled:=false;
   {}
   ComboBoxDevicePriority.Items.Clear;
   for tp:=Low(tp) to High(tp) do ComboBoxDevicePriority.Items.Add(GetPriorityName(tp));
   ComboBoxDevicePriority.ItemIndex:=ord(tpNormal)-ord(Low(TThreadPriority));
   {}
   ComboBoxAONum.Items.Text:='';
   for i:=0 to LinkedDevice.NumAnalogOutputs-1 do begin
    if (LinkedDevice.NumSecondaryAnalogOutputs>1) then begin
     LinkedDevice.UnpackAnalogOutputIndex(i,j,k);
     ComboBoxAONum.Items.Add(Format('AO %2d %2d %s',[j,k,CrvId(LinkedDevice.AnalogOutputCurve[i])]));
    end else begin
     ComboBoxAONum.Items.Add(Format('AO %2d %s',[i,CrvId(LinkedDevice.AnalogOutputCurve[i])]));
    end;
   end;
   ChooseComboFont(ComboBoxAONum);
   if (ComboBoxAONum.Items.Count=0) then ComboBoxAONum.Items.Add(RusEng('(нет)','(none)'));
   ComboBoxAONum.ItemIndex:=0;
   {}
   ComboBoxDONum.Items.Text:='';
   for i:=0 to LinkedDevice.NumDigitalOutputs-1 do begin
    ComboBoxDONum.Items.Add(Format('DO %2d %s',[i,CrvId(LinkedDevice.DigitalOutputCurve[i])]));
   end;
   ChooseComboFont(ComboBoxDONum);
   if (ComboBoxDONum.Items.Count=0) then ComboBoxDONum.Items.Add(RusEng('(нет)','(none)'));
   ComboBoxDONum.ItemIndex:=0;
   {}
   ComboBoxAINum.Items.Text:='';
   for i:=0 to LinkedDevice.NumAnalogInputs-1 do begin
    ComboBoxAINum.Items.Add(Format('AI %2d %s',[i,CrvId(LinkedDevice.AnalogInputCurve[i])]));
   end;
   ChooseComboFont(ComboBoxAINum);
   if (ComboBoxAINum.Items.Count=0) then ComboBoxAINum.Items.Add(RusEng('(нет)','(none)'));
   ComboBoxAINum.ItemIndex:=0;
   ComboBoxAIMethod.Items.Text:='';
   ComboBoxAIMethod.Items.Add(RusEng('скользящий интеграл','gliding integral   '));
   ComboBoxAIMethod.Items.Add(RusEng('скользящее среднее ','-|- averaging      '));
   ComboBoxAIMethod.Items.Add(RusEng('-|- полином 1 степ.','-|- polynom 1 power'));
   ComboBoxAIMethod.Items.Add(RusEng('-|- полином 2 степ.','-|- polynom 2 power'));
   ComboBoxAIMethod.Items.Add(RusEng('-|- полином 3 степ.','-|- polynom 3 power'));
   ComboBoxAIMethod.Items.Add(RusEng('-|- полином 4 степ.','-|- polynom 4 power'));
   ComboBoxAIMethod.Items.Add(RusEng('-|- полином 5 степ.','-|- polynom 5 power'));
   ComboBoxAIMethod.ItemIndex:=0;
  end;
  {}
  if HasFlags(Flags,2) then begin
   {}
   SpinEditInquiryPeriod.Value:=Round(LinkedDevice.InquiryTimer.IntervalMs[0]);
   {}
   ComboBoxDeviceState.ItemIndex:=ord(LinkedDevice.InquiryTimer.isStart);
   if (LinkedDevice is TSoftwareDevice) then begin
    ComboBoxDevicePriority.Enabled:=true;
    SpinEditDevicePolling.Enabled:=true;
    ComboBoxDevicePriority.ItemIndex:=ord(TSoftwareDevice(LinkedDevice).Polling.Priority)-ord(Low(TThreadPriority));
    SpinEditDevicePolling.Value:=TSoftwareDevice(LinkedDevice).Polling.Delay;
   end else begin
    ComboBoxDevicePriority.Enabled:=false;
    SpinEditDevicePolling.Enabled:=false;
    ComboBoxDevicePriority.ItemIndex:=ord(tpNormal)-ord(Low(TThreadPriority));
    SpinEditDevicePolling.Value:=10;
   end;
   {}
   if (LinkedDevice.NumAnalogOutputs>0) then begin
    k:=ComboBoxAONum.ItemIndex;
    if (LinkedDevice.AnalogOutputCompressor[k]<>nil) then begin
     EditAOAbsTol.Text:=Format('%g',[LinkedDevice.AnalogOutputCompressor[k].AbsTol]);
     EditAORelTol.Text:=Format('%g',[LinkedDevice.AnalogOutputCompressor[k].RelTol]);
    end else begin
     EditAOAbsTol.Text:='0';
     EditAORelTol.Text:='0';
    end;
    SpinEditAOHistLen.Value:=LinkedDevice.AnalogOutputHistoryLen[k];
   end else begin
    EditAOAbsTol.Text:='0';
    EditAORelTol.Text:='0';
    SpinEditAOHistLen.Value:=0;
   end;
   {}
   if (LinkedDevice.NumDigitalOutputs>0) then begin
    k:=ComboBoxDONum.ItemIndex;
    SpinEditDOHistLen.Value:=LinkedDevice.DigitalOutputHistoryLen[k];
   end else begin
    SpinEditDOHistLen.Value:=0;
   end;
   {}
   if (LinkedDevice.NumAnalogInputs>0) then begin
    k:=ComboBoxAINum.ItemIndex;
    if (LinkedDevice.AnalogInputSmoother[k]<>nil) then begin
     EditAIWindow.Text:=Format('%g',[LinkedDevice.AnalogInputSmoother[k].Window]);
     ComboBoxAIMethod.ItemIndex:=max(0,min(6,LinkedDevice.AnalogInputSmoother[k].Power+1));
     SpinEditAIK1.Value:=max(0,min(5,LinkedDevice.AnalogInputSmoother[k].K1));
     SpinEditAIK2.Value:=max(0,min(5,LinkedDevice.AnalogInputSmoother[k].K2));
    end else begin
     EditAIWindow.Text:='0';
     ComboBoxAIMethod.ItemIndex:=0;
     SpinEditAIK1.Value:=0;
     SpinEditAIK2.Value:=0;
    end;
   end else begin
    EditAIWindow.Text:='0';
    ComboBoxAIMethod.ItemIndex:=0;
    SpinEditAIK1.Value:=0;
    SpinEditAIK2.Value:=0;
   end;
  end;
  {}
  if HasFlags(Flags,4) then begin
   {}
   LinkedDevice.InquiryTimer.IntervalMs[0]:=max(0,SpinEditInquiryPeriod.Value);
   {}
   if (LinkedDevice is TSoftwareDevice) then begin
    TSoftwareDevice(LinkedDevice).Polling.Priority:=GetPriorityByName(ComboBoxDevicePriority.Text);
    TSoftwareDevice(LinkedDevice).Polling.Delay:=Max(1,SpinEditDevicePolling.Value);
   end;
   {}
   if (LinkedDevice.NumAnalogOutputs>0) then begin
    k:=ComboBoxAONum.ItemIndex;
    if Str2Real(EditAOAbsTol.Text,a) and Str2Real(EditAORelTol.Text,r) then begin
     a:=max(0,a);
     r:=max(0,r);
     if (LinkedDevice.AnalogOutputCompressor[k]<>nil) then begin
      if (a>0) or (r>0) then begin
       LinkedDevice.AnalogOutputCompressor[k].AbsTol:=a;
       LinkedDevice.AnalogOutputCompressor[k].RelTol:=r;
      end else begin
       LinkedDevice.AnalogOutputCompressor[k]:=nil;
      end;
     end else begin
      if (a>0) or (r>0) then LinkedDevice.AnalogOutputCompressor[k]:=NewDaqCompressor(a,r);
     end;
    end;
    LinkedDevice.AnalogOutputHistoryLen[k]:=max(0,SpinEditAOHistLen.Value);
   end;
   {}
   if (LinkedDevice.NumDigitalOutputs>0) then begin
    k:=ComboBoxDONum.ItemIndex;
    LinkedDevice.DigitalOutputHistoryLen[k]:=max(0,SpinEditDOHistLen.Value);
   end;
   {}
   if LinkedDevice.NumAnalogInputs>0 then begin
    k:=ComboBoxAINum.ItemIndex;
    if Str2Real(EditAIWindow.Text,a) then begin
     a:=max(0,a);
     if (LinkedDevice.AnalogInputSmoother[k]<>nil) then begin
      if (a>0) then begin
       LinkedDevice.AnalogInputSmoother[k].Window:=a;
       LinkedDevice.AnalogInputSmoother[k].Power:=ComboBoxAIMethod.ItemIndex-1;
       LinkedDevice.AnalogInputSmoother[k].K1:=SpinEditAIK1.Value;
       LinkedDevice.AnalogInputSmoother[k].K2:=SpinEditAIK2.Value;
      end else begin
       LinkedDevice.AnalogInputSmoother[k]:=nil;
      end;
     end else begin
      if a>0 then LinkedDevice.AnalogInputSmoother[k]:=NewDaqSmoother(a,ComboBoxAIMethod.ItemIndex-1,
                                                                        SpinEditAIK1.Value,SpinEditAIK2.Value);
     end;
    end;
   end;
   {}
   myHaveToUpdate:=true;
  end;
 except
  on E:Exception do begin
    BugReport(E,Self,'UpdateControls');
    Daq.ConsoleEcho(E.Message);
  end;
 end;
end;

function TFormDaqDeviceCommonPropertyDialog.HaveToUpdate:Boolean;
begin
 if Assigned(Self) then begin
  Result:=myHaveToUpdate;
  myHaveToUpdate:=false;
 end else Result:=false;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqdevicecommonpropertydialog;
begin
end;

procedure Free_form_daqdevicecommonpropertydialog;
begin
end;

initialization

 Init_form_daqdevicecommonpropertydialog;

finalization

 Free_form_daqdevicecommonpropertydialog;

end.

//////////////
// END OF FILE
//////////////

