////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve Tools.                                                          //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231125 - Modified for FPC (A.K.)                                         //
// 20240625 - Change size for nice view                                       //
////////////////////////////////////////////////////////////////////////////////

unit form_curvetools; // Form Curve Tools

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCurveTools = class(TMasterForm)
    {
    General components
    }
    ActionList: TActionList;
    ImageList: TImageList;
    ToolBar1: TToolBar;
    {
    Actions
    }
    ActionFileSave: TAction;
    ActionFileSaveAs: TAction;
    ActionFilePrint: TAction;
    ActionFilePrinterSetup: TAction;
    ActionCurveMouseSelector: TAction;
    ActionCurveMouseZoomIn: TAction;
    ActionCurveMouseZoomOut: TAction;
    ActionCurveMouseDragCopy: TAction;
    ActionCurveMouseDragMove: TAction;
    ActionCurveMouseSelectRoiL: TAction;
    ActionCurveMouseSelectRoiR: TAction;
    ActionCurveMouseClearRoiL: TAction;
    ActionCurveMouseClearRoiR: TAction;
    ActionCurveRangeAuto: TAction;
    ActionCurveRangeSelector: TAction;
    ActionCurveRangeZoomIn: TAction;
    ActionCurveRangeZoomOut: TAction;
    ActionCurveRangeLeft: TAction;
    ActionCurveRangeRight: TAction;
    ActionCurveRangeUp: TAction;
    ActionCurveRangeDown: TAction;
    ActionCurveEditDelete: TAction;
    ActionCurveEditCut: TAction;
    ActionCurveEditCopy: TAction;
    ActionCurveEditPaste: TAction;
    ActionCurveEditSelect0: TAction;
    ActionCurveEditSelect1: TAction;
    ActionCurveEditSelect2: TAction;
    ActionCurveEditSelect3: TAction;
    ActionCurveEditSelect4: TAction;
    ActionCurveEditSelect5: TAction;
    ActionCurveEditSelect6: TAction;
    ActionCurveEditSelect7: TAction;
    ActionCurveEditSelect8: TAction;
    ActionCurveEditSelect9: TAction;
    ActionCurveEditSelectMore: TAction;
    ActionCurveEditCloneWindow: TAction;
    ActionCurveEditComment: TAction;
    ActionCurveEditStyle: TAction;
    ActionCurveEditWindowStyle: TAction;
    ActionCurveEditDownSampling: TAction;
    ActionCurveToolsRunMacroDialog: TAction;
    ActionCurveToolsRunPluginDialog: TAction;
    ActionCurveToolsWriteTable: TAction;
    ActionCurveToolsComposeSurface: TAction;
    {
    Toolbars
    }
    ToolButtonCurveToolsRunMacroDialog: TToolButton;
    ToolButtonFileSave: TToolButton;
    ToolButtonFileSaveAs: TToolButton;
    ToolButtonFilePrint: TToolButton;
    ToolButtonFilePrinterSetup: TToolButton;
    ToolButtonCurveEditDelete: TToolButton;
    ToolButtonCurveEditCut: TToolButton;
    ToolButtonCurveEditCopy: TToolButton;
    ToolButtonCurveEditPaste: TToolButton;
    ToolButtonCurveToolsRunPluginDialog: TToolButton;
    ToolButtonSeparator1: TToolButton;
    ToolButtonSeparator2: TToolButton;
    ToolButtonSeparator3: TToolButton;
    ToolButtonSeparator4: TToolButton;
    ToolButtonCurveMouseSelector: TToolButton;
    ToolButtonCurveMouseZoomIn: TToolButton;
    ToolButtonCurveMouseZoomOut: TToolButton;
    ToolButtonCurveMouseDragCopy: TToolButton;
    ToolButtonSeparator5: TToolButton;
    ToolButtonCurveMouseDragMove: TToolButton;
    ToolButtonSeparator6: TToolButton;
    ToolButtonCurveMouseSelectRoiL: TToolButton;
    ToolButtonCurveMouseSelectRoiR: TToolButton;
    ToolButtonSeparator7: TToolButton;
    ToolButtonCurveMouseClearRoiL: TToolButton;
    ToolButtonCurveMouseClearRoiR: TToolButton;
    ToolButtonSeparator8: TToolButton;
    ToolButtonCurveRangeAuto: TToolButton;
    ToolButtonRangeSelector: TToolButton;
    ToolButtonSeparator10: TToolButton;
    ToolButtonRangeZoomIn: TToolButton;
    ToolButtonRangeZoomOut: TToolButton;
    ToolButtonSeparator9: TToolButton;
    ToolButtonCurveRangeLeft: TToolButton;
    ToolButtonCurveRangeRight: TToolButton;
    ToolButtonCurveRangeUp: TToolButton;
    ToolButtonCurveRangeDown: TToolButton;
    ToolButtonCurveEditWindowStyle: TToolButton;
    ToolButtonCurveEditDownSampling: TToolButton;
    ToolButtonSeparator11: TToolButton;
    ToolButtonSeparator12: TToolButton;
    ToolButtonCurveEditSelectMore: TToolButton;
    ToolButtonCurveEditCloneWindow: TToolButton;
    ToolButtonCurveEditComment: TToolButton;
    ToolButtonCurveEditStyle: TToolButton;
    ToolButtonCurveToolsWriteTable: TToolButton;
    ToolButtonCurveToolsComposeSurface: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure ActionListUpdate(Action: TBasicAction; var Handled: Boolean);
    procedure ActionFileSaveExecute(Sender: TObject);
    procedure ActionFileSaveAsExecute(Sender: TObject);
    procedure ActionFilePrintExecute(Sender: TObject);
    procedure ActionFilePrinterSetupExecute(Sender: TObject);
    procedure ActionCurveMouseSelectorExecute(Sender: TObject);
    procedure ActionCurveMouseZoomInExecute(Sender: TObject);
    procedure ActionCurveMouseZoomOutExecute(Sender: TObject);
    procedure ActionCurveMouseDragCopyExecute(Sender: TObject);
    procedure ActionCurveMouseDragMoveExecute(Sender: TObject);
    procedure ActionCurveMouseSelectRoiLExecute(Sender: TObject);
    procedure ActionCurveMouseSelectRoiRExecute(Sender: TObject);
    procedure ActionCurveMouseClearRoiLExecute(Sender: TObject);
    procedure ActionCurveMouseClearRoiRExecute(Sender: TObject);
    procedure ActionCurveRangeAutoExecute(Sender: TObject);
    procedure ActionCurveRangeSelectorExecute(Sender: TObject);
    procedure ActionCurveRangeZoomInExecute(Sender: TObject);
    procedure ActionCurveRangeZoomOutExecute(Sender: TObject);
    procedure ActionCurveRangeLeftExecute(Sender: TObject);
    procedure ActionCurveRangeRightExecute(Sender: TObject);
    procedure ActionCurveRangeUpExecute(Sender: TObject);
    procedure ActionCurveRangeDownExecute(Sender: TObject);
    procedure ActionCurveEditDeleteExecute(Sender: TObject);
    procedure ActionCurveEditCutExecute(Sender: TObject);
    procedure ActionCurveEditCopyExecute(Sender: TObject);
    procedure ActionCurveEditPasteExecute(Sender: TObject);
    procedure ActionCurveEditSelectMoreExecute(Sender: TObject);
    procedure ActionCurveEditCloneWindowExecute(Sender: TObject);
    procedure ActionCurveEditCommentExecute(Sender: TObject);
    procedure ActionCurveEditStyleExecute(Sender: TObject);
    procedure ActionCurveEditWindowStyleExecute(Sender: TObject);
    procedure ActionCurveEditDownSamplingExecute(Sender: TObject);
    procedure ActionCurveToolsRunMacroDialogExecute(Sender: TObject);
    procedure ActionCurveToolsWriteTableExecute(Sender: TObject);
    procedure ActionCurveToolsComposeSurfaceExecute(Sender: TObject);
    procedure ActionCurveToolsRunPluginDialogExecute(Sender: TObject);
  private
    { Private declarations }
    myActiveCurveWindow:TForm;
  public
    { Public declarations }
  end;

procedure ShowCurveTools(aForm:TForm; const Where:TPoint2I);

implementation

uses Form_CurveWindow;

{$R *.lfm}
const
 FormCurveTools : TFormCurveTools = nil;

function ActiveCurveWindow:TFormCurveWindow;
begin
 Result:=nil;
 if Assigned(FormCurveTools) then
 with FormCurveTools do begin
  if Assigned(myActiveCurveWindow) and not FormExists(myActiveCurveWindow)
  then myActiveCurveWindow:=nil;
  if not Assigned(myActiveCurveWindow)
  then myActiveCurveWindow:=Form_CurveWindow.ActiveCurveWindow;
  if (myActiveCurveWindow is TFormCurveWindow)
  then Result:=TFormCurveWindow(myActiveCurveWindow);
 end;
end;

procedure SynchronizeHint(Component:TComponent; Index:LongInt; var Terminate:Boolean; Custom:Pointer);
var
 Action : TComponent;
begin
 try
  if (Component is TToolButton) then begin
   Action:=TAction((Component as TToolButton).Action);
   if (Action is TAction) then begin
    Action:=TFormCurveWindow(Custom).FindComponent(Action.Name);
    if (Action is TAction) then (Component as TToolButton).Hint:=(Action as TAction).Hint;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'SynchronizeHint');
 end;
end;

procedure ShowCurveTools(aForm:TForm; const Where:TPoint2I);
var
 TheCurveWindow : TFormCurveWindow;
begin
 try
  if FormExists(aForm) and (aForm is TFormCurveWindow)
  then TheCurveWindow:=TFormCurveWindow(aForm)
  else TheCurveWindow:=nil;
  if not Assigned(TheCurveWindow)
  then TheCurveWindow:=Form_CurveWindow.ActiveCurveWindow;
  if TheCurveWindow.Ok then begin
   if not Assigned(FormCurveTools) then begin
    Application.CreateForm(TFormCurveTools, FormCurveTools);
    FormCurveTools.Master:=@FormCurveTools;
   end;
   if Assigned(FormCurveTools) then with FormCurveTools do begin
    myActiveCurveWindow:=TheCurveWindow;
    Left:=Where.X;
    Top:=Where.Y;
    ForEachComponent(FormCurveTools,SynchronizeHint,TheCurveWindow);
    Show;
    BringToFront;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'ShowCurveTools');
 end;
end;

procedure TFormCurveTools.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Обработка кривых','Curve tools');
end;

procedure TFormCurveTools.ActionListUpdate(Action: TBasicAction; var Handled: Boolean);
begin
 Handled:=true;
end;

procedure TFormCurveTools.ActionFileSaveExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionFileSaveExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionFileSaveAsExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionFileSaveAsExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionFilePrintExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionFilePrintExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionFilePrinterSetupExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionFilePrinterSetupExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveMouseSelectorExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok then ActiveCurveWindow.ActionCurveMouseSelectorExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseZoomInExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseZoomInExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseZoomOutExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseZoomOutExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseDragCopyExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseDragCopyExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseDragMoveExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseDragMoveExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseSelectRoiLExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseSelectRoiLExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseSelectRoiRExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseSelectRoiRExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseClearRoiLExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseClearRoiLExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveMouseClearRoiRExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveMouseClearRoiRExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveRangeAutoExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeAutoExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeSelectorExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeSelectorExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeZoomInExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeZoomInExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeZoomOutExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeZoomOutExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeLeftExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeLeftExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeRightExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeRightExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeUpExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeUpExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveRangeDownExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveRangeDownExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveEditDeleteExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditDeleteExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveEditCutExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditCutExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveEditCopyExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditCopyExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveEditPasteExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditPasteExecute(Sender);
 Show;
end;

procedure TFormCurveTools.ActionCurveEditSelectMoreExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditSelectMoreExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveEditCloneWindowExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditCloneWindowExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveEditCommentExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditCommentExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveEditStyleExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditStyleExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveEditWindowStyleExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditWindowStyleExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveEditDownSamplingExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveEditDownSamplingExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveToolsRunMacroDialogExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveToolsRunMacroDialogExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveToolsRunPluginDialogExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveToolsRunPluginDialogExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveToolsWriteTableExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveToolsWriteTableExecute(Sender);
end;

procedure TFormCurveTools.ActionCurveToolsComposeSurfaceExecute(Sender: TObject);
begin
 Hide;
 if ActiveCurveWindow.Ok
 then ActiveCurveWindow.ActionCurveToolsComposeSurfaceExecute(Sender);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curvetools;
begin
end;

procedure Free_form_curvetools;
begin
end;

initialization

 Init_form_curvetools;

finalization

 Free_form_curvetools;

end.

//////////////
// END OF FILE
//////////////

