////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve By Formula.                                                     //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231124 - Modified for FPC (A.K.)                                         //
// 20240626 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_curvebyformula; // Form Curve By Formula

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 Form_CrwDaqSysChild,
 _crw_alloc, _crw_str, _crw_plut, _crw_eldraw,
 _crw_curves, _crw_rtc, _crw_fifo, _crw_fio, _crw_ef,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCurveByFormula = class(TMasterForm)
    PanelParams: TPanel;
    LabelNumPoints: TLabel;
    LabelStart: TLabel;
    LabelStop: TLabel;
    EditNumPoints: TEdit;
    EditStart: TEdit;
    EditStop: TEdit;
    PanelScript: TPanel;
    LabelScript: TLabel;
    MemoScript: TMemo;
    PanelManual: TPanel;
    MemoHelp: TMemo;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure LabelNumPointsClick(Sender: TObject);
    procedure LabelStartClick(Sender: TObject);
    procedure LabelStopClick(Sender: TObject);
    procedure LabelScriptClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function CurveByFormulaDialog(const aParams:LongString=''):TCurve;

implementation

{$R *.lfm}

const
  FormCurveByFormula : TFormCurveByFormula = nil;

function CurveByFormulaDialog(const aParams:LongString=''):TCurve;
var NumPoints:LongInt; tmin,tmax:Double; apFlags:Integer;
begin
 Result:=nil;
 if CanShowModal(FormCurveByFormula) then
 try
  if not Assigned(FormCurveByFormula) then begin
   Application.CreateForm(TFormCurveByFormula, FormCurveByFormula);
   FormCurveByFormula.Master:=@FormCurveByFormula;
  end;
  if Assigned(FormCurveByFormula) then begin
   SetStandardFont(FormCurveByFormula);
   apFlags:=FormCurveByFormula.ApplyParams(aParams);
   if not HasFlags(apFlags,apf_FormPos)
   then LocateFormToCenterOfScreen(FormCurveByFormula);
   if mrVoice(FormCurveByFormula.ShowModal)=mrOk then begin
    if Str2Long(FormCurveByFormula.EditNumPoints.Text,NumPoints) and
       Str2Real(FormCurveByFormula.EditStart.Text,tmin) and
       Str2Real(FormCurveByFormula.EditStop.Text,tmax) and
       (NumPoints>1) and
       (NumPoints<MaxNumDouble) and
       (tmin<>tmax) and
       (FormCurveByFormula.MemoScript.Text<>'')
    then begin
     Result:=NewCurveByFormula(NumPoints,tmin,tmax,FormCurveByFormula.MemoScript.Text);
     Result.Style:=$1F;
     if not Assigned(Result) then Error(RusEng('Ошибка при вычислении выражения!','Error in calculations!'));
    end else Error(RusEng('Введены неверные параметры!','Invalid parameters entered!'));
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'CurveByFormulaDialog');
 end;
end;

procedure TFormCurveByFormula.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Диалог построения графика функции','Function plot dialog');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(LabelNumPoints,RusEng('Число точек:','Number of points:'));
 SmartUpdate(LabelStart,RusEng('Начало интервала:','Start range:'));
 SmartUpdate(LabelStop,RusEng('Конец  интервала:','Stop  range:'));
 SmartUpdate(LabelScript,RusEng('Текст вычисляемой кривой:','Script to be execute:'));
 SmartUpdate(MemoHelp,RusEng(
  'Справка:'+EOL+
  'Диалог позволяет построить график параметрической кривой (y(t),x(t)).'+EOL+
  'Для этого надо задать число точек кривой, интервал изменения аргумента t,'+
  'а также формульное выражение для вычисления значений x,y в зависимости от t, например:'+EOL+
  '  x=2*pi*t'+EOL+
  '  y=sin(x)',
  'Help:'+EOL+
  'This dialog can plot the graphic of parametric curve (y(t),x(t)).'+EOL+
  'To do that, you need enter number of points in curve, range of argument t variation, and script text'+
  'with algorithm of x(t) and y(t) calculations to evaluate x and y vs t, for example:'+EOL+
  '  x=2*pi*t'+EOL+
  '  y=sin(x)'));
end;

procedure TFormCurveByFormula.LabelNumPointsClick(Sender: TObject);
begin
 SmartFocus(EditNumPoints);
end;

procedure TFormCurveByFormula.LabelStartClick(Sender: TObject);
begin
 SmartFocus(EditStart);
end;

procedure TFormCurveByFormula.LabelStopClick(Sender: TObject);
begin
 SmartFocus(EditStop);
end;

procedure TFormCurveByFormula.LabelScriptClick(Sender: TObject);
begin
 SmartFocus(MemoScript);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curvebyformula;
begin
end;

procedure Free_form_curvebyformula;
begin
end;

initialization

 Init_form_curvebyformula;

finalization

 Free_form_curvebyformula;

end.

//////////////
// END OF FILE
//////////////

