########################################################################################################################
# State Manager Language (SML) Demo file.
# Extra cookies uses for GUI declarations:
#  !visible: v      - Action visability (v=0/1) in popup menu.
#  !color: c        - Display color (c) for entity declared above.
#  !panel: p        - Panel name (p) to be opened on click. Substututions (_DOMAIN_,_OBJECT_,_STATE_,_ACTION_) is allowed.
#  !title: t        - Display title (t) for entity declared above.
#  !busy_title: t   - Display title (t) for BUSY state.
#  !busy_color: c   - Display color (c) for BUSY state.
#  !confirm: c      - Action required (c=0/1) confirmation dialog.
########################################################################################################################
!title: ДЕМО
!busy_title: &ЗАНЯТ
!busy_color: FwStateAttention1

class: AUTO_PILOT_CLASS /associated
!color: Silver
    state: DEAD /dead_state                                 !color: FwDead
    state: OFF                                              !color: FwStateOKNotPhysics
    !title: ОТКЛЮЧЕН
        action: ACTIVATE                                    !visible: 1
        !title: АКТИВИРОВАТЬ
        !confirm: 1
    state: ON                                               !color: FwStateOkPhysics
    !title: ВКЛЮЧЕН
        action: DISACTIVATE
        !title: ДЕАКТИВИРОВАТЬ
        action: X_ACTIVATE
        !title: X_АКТИВИРОВАТЬ

object: AUTO::PILOT is_of_class AUTO_PILOT_CLASS
!panel: SMI._DOMAIN_::_OBJECT_.CTRL
!title: АВТОПИЛОТ
            
class: RUN_TYPE_CLASS
    state: TEST                                             !color: FwStateOKNotPhysics
    !title: ТЕСТОВЫЙ
        action: PHYSICS
        !title: ФИЗИЧЕСКИЕ_ИЗМЕРЕНИЯ
            do LOG LOGGER
            if (LOGGER in_state LOGGING) then
                move_to PHYSICS
            endif
            move_to TEST
    state: PHYSICS                                          !color: FwStateOkPhysics
    !title: ФИЗИЧЕСКИЙ
        action: TEST
        !title: ТЕСТОВЫЙ_РЕЖИМ
            do NOLOG LOGGER
            if (LOGGER in_state NOT_LOGGING) then
                move_to TEST
            endif
            move_to PHYSICS

object: RUN_TYPE is_of_class RUN_TYPE_CLASS            
!panel: SMI._DOMAIN_::_OBJECT_.CTRL
!title: РЕЖИМ_РАБОТ
            
class: RUN_CLASS
    parameters: int NUMBER_T = 0,
                int NUMBER_P = 0,
                RUN_MODE = "DEMO"
    state: STOPPED                                          !color: FwStateOKNotPhysics
    !title: ОСТАНОВЛЕНО
        action: START_RUN
        !title: НАЧАТЬ_ИЗМЕРЕНИЕ
            set NUMBER_T = EVT_BUILDER<NUMBER_T>
            set NUMBER_P = EVT_BUILDER<NUMBER_P>
            if (not EVT_BUILDER in_state READY) then
                move_to STOPPED
            endif
            if (RUN_TYPE in_state PHYSICS) then
                do LOG LOGGER
                if (not LOGGER in_state LOGGING) then
                    move_to STOPPED
                endif
            endif
            if (LOGGER in_state LOGGING) then
                do X_OPEN_FILE LOGGER
            endif
            if (RUN_TYPE in_state PHYSICS) then
                set RUN_MODE = "PHYSICS"
                do START (TYPE="PHYSICS",NR=NUMBER_P) EVT_BUILDER
            else
                set RUN_MODE = "TEST"
                do START (TYPE="TEST",NR=NUMBER_T) EVT_BUILDER
            endif
            if (EVT_BUILDER in_state RUNNING) then
                move_to RUNNING
            endif
            move_to STOPPED
    state: RUNNING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_РАБОТА
    when (EVT_BUILDER in_state ERROR) do X_SET_ERROR
        action: STOP_RUN
        !title: ОСТАНОВИТЬ_ИЗМЕРЕНИЕ
            do STOP EVT_BUILDER
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to STOPPED
        action: X_SET_ERROR
        !title: X_ЗАДАТЬ_ОШИБКУ
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to ERROR
    state: ERROR                                            !color: FwAlarmFatalAck
    !title: ОШИБКА
        action: RECOVER
        !title: ВОССТАНОВИТЬ
            do RECOVER EVT_BUILDER
            do STOP EVT_BUILDER
            move_to STOPPED

object: RUN is_of_class RUN_CLASS
!panel: SMI._DOMAIN_::_OBJECT_.CTRL
!title: ИЗМЕРЕНИЕ

class: LOGGER_CLASS /associated
    state: DEAD /dead_state                                 !color: FwDead
    state: NOT_LOGGING                                      !color: FwCorporateColor
    !title: БЕЗ_ЗАПИСИ
        action: LOG
        !title: ВКЛЮЧИТЬ_ЗАПИСЬ
    state: LOGGING                                          !color: FwStateOkNotPhysics
    !title: ГОТОВ_К_ЗАПИСИ
        action: NOLOG
        !title: ОТКЛЮЧИТЬ_ЗАПИСЬ
        action: X_OPEN_FILE
        !title: X_ОТКРЫТЬ_ФАЙЛ
        
    state: WRITING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_ЗАПИСЬ
        action: X_CLOSE_FILE
        !title: Х_ЗАКРЫТЬ_ФАЙЛ
        
object: LOGGER is_of_class LOGGER_CLASS
!panel: SMI._DOMAIN_::_OBJECT_.CTRL
!title: ЖУРНАЛ
       
class: EVT_BUILDER_CLASS /associated
    parameters: int NUMBER_T, int NUMBER_P
    state: DEAD /dead_state                                 !color: FwDead
    state: READY                                            !color: FwStateOKNotPhysics
    !title: ГОТОВ_К_РАБОТЕ
        action: START(TYPE, int NR)                         !visible: 1
        !title: НАЧАТЬ_ИЗМЕРЕНИЕ
    state: RUNNING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_РАБОТА
        action: STOP                                        !visible: 1
        !title: ОСТАНОВИТЬ_ИЗМЕРЕНИЕ
    state: ERROR                                            !color: FwAlarmFatalAck
    !title: ОШИБКА
        action: RECOVER                                     !visible: 1
        !title: ВОССТАНОВИТЬ

object: EVT_BUILDER is_of_class EVT_BUILDER_CLASS
!panel: SMI._DOMAIN_::_OBJECT_.CTRL
!title: СБОРЩИК

objectset: PROXY_SET is_of_class VOID {LOGGER,EVT_BUILDER}
objectset: LOGIC_SET is_of_class VOID {AUTO::PILOT,RUN_TYPE,RUN}
