@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Time-Sync
if /I "%~1" == ""       goto :Help
if /I "%~1" == "/?"     goto :Help
if /I "%~1" == "-h"     goto :Help
if /I "%~1" == "--help" goto :Help
call net session 1>nul 2>nul || ( call :AccessDenied & goto :EOF )
call :CheckOptions %*
call :SetOrEditNtpServer %1
call :QueryConfirmation || ( echo Not confirmed. Cancelled. & goto :EOF )
call :IsPingReply %NtpServer% || ( call :PingFailed %NtpServer% & goto :EOF )
if "%ResetOption%" == "1" ( call :ResetToDefaults ) else ( call :ServiceRestart )
call :SynchronizeNtpClientByNtpServer  %NtpServer% & call :ServiceRestart
call :Print "Service W32Time Status         : " & call :IsServiceRunning W32Time || echo Service W32Time is STOPPED.
                                                  call :IsServiceRunning W32Time && echo Service W32Time is RUNNING.
call :Print "Uses time source NTP servers   : " & call :QuerySntpSource
if "%ServerOption%" == "1" call :FirewallOpenNtpPortUdp123
call :W32TmQueryConfiguration
call :TimeMonitor %NtpServer%
goto :EOF

:AccessDenied
echo Access denied to user "%UserName%". Admin rights required.
call :SetErrorLevel 1
goto :EOF

:PingFailed
echo Could not ping server: %1
call :SetErrorLevel 1
goto :EOF

:Help
echo Copyright^(c^) Alex Kuryakin 2018 kouriakine@mail.ru
echo %~n0 - synchronize localhost time with remote NTP server
echo Syntax:
echo  %~n0 server       - synchronize local time with server
echo  %~n0 server?      - edit server name before syncronize
echo  %~n0 server -s    - configure localhost as NTP server
echo  %~n0 server -r    - reset most parameters to defaults
echo  %~n0 server -l    - NTP server works in local network
echo  %~n0 server -f    - force syncronize, no confirmation
echo Example:
echo  %~n0 time.windows.com -r -s
echo  %~n0 ru.pool.ntp.org
echo  %~n0 pool.ntp.org
echo  %~n0 simply.dep0404.ru
echo  %~n0 172.21.4.55 -r -l
echo  %~n0 archive?
goto :EOF

:SetOrEditNtpServer
set "NtpServer=%~1"
if not "%NtpServer:?=%" == "%NtpServer%" call :EditNtpServer %NtpServer:?=%
set "NtpServer=%NtpServer:?=%"
goto :EOF

:EditNtpServer
call inputbox -h 1>nul 2>nul || ( set /p "NtpServer=Please set NTP Server Name or IP (like %~1) to synchronize with : " & goto :EOF )
for /f "usebackq tokens=1" %%i in (`call inputbox "Synchronize local time with NTP server." "Please set NTP Server Name or IP to synchronize with..." "%~1" 2^>nul`) do set "NtpServer=%%i"
goto :EOF

:CheckOptions
set /a ForceOption=0
for %%w in ( %* ) do if /i "%%~w" == "-f" set /a ForceOption=1
set /a ResetOption=0
for %%w in ( %* ) do if /i "%%~w" == "-r" set /a ResetOption=1
set /a ServerOption=0
for %%w in ( %* ) do if /i "%%~w" == "-s" set /a ServerOption=1
set /a LocalOption=0
for %%w in ( %* ) do if /i "%%~w" == "-l" set /a LocalOption=1
set /a SpecialPollInterval=3600*24*(1-LocalOption)+3600*LocalOption
set /a LocalClockDispersion=10*(1-ServerOption)+0*ServerOption
set /a AnnounceFlags=10*(1-ServerOption)+5*ServerOption
set /a RegOpNum=0
set /a RegOpErr=0
goto :EOF

:QueryConfirmation
call :SetErrorLevel 0
if "%ForceOption%" == "1" goto :EOF
echo.
echo This command will synchronize Localhost time with reference NTP server (%NtpServer%).
if "%LocalOption%" == "1" echo Reference NTP server (%NtpServer%) assumed to work in local network.
if "%ResetOption%" == "1" echo Most NTP service settings assumed to be reset to default values.
if "%ServerOption%" == "1" echo Localhost (%ComputerName%) assumed to work as local NTP server.
echo.
set Confirmation=no
set /p Confirmation= Do you confirm this operation[s]?  [y/n] : 
echo.
if /i "%Confirmation%" == "y"  goto :EOF
call :SetErrorLevel 1
goto :EOF

:RegOp
set /a RegOpNum+=1
call %* 1>nul 2>nul || set /a RegOpErr+=1
if not defined ProgramW6432 goto :EOF
set /a RegOpNum+=1
if "%ProgramFiles%" == "%ProgramW6432%" ( call %* /reg:32 1>nul 2>nul || set /a RegOpErr+=1 ) else ( call %* /reg:64 1>nul 2>nul || set /a RegOpErr+=1 )
goto :EOF

:SynchronizeNtpClientByNtpServer
:: http://forum.oszone.net/post-1630668.html
call :Print     "Configure NTP servers          : "   & call w32tm /config /syncfromflags:manual /manualpeerlist:%~1,0x1 /LocalClockDispersion:%LocalClockDispersion% /update
call :Sleep 2   "Wait 2 sec to complete         : " . & echo.
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NtpServer /v Enabled /t REG_DWORD /d 1 /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NtpClient /v Enabled /t REG_DWORD /d 1 /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NtpClient /v SpecialPollInterval /t REG_DWORD /d %SpecialPollInterval% /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\Config /v MaxAllowedPhaseOffset /t REG_DWORD /d 300 /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\Config /v AnnounceFlags /t REG_DWORD /d %AnnounceFlags% /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W32Time\Parameters /v Type /t REG_SZ /d NTP /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /ve /t REG_SZ /d 0 /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 0 /t REG_SZ /d %~1 /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 1 /t REG_SZ /d time.windows.com /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 2 /t REG_SZ /d time.nist.gov /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 3 /t REG_SZ /d pool.ntp.org /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 4 /t REG_SZ /d ru.pool.ntp.org /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 5 /t REG_SZ /d ntp1.stratum2.ru /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 6 /t REG_SZ /d ntp2.stratum2.ru /f
call :RegOp reg add HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers /v 7 /t REG_SZ /d ntp.mobatime.ru /f
call :ExecPrint "Update W32Time registry        : "    "echo %RegOpNum% update[s], %RegOpErr% error[s]"
if /i "%~1" == "localhost" (
call :ExecPrint "Service W32Time resynchronize  : "    "echo Not required."
) else (
call :ExecPrint "Service W32Time resynchronize  : "    "call w32tm /resync"
)
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
goto :EOF

:FirewallOpenNtpPortUdp123
SetLocal EnableExtensions EnableDelayedExpansion
set /a Errors=0
call :Print     "Configure Firewall UDP:123     : "
netsh firewall delete portopening protocol = UDP port = 123 profile = ALL 1>nul 2>nul || set /a Errors+=1
netsh firewall add portopening protocol = UDP port = 123 name = "123 UDP for NTP" mode = ENABLE scope = SUBNET profile = ALL 1>nul 2>nul || set /a Errors+=1
echo %Errors% error[s] found
netsh firewall show portopening verbose = ENABLE | findstr /i /r /c:"123 *UDP"
EndLocal
goto :EOF

:W32TmQueryConfiguration
SetLocal EnableExtensions EnableDelayedExpansion
set /a QuerySupport=0
for /f "usebackq tokens=* delims=" %%i in (`w32tm /? ^| findstr /i /c:"/query"`) do set /a QuerySupport=1
if "%QuerySupport%" == "0" goto :EOF
call :ExecPrint "Configuration of W32Time       : "    "call w32tm /query /configuration"
EndLocal
goto :EOF

:ServiceConfigStartAuto
call :Print     "Service W32Time AutoStart      : "   & call sc config W32Time start= auto
goto :EOF

:ServiceRestart
call :ExecPrint "Service W32Time Stop           : "    "call net stop  W32Time"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ExecPrint "Service W32Time Start          : "    "call net start W32Time"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ServiceConfigStartAuto
goto :EOF

:ResetToDefaults
call :ExecPrint "Service W32Time Stop           : "    "call net stop  W32Time"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ExecPrint "Service W32Time Unregister     : "    "call w32tm /unregister"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ExecPrint "Service W32Time Register       : "    "call w32tm /register"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ExecPrint "Service W32Time Start          : "    "call net start W32Time"
call :Sleep 5   "Wait 5 sec to complete         : " . & echo.
call :ServiceConfigStartAuto
goto :EOF

:QuerySntpSource
call w32tm /query /source 1>nul 2>nul && goto :QuerySntpByW32tm
call net time /querysntp  1>nul 2>nul && goto :QuerySntpByNetTime
goto :EOF
:QuerySntpByNetTime
:: This works on WinXP
for /f "usebackq tokens=1* delims=:" %%i in (`net time /querysntp ^| findstr /i /c:"sntp:"`) do call :PrintSntpSource %%j
goto :EOF
:QuerySntpByW32tm
:: This works on Win10
for /f "usebackq tokens=* delims=" %%i in (`w32tm /query /source`) do call :PrintSntpSource %%i
goto :EOF
:PrintSntpSource
echo.%1
goto :EOF

:IsServiceRunning
if "%~1" == "" goto :EOF
for /f "usebackq tokens=* delims=" %%i in (`sc query %~1 ^| findstr /i /c:"RUNNING"`) do ( call :SetErrorLevel 0 & goto :EOF )
call :SetErrorLevel 1
goto :EOF

:DetectNoWarnOption
set NoWarnOption= 
for /f "usebackq tokens=* delims=" %%i in (`w32tm ^| findstr /i /c:"/nowarn"`) do set NoWarnOption=/nowarn
goto :EOF

:TimeMonitor
call :DetectNoWarnOption
echo Compare local time with server : %~1
call w32tm /monitor /computers:%~1 %NoWarnOption%
goto :EOF

:IsPingReply
call ping -n 1 %1 1>nul 2>nul
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :Print %2
if not "%~3" == "" ( for /L %%i in (1,1,%1) do ( call :Sleep 1 & call :Print %~3 ) ) else ( call ping -n %PingCount% 127.0.0.1 1>nul 2>nul  )
EndLocal
goto :EOF

:ExecPrint
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
call :Print %1 & echo %~2
for /f "usebackq tokens=* delims=" %%i in (` %~2 2^>^&1 `) do ( call :Print %1 & echo.%%~i )
EndLocal
goto :EOF

:Print
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p "_=%~1"
EndLocal
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
