@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Ping-Scan
if /I "%~1" == ""       goto :Help
if /I "%~1" == "/?"     goto :Help
if /I "%~1" == "-h"     goto :Help
if /I "%~1" == "--help" goto :Help
call :InitVariables %*
for /l %%i in (%minaddr% 1 %maxaddr%) do call :PingIp %network:~0,-2%.%%i 
call :SetErrorLevel 0
goto :EOF

:Help
echo Copyright^(c^) Alex Kuryakin 2018 kouriakine@mail.ru
echo %~n0 - ping-based IP scanner to find computers in network
echo Syntax:
echo  %~n0 network [minaddr] [maxaddr] [timeout]
echo   network - network IP4 address to scan, like X.Y.Z.0
echo   minaddr - minimal address to scan, 1..254, default 1
echo   maxaddr - maximal address to scan, 1..254, default 254
echo   timeout - ping timeout in milliseconds,    default 200
echo Example:
echo  %~n0 192.168.0.0
echo  %~n0 172.21.4.0 1 254 200
goto :EOF

:InitVariables
set "network=%~1"
set /a minaddr=1
set /a maxaddr=254
set /a timeout=200
set /a repeats=1
if not "%~2" == "" set /a "minaddr=%~2"
if not "%~3" == "" set /a "maxaddr=%~3"
if not "%~4" == "" set /a "timeout=%~4"
if "%minaddr%" == "0" set /a minaddr=1
if "%maxaddr%" == "0" set /a maxaddr=254
if "%timeout%" == "0" set /a timeout=200
goto :EOF

:PingIp
call ping -n %repeats% -w %timeout% %1 1>nul 2>nul && echo %1
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
