#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# CRW-DAQ script to setup system menu (by Start button).
##########################################################

################################
# Current script identification.
################################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

readonly resourcedir="$(realpath $scriptHOME/..)";
readonly applications="/usr/share/applications";
readonly pixmaps="/usr/share/pixmaps";

function fatal(){
 1>&2 echo "$2";
 exit $1;
};

function check_sudo(){
 if unix sudoit -v; then true; else
  fatal 1 "Error: could not run SUDO.";
 fi;
};

function check_environ(){
 local checklist="$pixmaps/ $applications/";
 for i in $(seq 1 6); do checklist+=" $resourcedir/launch/crwdaq_${i}.desktop"; done;
 for i in $(seq 0 5); do checklist+=" $resourcedir/icon/png/crwdaq_${i}_48.png"; done;
 checklist+=" $resourcedir/launch/crwdaqmenucpl.desktop";
 for f in $checklist; do
  if [ -e "$f" ]; then
   echo "Found: $f";
  else
   fatal 1 "Error: not found $f.";
  fi;
 done;
};

function copy_desktop(){
 for f in $resourcedir/launch/crwdaq_[1-6].desktop $resourcedir/launch/crwdaqmenucpl.desktop; do
  if unix sudoit cp -fv $f $applications/; then
   unix sudoit chmod -c ugo+r $applications/$(basename $f);
  else
   fatal 1 "Error: could not copy $f.";
  fi;
 done;
};

function copy_png(){
 for f in $resourcedir/icon/png/crwdaq_[0-5]_48.png; do
  if unix sudoit cp -fv $f $pixmaps/; then
   unix sudoit chmod -c ugo+r $pixmaps/$(basename $f); 
  else
   fatal 1 "Error: could not copy $f.";
  fi;
 done;
};

function update_menu(){
 echo "Updating system Start Menu …";
 if unix sudoit update-desktop-database; then
  echo "System Start Menu - Done.";
  true;
 else
  fatal 1 "Error: could not update system Start Menu.";
 fi;
};

function main(){
 check_sudo;
 check_environ;
 copy_desktop;
 copy_png;
 update_menu;
};

main "$@";

#############
# END OF FILE
#############
