﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Менеджер Сессий CRW-DAQ

Работа пакета **[crwdaq](../../index.htm)** управляется с помощью
**[Менеджера Сессий](../manual/crwdaq-env.htm#session_manager)**.
Сессия - это поименованный (пронумерованный) работающий экземпляр программы,
защищенный от повторного запуска.
То есть у каждой сессии есть номер (начиная с **1**), причем второй экземпляр
программы с тем же номером сессии запускаться не будет, а вместо этого будет
активизирован первый экземпляр сессии с передачей ему аргументов командной строки.
С каждой сессией также связаны свои **рабочие каталоги**, **каналы связи**
и другие **ресурсы**.
К каждой сессии также могут быть привязаны **параметры** - например, **.desktop** ярлык
и/или **.cfg** файл конфигурации. Таким образом, сессия с заданным номером может отвечать
за запуск конкретной **DAQ**-конфигурации.

Менеджер сессий обеспечивает управление запуском нескольких сессий программы,
причем каждый эккземпляр программы работает в своей сессии и не мешает другим сессиям.


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Меню Пуск/Научные/…

При установке пакета **crwdaq** в меню **Пуск/Научные** добавляются пункты меню:  
- ![crwdaq_0](../icon/crwdaq_0.ico) **Менеджер Сессий CRW-DAQ**  
- ![crwdaq_0](../icon/crwdaq_0.ico) **CRW-DAQ Сессия 1**  
- ![crwdaq_1](../icon/crwdaq_1.ico) **CRW-DAQ Сессия 2**  
- ![crwdaq_2](../icon/crwdaq_2.ico) **CRW-DAQ Сессия 3**  
- ![crwdaq_3](../icon/crwdaq_3.ico) **CRW-DAQ Сессия 4**  
- ![crwdaq_4](../icon/crwdaq_4.ico) **CRW-DAQ Сессия 5**  
- ![crwdaq_5](../icon/crwdaq_5.ico) **CRW-DAQ Сессия 6**  

Пункты меню соответствуют **ярлыкам** - т.е.
 **[.desktop](../guides/freedesktop.org/desktop_entry_specification.html)** файлам,
отвечающим за запуск программ, см. спецификации **[freedesktop.org](../guides/freedesktop.org/)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Ярлыки запуска сессий …

Ярлыки **CRW-DAQ Сессия n** служат для вызова (пронумерованных) сессий **crwdaq** с номером **n**.
При вызове возможно задание аргумента - загружаемого **.cfg** файла конфигурации **DAQ**-системы.
По умолчанию в ярлыке используется аргумент **%f**, что означает "**подставить аргумент вызова**".
Например, если схватить мышкой файл и бросить его на ярлык, то ярлык запустится с этим файлом.
Однако можно вместо **%f** задать (полное) имя конфигурационного **.cfg** файла, и тогда сеанс
будет автоматически загружать эту конфигурацию при старте.

В текущей версии предусмотрена настройка до **6** сессий программы **crwdaq** с номерами **1…6**.
Каждый номер связан с ярлыком и картинкой (иконкой) определенного цвета, чтобы было легче их различать.
Запуск сессий с другими номерами возможен (вручную), но до сих пор в практике не было
необходимости запуска более **3** экземпляров программы одновременно, поэтому сейчас
поддерживается только **6** ярлыков для запуска сессий **crwdaq**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Диалог настройки сессий

Ярлык  **Менеджер Сессий CRW-DAQ** служит для вызова диалога настройки ярлыков запуска сессий **CRW-DAQ**.  
![Менеджер Сессий CRW-DAQ](crwdaqmenucpl.png)  
Диалог позволяет задавать каждой сессии свой **.cfg** файл конфигурации, либо задать предопределенные аргументы
(**%f** - передать имя файла, **%F** - передать список файлов, **%u** - передать один **URL**, **%U** - передать список **URL**).
Также можно выполнить **Сброс** (вернуть все ярлыки в начальное состояние), вызвать диалог **Настройка Автозапуска**,
вызвать диалог **Настройка Входа в Систему**. Совместно эти функции позволяют гибко управлять сессиями **crwdaq**
и организовывать, например, автоматическую загрузку сеанса данного пользователя, затем автоматическую загрузку
данной сессии **crwdaq** с загрузкой данного  **.cfg** файла конфигурации.
Таким образом организуется автозагрузка и автозапуск **DAQ**-систем.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Расположение файлов

Исходные ярлыки (**.desktop** файлы) и сценарии (**.sh**, **lm9**) лежат в каталоге **[resource/launch](../launch/)**,
исходные картинки в **[resource/icon](../icon/)**.
Картинки копируются в **[/usr/share/pixmaps](/usr/share/pixmaps/)**, **.desktop** файлы
копируются в **[/usr/share/applications](/usr/share/applications/)**.

При манипуляции с файлами надо учитывать, что файлы в **/usr/share/** принадлежат **root** и защищены.
Поэтому в некоторых местах надо использовать **sudo**.

Для обновления меню используется **`sudo update-desktop-database`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---
