@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo *****************************************************
echo CRW-DAQ script to install DIM to "CommonProgramFiles"
echo The script expected location is   Crw32exe\Resource\.
echo *****************************************************
echo.

:CheckAccessRights
call net session 1>nul 2>nul || ( echo Access denied. Admin rights required. & goto :EOF )

:SetDirectories
set "TargetDir=%CommonProgramFiles%\CRW-DAQ\Resource\DimSite"
for %%i in ( "%~dp0\." ) do set "ScriptDir=%%~fi"
set "SourceDir=%ScriptDir%\DimSite"
echo SourceDir=%SourceDir%
echo TargetDir=%TargetDir%

:CheckOpt_make_checksum
if /I "%~1" == "-m"              goto :MakeCheckSum
if /I "%~1" == "--make-checksum" goto :MakeCheckSum

:CompareVersion
if not exist "%TargetDir%\checksum.md5" goto :UpdateDim
call fc /b "%SourceDir%\checksum.md5" "%TargetDir%\checksum.md5" 1>nul 2>nul || goto :UpdateDim
call :PathCheckSum
set /a "UpdateFlag=0"
pushd "%TargetDir%" && ( call checksum -q || set /a "UpdateFlag=1" )
popd
if "%UpdateFlag%" == "1" goto :UpdateDim
echo.
echo DIM version looks actual. No need to update.
echo.
goto :EOF

:UpdateDim
echo.
echo DIM should be updated.
echo.
call :DimTaskKill
call :DimRemove
call :DimCopy
goto :EOF

:MakeCheckSum
if not defined SourceDir goto :EOF
if not exist "%SourceDir%" goto :EOF
pushd "%SourceDir%" && call :ExecCheckSum
popd
goto :EOF

:PathCheckSum
call checksum --help 1>nul 2>nul || if defined CRW_DAQ_SYS_HOME_DIR path %CRW_DAQ_SYS_HOME_DIR%\Resource\Shell;%path%
call checksum --help 1>nul 2>nul || if defined CRW_DAQ_SYS_HOME_DIR path %CRW_DAQ_SYS_HOME_DIR%;%path%
call checksum --help 1>nul 2>nul || if defined UnixRoot path %UnixRoot%\add\bin;%path%
goto :EOF

:ExecCheckSum
echo.
echo Making DIM checksum...
echo cd %cd%
echo.
call :PathCheckSum
if exist checksum.md5 del /f /q checksum.md5
set exclude=tmp\ *.ini
set include=*.exe *.dll *.bat *.cmd
call checksum -r -mchecksum %include% -e %exclude% >nul
call checksum -r -mintegrity * -e %exclude% >nul
type checksum.md5
goto :EOF

:DimTaskKill
echo.
echo Kill DIM processes...
echo.
call :TaskKill dns.exe did.exe dimtree.exe dimbridge.exe
goto :EOF

:TaskKill
if "%~1" == "" goto :EOF
echo Try to kill task %1 ...
set /a "ntask=0"
for /f "tokens=1" %%i in ('tasklist /nh /fi "imagename eq %~1" 2^>nul') do if /i "%%i" == "%~1" set /a "ntask=1"
if "%ntask%" == "1" ( call taskkill /im %1 || call taskkill /f /im %1 )
if "%ntask%" == "0" ( echo Task %1 is not rinning. )
shift /1 & goto :TaskKill
goto :EOF

:DimRemove
if not defined TargetDir goto :EOF
if not exist "%TargetDir%" goto :EOF
echo.
echo Remove DIM from "%TargetDir%"...
echo.
call rmdir /q /s "%TargetDir%" && ( echo Success. & goto :EOF )
echo Failure.
goto :EOF

:DimCopy
if not defined TargetDir goto :EOF
echo.
echo Copy DIM to "%TargetDir%" ...
echo.
if not exist "%TargetDir%" mkdir "%TargetDir%"
call xcopy /d /s /v /c /i /y "%SourceDir%\*" "%TargetDir%"
goto :EOF
