#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## clear temporary (garbage) files in script directory.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function pack_e140min(){
 rm -fv $scriptbase.tgz;
 local files=();
 files+=("help/e140.htm");
 files+=("circuits/e140_ctrl.crc");
 files+=("config/e140_ctrl.cfg");
 files+=("config/e140_ctrl.gen");
 files+=("config/e140_ctrl_crc.gen");
 files+=("config/e140_ctrl.cmd");
 files+=("config/e140_ctrl.sh");
 tar -cvzf $scriptbase.tgz ${files[@]};
};

function main(){
 if pushd $scriptHOME >/dev/null 2>&1; then pack_e140min; fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
