#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

################################################################
## Init UniHeater`s environment to make new configuration.    ##
################################################################

function fatal(){
 unix tooltip-notifier text "$scriptname: $2" preset stdError delay 60000;
 1>&2 echo -ne "\n$2\n\n";
 exit $1;
};
function call(){
 if [ $# -gt 0 ]; then
  eval "$@";
 fi;
};

################################
# Current script identification.
################################
declare startupdir="$(pwd -LP)";
declare scriptfile="${BASH_SOURCE[0]}";
declare scriptname="$(basename $scriptfile)";
declare scriptbase="$(basename $scriptfile .sh)";
declare scripthome="$(dirname  $scriptfile)";
declare scriptFILE="$(realpath $scriptfile)";
declare scriptHOME="$(dirname  $scriptFILE)";

function Define(){
 if [ -z "$1" ]; then return 0; fi; ### Environ Variable Name
 if [ -z "$2" ]; then return 0; fi; ### Environ Variable Value
 if [ -z "$(printenv $1)" ]; then
  export $1="$2";
 fi;
};

function uniheater_init(){
 ###  Define Name               Value               ; ### Comment:
 call Define UH_PrefixName      SAMPLE              ; ### Prefix for UniHeater
 call Define UH_NumHeaters      10                  ; ### Number of Heaters
 call Define UH_TileNumber      8                   ; ### Number of columns
 call Define UH_PrefixTSen      SENSOR.T            ; ### Prefix for T sensors
 call Define UH_PrefixPSen      SENSOR.P            ; ### Prefix for P sensors
 call Define UH_NumberTSen      $UH_NumHeaters      ; ### Number of T sensors to bind
 call Define UH_NumberPSen      $UH_NumHeaters      ; ### Number of P sensors to bind
 call Define UH_NickTSen        T                   ; ### Prefix of T sensors nicknames to display
 call Define UH_NickPSen        P                   ; ### Prefix of P sensors nicknames to display
 call Define UH_SmoothingWw     1e-4                ; ### Smoothing Window Width, in TimeUnits
 call Define UH_SmoothingPw     0                   ; ### Smoothing Power, -1..9
 call Define UH_SmoothingK1     2                   ; ### Smoothing Param K1,  0..9
 call Define UH_SmoothingK2     2                   ; ### Smoothing Param K2,  0..9
 call Define UH_HistoryLen      2000                ; ### History for curves
 call Define UH_EncryptMethod   RC6                 ; ### DEFAULT,BLOWFISH,GOST,RC2,RC4,RC5,RC6,BASE64,HEX,NONE
};

uniheater_init "$@";

##############
## END OF FILE
##############
