 {
 Standard routines for Tools:
 procedure FreeAndZero(var ref:Integer);
 function  iGetBitState(Data,BitNum:Integer):Boolean;
 function  iSetBitState(Data,BitNum:Integer; SetOn:Boolean):Integer;
 function  iGetTagBitState(tag,BitNum:Integer):Boolean;
 function  iSetTagBitState(tag,BitNum:Integer; SetOn:Boolean):Boolean;
 function  iGetBit(data,i:Integer):Integer;
 function  iSetBit(data,i,v:Integer):Integer;
 function  iSetTagBit(tag,i,v:Integer):Boolean;
 function  iSetTagXor(tag,XorMask:Integer):Boolean;
 function  invCalibr(n:Integer; y,z,a,b:Real):Real;
 procedure RunStartupScript;
 procedure RunFinallyScript;
 procedure ClearStdTools;
 procedure InitStdTools;
 procedure FreeStdTools;
 procedure PollStdTools;
 }
 {
 FreeAndZero(ref) - Free reference (ref) of any object and then zero it.
 Also may print debug message to console with results of Free operation.
 The FreeAndZero_Verbosity variable uses to control the console output:
 0           - silent execution
 1  = Bit[0] - print include ClassName and Name information if one found
 2  = Bit[1] - print Problem on Undefined Free reference (unsupported types)  
 4  = Bit[2] - print Problem on Unable to Free reference
 8  = Bit[3] - print Problem on Excessive Free reference (permanent objects)
 16 = Bit[4] - print Success on Succeeded Free reference 
 31          - print all
 }
 procedure FreeAndZero(var ref:Integer);
 var typ,cls,idn:String; fok,fer,fno:Boolean; Verbosity:Integer;
  procedure Cleanup;
  begin
   typ:=''; cls:=''; idn:='';
   fok:=false; fer:=false; fno:=false;
  end;
  procedure TryFree(res:Boolean);
  const SkipDB='TDbRecordset,TDbCommand';
  begin
   if IsSameText(typ,'DB') and (WordIndex(RefInfo(ref,'ClassName'),SkipDB)>0)
   then res:=true; // This objects belong to parent TDbConnection
   if res then fok:=true else fer:=true;
  end;
 begin
  Cleanup;
  if (ref<>0) then begin
   typ:=RefInfo(ref,'Type');
   Verbosity:=FreeAndZero_Verbosity;
   if HasFlags(Verbosity,1+2+4+8+16) then begin
    cls:=RefInfo(ref,'ClassName'); if (cls<>'') then cls:=' ClassName '+cls;
    idn:=RefInfo(ref,'Name');      if (idn<>'') then cls:=cls+' Name '+idn;
   end;
   if (typ='') then begin
    if HasFlags(Verbosity,2) then Problem(StrFmt('Undefined Free Ref %d',ref)+cls);
   end else begin
    if IsSameText(typ,'Timer')    then TryFree(tm_free(ref))       else
    if IsSameText(typ,'Text')     then TryFree(text_free(ref))     else
    if IsSameText(typ,'Task')     then TryFree(task_free(ref))     else
    if IsSameText(typ,'Pipe')     then TryFree(pipe_free(ref))     else
    if IsSameText(typ,'Com')      then TryFree(pipe_free(ref))     else
    if IsSameText(typ,'Tcp')      then TryFree(pipe_free(ref))     else
    if IsSameText(typ,'RegExp')   then TryFree(regexp_free(ref))   else
    if IsSameText(typ,'HashList') then TryFree(hashlist_free(ref)) else
    if IsSameText(typ,'FSM')      then TryFree(fsm_free(ref))      else
    if IsSameText(typ,'DB')       then TryFree(db_free(ref))       else
    if IsSameText(typ,'Shm')      then TryFree(shm_free(ref))      else
    fno:=true;
    if HasFlags(Verbosity,4+8+16) then cls:=' Type '+typ+cls;
    if fer and HasFlags(Verbosity,4)  then Problem(StrFmt('Unable to Free Ref %d',ref)+cls);
    if fno and HasFlags(Verbosity,8)  then Problem(StrFmt('Excessive Free Ref %d',ref)+cls);
    if fok and HasFlags(Verbosity,16) then Success(StrFmt('Succeeded Free Ref %d',ref)+cls);
   end;
   ref:=0;
  end;
  Cleanup;
 end;
 {
 Get state of bit Data[BitNum].
 }
 function iGetBitState(Data,BitNum:Integer):Boolean;
 begin
  iGetBitState:=HasFlags(Data,iShift(1,BitNum));
 end;
 {
 Set state of bit Data[BitNum] equal to SetOn.
 }
 function iSetBitState(Data,BitNum:Integer; SetOn:Boolean):Integer;
 begin
  if SetOn
  then iSetBitState:=iOr(Data,iShift(1,BitNum))
  else iSetBitState:=iAnd(Data,iNot(iShift(1,BitNum)));
 end;
 {
 Get state of bit number BitNum in integer tag.
 }
 function iGetTagBitState(tag,BitNum:Integer):Boolean;
 begin
  if TypeTag(tag)=1
  then iGetTagBitState:=iGetBitState(iGetTag(tag),BitNum)
  else iGetTagBitState:=False;
 end;
 {
 Set bit number BitNum in integer tag according to value SetOn.
 }
 function iSetTagBitState(tag,BitNum:Integer; SetOn:Boolean):Boolean;
 begin
  if SetOn
  then iSetTagBitState:=iAtomicTagOp(tag,'|',iShift(1,BitNum))
  else iSetTagBitState:=iAtomicTagOp(tag,'&',iNot(iShift(1,BitNum)));
 end;
 {
 Get data bit[i] (return 0/1).
 }
 function iGetBit(data,i:Integer):Integer;
 begin
  iGetBit:=iAnd(iShift(data,-i),1);
 end;
 {
 Set data bit[i] equal to v (0/1).
 }
 function iSetBit(data,i,v:Integer):Integer;
 begin
  iSetBit:=iOr(iAnd(data,iNot(iShift(1,i))),iShift(iAnd(v,1),i));
 end;
 {
 Set integer tag bit[i] equal to v (0/1).
 }
 function iSetTagBit(tag,i,v:Integer):Boolean;
 begin
  if HasFlags(v,1)
  then iSetTagBit:=iAtomicTagOp(tag,'|',iShift(1,i))
  else iSetTagBit:=iAtomicTagOp(tag,'&',iNot(iShift(1,i)));
 end;
 {
 Apply XOR bit mask to tag, i.e. invert tag bits which is set in XorMask.
 }
 function iSetTagXor(tag,XorMask:Integer):Boolean;
 begin
  iSetTagXor:=iAtomicTagOp(tag,'^',XorMask);
 end;
 {
 Inverted calibration
 }
 function invCalibr(n:Integer; y,z,a,b:Real):Real;
 const MaxIter=128;
 var i,k,ia,ib,it:Integer; t:Real;
 begin
  k:=0;
  if a>b then begin t:=a; a:=b; b:=t; end;
  ia:=Sign(Calibr(n,a,z)-y); k:=k+1;
  if ia=0 then t:=a else begin
   ib:=Sign(Calibr(n,b,z)-y); k:=k+1;
   if ib=0 then t:=b else begin
    i:=0;
    while i<MaxIter do begin
     t:=a+(b-a)*0.5;
     it:=Sign(Calibr(n,t,z)-y); k:=k+1;
     if t=a then i:=MaxIter else
     if t=b then i:=MaxIter else
     if it=0 then i:=MaxIter else
     if it*ia<0 then begin b:=t; ib:=it; end else
     if it*ib<0 then begin a:=t; ia:=it; end else begin t:=_NaN; i:=MaxIter; end;
     i:=i+1;
    end;
   end;
  end;
  invCalibr:=t;
 end;
 {
 Put scripting commands to StdIn at startup time...
 Config contains StartupScript variable with section name,
 where startup device commands are present, starting from @ char.
 Example:
 [DeviceList]
 &Demo = device software program
 [&Demo]
 ...
 StartupScript=[&Demo.StartupScript]
 ...
 []
 [&Demo.StartupScript]
 @Command 1
 @Command 2
 ...
 []
 }
 procedure RunStartupScript;
 var s:String; i,t:Integer;
 begin
  s:=Trim(ReadIni('StartupScript'));
  if IsSectionName(s) then begin
   t:=ReadIniSection(text_New,28,'',s);
   for i:=0 to text_NumLn(t)-1 do begin
    s:=Trim(text_GetLn(t,i));
    if LooksLikeCommand(s) then bNul(DevPostMsg(DevName+' '+s+EOL)>0);
    if Pos('&',s)=1 then bNul(DevPostMsg(s+EOL)>0);
   end;
   bNul(text_Free(t));
  end;
  s:='';
 end;
 {
 Run finalization script.
 Example:
 [DeviceList]
 &Demo = device software program
 [&Demo]
 ...
 FinallyScript=[&Demo.FinallyScript]
 ...
 []
 [&Demo.FinallyScript]
 @Command 1
 @Command 2
 ...
 []
 }
 procedure RunFinallyScript;
 var s:String; i,t:Integer;
 begin
  s:=Trim(ReadIni('FinallyScript'));
  if IsSectionName(s) then begin
   t:=ReadIniSection(text_New,28,'',s);
   for i:=0 to text_NumLn(t)-1 do begin
    s:=Trim(text_GetLn(t,i));
    if LooksLikeCommand(s) then bNul(DevPostMsg(DevName+' '+s+EOL)>0);
    if Pos('&',s)=1 then bNul(DevPostMsg(s+EOL)>0);
   end;
   bNul(text_Free(t));
  end;
  s:='';
 end;
 {
 Clear standard Tools.
 }
 procedure ClearStdTools;
 begin
 end;
 {
 Initialize standard Tools.
 }
 procedure InitStdTools;
 begin
  ShouldPollStdTools:=false;
  FreeAndZero_Verbosity:=15;
 end;
 {
 Finalize standard Tools.
 }
 procedure FreeStdTools;
 begin
 end;
 {
 Poll standard Tools.
 }
 procedure PollStdTools;
 begin
 end;
