 {
 Standard routines for Edits:
 procedure EditReset;
 function  EditStateReady:Boolean;
 function  EditStateDone:Boolean;
 function  EditStateBusy:Boolean;
 function  EditStateError:Boolean;
 function  EditGetTypes:String;
 function  EditGetRequest:String;
 function  EditGetRequestType:String;
 function  EditGetRequestName:String;
 function  EditGetLastInputLn:String;
 function  EditGetUID(id:String):String;
 function  EditGetWellKnownDevices(list:String):String;
 function  EditGetAnswer(n:Integer):String;
 function  EditGetCommand(n:Integer):String;
 function  EditGetConfirm(n:Integer):String;
 function  EditGetSetting(n:Integer):String;
 function  EditGetAnswerCount:Integer;
 function  EditGetCommandCount:Integer;
 function  EditGetConfirmCount:Integer;
 function  EditGetSettingCount:Integer;
 function  EditGetAnswerText:String;
 function  EditGetCommandText:String;
 function  EditGetConfirmText:String;
 function  EditGetSettingText:String;
 function  EditGetResultName:String;
 function  EditGetResultCode:Integer;
 function  EditTestResultName(Name:String):Boolean;
 function  EditTestResultCode(Code:Integer):Boolean;
 function  EditGetMenuListSelectedIndex:Integer;
 function  EditGetMenuListSelectedCommand:String;
 function  EditGetMenuListSelectedConfirm:String;
 function  EditAddLine(Line:String):Integer;
 function  EditAddText(Lines,Prefix,Filter:String):Integer;
 function  EditAddOpening(line:String):Integer;
 function  EditAddInputLn(line:String):Integer;
 function  EditAddCommand(line:String):Integer;
 function  EditAddConfirm(line:String):Integer;
 function  EditAddSetting(line:String):Integer;
 function  EditAddClosing(typ,id,par:String):Integer;
 procedure MessageBoxDialogEx(DialogType,Msg,Id,Cmd,Params:String);
 procedure EditMessageBoxDialogExDefaultHandler(id:String);
 procedure WarningEx(Msg,Id,Cmd,Params:String);
 procedure InfoBoxEx(Msg,Id,Cmd,Params:String);
 procedure EditStartConfirmCommand(Msg,Id,Cmd,Params:String);
 procedure EditMenuDefaultHandler(id:String);
 procedure Warning(msg:String);
 procedure InfoBox(msg:String);
 function  SetFormUnderSensorLeftBottom(aClickParams:String):String;
 procedure WinSelectUnderClickSensor(win,click,opt:String);
 procedure StartEditTagStrEx(tag:Integer; Caption,Data,Params:String);
 procedure StartEditTagStr(tag:Integer; Caption,Data:String);
 procedure StartEditTagEx(tag:Integer; Caption,Params:String);
 procedure StartEditTag(tag:Integer; Caption:String);
 function  CheckEditTag(tag:Integer; var newValue:String):Boolean;
 procedure CheckEditTagUpdate(tag:Integer; minValue,maxValue:Real);
 function  VkbdEditTag(tag,Lang,Shift:Integer; Lab:String):Integer;
 procedure ClearStdEdits;
 procedure InitStdEdits;
 procedure FreeStdEdits;
 procedure PollStdEdits;
 }
 {
 Edit Reset to be Ready for new editing.
 }
 procedure EditReset;
 begin
  sNul(Edit(''));
 end;
 {
 EditState is Ready for new editing?
 }
 function EditStateReady:Boolean;
 begin
  EditStateReady:=(EditState=ef_Ready);
 end;
 {
 EditState is Done, editing is completed?
 }
 function EditStateDone:Boolean;
 begin
  EditStateDone:=(EditState=ef_Done);
 end;
 {
 EditState is Busy, editing is in progress?
 }
 function EditStateBusy:Boolean;
 begin
  EditStateBusy:=HasFlags(EditState,ef_Busy+ef_Preparing);
 end;
 {
 EditState is Error, editing is failed?
 }
 function EditStateError:Boolean;
 begin
  EditStateError:=HasFlags(EditState,ef_ErrorFound);
 end;
 {
 Edit get list of known dialog types.
 }
 function EditGetTypes:String;
 begin
  EditGetTypes:=Edit('?types');
 end;
 {
 Edit get request for editing.
 }
 function EditGetRequest:String;
 begin
  EditGetRequest:=Edit('?req');
 end;
 {
 Edit get requested dialog type.
 }
 function EditGetRequestType:String;
 begin
  EditGetRequestType:=ExtractWord(1,EditGetRequest);
 end;
 {
 Edit get requested dialog name.
 }
 function EditGetRequestName:String;
 begin
  if (WordCount(EditGetRequest)>1)
  then EditGetRequestName:=ExtractWord(2,EditGetRequest)
  else EditGetRequestName:=ExtractWord(1,EditGetRequest);
 end;
 {
 Edit get last input line.
 }
 function EditGetLastInputLn:String;
 var i:Integer;
 begin
  i:=Val(Edit('?inp count'))-1;
  EditGetLastInputLn:=Edit('?inp '+Str(i));
 end;
 {
 Edit get UID - unique identifier.
 }
 function EditGetUID(id:String):String;
 begin
  EditGetUID:=DevName+'::'+Trim(id);
 end;
 {
 Get list of well known devices.
 }
 function EditGetWellKnownDevices(list:String):String;
 begin
  list:=Trim(list); if (list<>'') then list:=list+',';
  list:=list+'&CronSrv,&DimSrv,&WebSrv,&SmiSrv,&DatSrv,&FdbSrv,&SpeakSrv,';
  list:=list+'&ModbusSrv,&ModbusProxy,&PlotSrv,&EmlSrv,&VkbdSrv,&OpcCln';
  EditGetWellKnownDevices:=Trim(list); list:='';
 end;
 {
 Edit get answer/command/confirmation string number n.
 }
 function EditGetAnswer(n:Integer):String;
 begin
  EditGetAnswer:=Edit('?ans '+Str(n));
 end;
 function EditGetCommand(n:Integer):String;
 begin
  EditGetCommand:=Edit('?cmd '+Str(n));
 end;
 function EditGetConfirm(n:Integer):String;
 begin
  EditGetConfirm:=Edit('?con '+Str(n));
 end;
 function EditGetSetting(n:Integer):String;
 begin
  EditGetSetting:=Edit('?set '+Str(n));
 end;
 {
 Edit get answer/command/confirmation counter.
 }
 function EditGetAnswerCount:Integer;
 begin
  EditGetAnswerCount:=Val(Edit('?ans count'));
 end;
 function EditGetCommandCount:Integer;
 begin
  EditGetCommandCount:=Val(Edit('?cmd count'));
 end;
 function EditGetConfirmCount:Integer;
 begin
  EditGetConfirmCount:=Val(Edit('?con count'));
 end;
 function EditGetSettingCount:Integer;
 begin
  EditGetSettingCount:=Val(Edit('?set count'));
 end;
 {
 Edit get answer/command/confirmation as text.
 }
 function EditGetAnswerText:String;
 begin
  EditGetAnswerText:=Edit('?ans text');
 end;
 function EditGetCommandText:String;
 begin
  EditGetCommandText:=Edit('?cmd text');
 end;
 function EditGetConfirmText:String;
 begin
  EditGetConfirmText:=Edit('?con text');
 end;
 function EditGetSettingText:String;
 begin
  EditGetSettingText:=Edit('?set text');
 end;
 {
 Edit result name to identify editing operation.
 }
 function EditGetResultName:String;
 begin
  EditGetResultName:=ExtractWord(1,Edit('?ans 0'));
 end;
 {
 Edit result code: mr_Ok, mr_Cancel etc or 0.
 }
 function EditGetResultCode:Integer;
 begin
  EditGetResultCode:=Val(ExtractWord(2,Edit('?ans 0')));
 end;
 {
 Edit is completed and result Name is match?
 }
 function EditTestResultName(Name:String):Boolean;
 begin
  if EditStateDone
  then EditTestResultName:=IsSameText(EditGetResultName,Name)
  else EditTestResultName:=false;
 end;
 {
 Edit is completed and Result Code is match?
 }
 function EditTestResultCode(Code:Integer):Boolean;
 begin
  if EditStateDone
  then EditTestResultCode:=(EditGetResultCode=Code)
  else EditTestResultCode:=false;
 end;
 {
 Get Edit menu selected index or -1.
 }
 function EditGetMenuListSelectedIndex:Integer;
 begin
  if EditTestResultCode(mr_OK)
  then EditGetMenuListSelectedIndex:=iValDef(Edit('?ans 1'),-1)
  else EditGetMenuListSelectedIndex:=-1;
 end;
 {
 Get command of item selected in MenuList.
 }
 function EditGetMenuListSelectedCommand:String;
 begin
  EditGetMenuListSelectedCommand:=Trim(EditGetCommand(EditGetMenuListSelectedIndex));
 end;
 {
 Get confirmation of selected item in MenuList.
 }
 function EditGetMenuListSelectedConfirm:String;
 begin
  EditGetMenuListSelectedConfirm:=Trim(EditGetConfirm(EditGetMenuListSelectedIndex));
 end;
 {
 Edit add string (Line) to editing job, return 0/1 on success/error.
 }
 function EditAddLine(Line:String):Integer;
 begin
  if (Length(Line)>0)
  then EditAddLine:=Ord(Pos('?',Edit(Line))>0)
  else EditAddLine:=0;
 end;
 {
 Edit Add text (Lines) as EOL delimeted text, each line with Prefix and Filter.
 }
 function EditAddText(Lines,Prefix,Filter:String):Integer;
 var i,n,t:Integer; line:String;
 begin
  line:=''; n:=0;
  if (Length(Lines)>0) then begin
   t:=StringToText(Lines);
   for i:=0 to text_numln(t)-1 do begin
    line:=Prefix+text_getln(t,i);
    if (Length(line)>0) then
    if (Length(Filter)=0) then n:=n+EditAddLine(line) else
    if (Pos(StrFetch(line,1),Filter)>0) then n:=n+EditAddLine(line);
   end;
   bNul(text_free(t));
  end;
  line:='';
  EditAddText:=n;
 end;
 {
 Edit open new editing job and add input line.
 }
 function EditAddOpening(line:String):Integer;
 begin
  if not EditStateReady then Problem('EditAddOpening: not READY');
  EditAddOpening:=EditAddLine('('+line);
 end;
 {
 Edit add input line.
 }
 function EditAddInputLn(line:String):Integer;
 begin
  if not EditStateBusy then Problem('EditAddInputLn: not BUSY');
  EditAddInputLn:=EditAddLine(' '+line);
 end;
 {
 Edit add command line.
 }
 function EditAddCommand(line:String):Integer;
 begin
  if not EditStateBusy then Problem('EditAddCommand: not BUSY');
  EditAddCommand:=EditAddLine('>'+line);
 end;
 {
 Edit add confirm line.
 }
 function EditAddConfirm(line:String):Integer;
 begin
  if not EditStateBusy then Problem('EditAddConfirm: not BUSY');
  EditAddConfirm:=EditAddLine('!'+line);
 end;
 {
 Edit add setting line.
 }
 function EditAddSetting(line:String):Integer;
 begin
  if not EditStateBusy then Problem('EditAddSetting: not BUSY');
  line:=Trim(line); if (StrFetch(line,1)<>'@') then line:='@'+line;
  EditAddSetting:=EditAddLine(line);
 end;
 {
 Edit close editing job and set type (typ), identifier (id) and params (par).
 }
 function EditAddClosing(typ,id,par:String):Integer;
 begin
  if not EditStateBusy then Problem('EditAddClosing: not BUSY');
  typ:=ExtractWord(1,typ); id:=ExtractWord(1,id); par:=Trim(par);
  if IsEmptyStr(typ) or (WordIndex(typ,EditGetTypes)=0)
  then Problem('EditAddClosing: invalid dialog type '+typ);
  if IsEmptyStr(id) then Problem('EditAddClosing: invalid identifier');
  EditAddClosing:=EditAddLine(')'+typ+' '+id+' '+par);
 end;
 {
 Edit Start dialog with DialogType=(YesNo,YesNoCancel,Information,Warning,Error),
 text (Msg) and identifier (Id) with command (Cmd).
 }
 procedure MessageBoxDialogEx(DialogType,Msg,Id,Cmd,Params:String);
 var n,p:Integer;
 begin
  if WordIndex(DialogType,'YesNo,YesNoCancel,Information,Warning,Error')>0 then begin
   n:=0; Msg:=AdjustLineBreaks(Msg);
   Id:=Trim(Id); Cmd:=Trim(Cmd); Params:=Trim(Params);
   if (Id='') then Id:=DialogType;
   if (Msg<>'') and (Id<>'') then begin
    if EditStateDone then EditReset;
    if EditStateReady then begin
     p:=Pos(EOL,Msg);
     if (p=0) then p:=Length(Msg)+1;
     n:=0+EditAddOpening(Copy(Msg,1,p-1));
     Msg:=Copy(Msg,p+Length(EOL),Length(Msg));
     if (Length(Msg)>0) then n:=n+EditAddText(Msg,Dump(' '),'');
     if LooksLikeCommand(Cmd) then n:=n+EditAddCommand(Cmd);
     if (Length(Params)>0) then n:=n+EditAddText(Params,'','@!>');
     n:=n+EditAddClosing(DialogType,Id,'');
     if (n>0) then Problem(DialogType+': Could not initialize dialog!');
    end else Problem(DialogType+': Could not initialize dialog!');
   end;
  end;
 end;
 {
 Edit Default Handler to handle MessageBoxDialogEx.
 }
 procedure EditMessageBoxDialogExDefaultHandler(id:String);
 begin
  if EditStateDone then
  if not IsEmptyStr(id) then begin
   if EditTestResultName(id) then begin
    if EditTestResultCode(mr_OK)
    or EditTestResultCode(mr_YES) then begin
     if LooksLikeCommand(EditGetCommand(0))
     then DevPostCmdLocal(EditGetCommand(0));
    end;
    EditReset;
   end;
  end;
 end;
 {
 Edit Start Warning dialog with text (Msg) and identifier (Id) with command (Cmd).
 }
 procedure WarningEx(Msg,Id,Cmd,Params:String);
 begin
  MessageBoxDialogEx('Warning',Msg,Id,Cmd,Params);
 end;
 {
 Edit Start Information dialog with text (Msg) and identifier (Id) with command (Cmd).
 }
 procedure InfoBoxEx(Msg,Id,Cmd,Params:String);
 begin
  MessageBoxDialogEx('Information',Msg,Id,Cmd,Params);
 end;
 {
 Edit Start YesNo dialog with text (Msg) and identifier (Id) to Confirm command (Cmd).
 }
 procedure EditStartConfirmCommand(Msg,Id,Cmd,Params:String);
 begin
  MessageBoxDialogEx('YesNo',Msg,Id,Cmd,Params);
 end;
 {
 Edit Menu Default Handler to handle Menu editing with identifier (id).
 }
 procedure EditMenuDefaultHandler(id:String);
 begin
  if EditStateDone then
  if not IsEmptyStr(id) then begin
   // Menu handler (before confirmation).
   if EditTestResultName(id) then begin
    if EditTestResultCode(mr_OK) then begin
     if LooksLikeCommand(EditGetMenuListSelectedCommand) then
     if IsEmptyStr(EditGetMenuListSelectedConfirm) then begin
      DevPostCmdLocal(EditGetMenuListSelectedCommand);
     end else begin
      EditStartConfirmCommand('Вы действительно хотите выполнить:'+EOL+
                              EOL+UpCaseStr(EditGetMenuListSelectedConfirm)+' ?'+
                              EOL+EOL+'Эта операция требует вашего подтверждения!',
                              id+'::Confirm',EditGetMenuListSelectedCommand,EditGetSettingText);
     end;
    end;
    if not EditStateBusy then EditReset;
   end;
   // Menu handler (after confirmation).
   EditMessageBoxDialogExDefaultHandler(id+'::Confirm');
  end;
 end;
 {
 Dialog with warning message.
 }
 procedure Warning(msg:String);
 begin
  if devCronSrv<>0 then DevPostCmd(devCronSrv,'@Warning '+URL_Packed(msg)) else
  if EditStateReady then WarningEx(msg,'','','');
 end;
 {
 Dialog with information message.
 }
 procedure InfoBox(msg:String);
 begin
  if devCronSrv<>0 then DevPostCmd(devCronSrv,'@Information '+URL_Packed(msg)) else
  if EditStateReady then InfoBoxEx(msg,'','','');
 end;
 {
 Calculate set of Edit params to start edit tag under sensor's left bottom.
 Sensor params aClickParams expected to be read by ClickParams('') call.
 }
 function SetFormUnderSensorLeftBottom(aClickParams:String):String;
 var s,b,w:String;
 begin
  s:=''; b:=''; w:='';
  b:=CookieScan(aClickParams,'Bounds',0);
  w:=CookieScan(aClickParams,'Window',0);
  if (b<>'') and (w<>'') then begin
   s:=s+'@set Form.Left '+ExtractWord(1,b)+' relative '+w+' PaintBox'+EOL;
   s:=s+'@set Form.Top ' +ExtractWord(4,b)+' relative '+w+' PaintBox'+EOL;
  end;
  SetFormUnderSensorLeftBottom:=s;
  s:=''; b:=''; w:='';
 end;
 {
 Draw and Select window (win) under ClickSensor (click) with options (opt).
 }
 procedure WinSelectUnderClickSensor(win,click,opt:String);
 var s:String; px,py:Real; i,wnd,mx,my:Integer; wb,sb,pb,cb:array[1..4] of Real;
 begin
  s:='';
  win:=Trim(win);
  opt:=Trim(opt);
  wnd:=RefFind('Window '+win);
  if (win<>'') and (wnd<>0) then begin
   mx:=8; my:=8; // Margin around bounds
   s:=RefInfo(wnd,'Bounds'); for i:=1 to 4 do wb[i]:=rVal(ExtractWord(i,s));
   s:=CookieScan(click,'Bounds',0); for i:=1 to 4 do sb[i]:=rVal(ExtractWord(i,s));
   s:=CookieScan(click,'PaintBoxRect',0); for i:=1 to 4 do pb[i]:=rVal(ExtractWord(i,s));
   s:=CookieScan(click,'AppClientBounds',0); for i:=1 to 4 do cb[i]:=rVal(ExtractWord(i,s));
   px:=pb[1]-cb[1]+sb[1]; px:=min(px,(cb[3]-cb[1]-mx)-(wb[3]-wb[1])); px:=max(px,mx);
   py:=pb[2]-cb[2]+sb[4]; py:=min(py,(cb[4]-cb[2]-my)-(wb[4]-wb[2])); py:=max(py,my);
   s:='';
   if not IsNan(px) then s:=s+StrFmt('|Left=%d',Round(px));
   if not IsNan(py) then s:=s+StrFmt('|Top=%d',Round(py));
   if (opt<>'') then s:=s+StrFmt('|Options=%s',opt);
   bNul(WinDraw(win+s));
   bNul(WinSelect(win));
  end;
  s:='';
 end;
 {
 Initialize dialog to edit tag with new specified data (extended version).
 }
 procedure StartEditTagStrEx(tag:Integer; Caption,Data,Params:String);
 var n:Integer;
 begin
  if TypeTag(tag)>0 then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Редактировать тег '+NameTag(tag));
    n:=n+EditAddInputLn(Caption+'|'+Data);
    if (StdEditTagFont<>'') then n:=n+EditAddSetting('@set StringGrid.Font '+StdEditTagFont);
    if (Length(Params)>0) then n:=n+EditAddText(Params,'','@>!');
    n:=n+EditAddClosing('StringGridEdit',EditGetUID('EDIT_TAG_'+NameTag(tag)),'');
    if (n>0) then Problem('Error starting edit tag '+NameTag(tag));
   end else Problem('Could not start edit tag '+NameTag(tag));
  end;
  Data:='';
 end;
 {
 Initialize dialog to edit tag with new specified data.
 }
 procedure StartEditTagStr(tag:Integer; Caption,Data:String);
 begin
  StartEditTagStrEx(tag,Caption,Data,'');
 end;
 {
 Initialize dialog to edit tag with current value (extended version).
 }
 procedure StartEditTagEx(tag:Integer; Caption,Params:String);
 var Data:String;
 begin
  Data:='';
  if (TypeTag(tag)=1) then Data:=Str(iGetTag(tag)) else
  if (TypeTag(tag)=2) then Data:=Str(rGetTag(tag)) else
  if (TypeTag(tag)=3) then Data:=sGetTag(tag) else Data:='';
  StartEditTagStrEx(tag,Caption,Data,Params);
  Data:='';
 end;
 {
 Initialize dialog to edit tag with current value.
 }
 procedure StartEditTag(tag:Integer; Caption:String);
 begin
  StartEditTagEx(tag,Caption,'');
 end;
 {
 Check if tag editing done.
 }
 function CheckEditTag(tag:Integer; var newValue:String):Boolean;
 var s:String; r:Real;
 begin
  r:=0;
  s:='';
  CheckEditTag:=False;
  if EditStateDone then
  if (TypeTag(tag)>0) then begin
   if EditTestResultName(EditGetUID('EDIT_TAG_'+NameTag(tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=ExtractWordDelims(2,Edit('?ans 1'),Dump('|'));
     if (TypeTag(tag)=1) then begin
      r:=Eval(s);
      if not IsNan(r) then begin
       r:=Round(r);
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if (TypeTag(tag)=2) then begin
      r:=Eval(s);
      if not IsNan(r) then begin
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if (TypeTag(tag)=3) then begin
      newValue:=s;
      CheckEditTag:=true;
     end;
    end;
    EditReset;
   end;
   if IsNan(r) then Warning('Invalid input!');
  end;
  s:='';
 end;
 {
 Check if tag editing done, then update tag value if needed.
 }
 procedure CheckEditTagUpdate(tag:Integer; minValue,maxValue:Real);
 var s:String;
 begin
  s:='';
  if CheckEditTag(tag,s) then UpdateTag(tag,s,minValue,maxValue);
  s:='';
 end;
 {
 Start edit tag via &VkbdSrv.
 Set Language=0/1=Rus/Eng, Shift state Bit0=0/1=Rus/Eng,Bit1=0/1=Lo/Up.
 Set Label text, default is Edit tag ...
 }
 function VkbdEditTag(tag,Lang,Shift:Integer; Lab:String):Integer;
 begin
  if Length(Lab)=0
  then if HasFlags(Lang,1)
  then Lab:='Edit tag '+NameTag(tag)
  else Lab:='Ввести тег '+NameTag(tag);
  if (TypeTag(tag)=1) then begin
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('0123456789-+*/%$()')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else
  if (TypeTag(tag)=2) then begin 
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('0123456789.eE-+*/%$()')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else
  if (TypeTag(tag)=3) then begin
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else VkbdEditTag:=0;
 end;
 {
 Clear standard Edits.
 }
 procedure ClearStdEdits;
 begin
  StdEditTagFont:='';
 end;
 {
 Initialize standard Edits.
 }
 procedure InitStdEdits;
 begin
  ShouldPollStdEdits:=false;
  StdEditTagFont:=ReadIni('[DAQ] EditTagFont');
 end;
 {
 Finalize standard Edits.
 }
 procedure FreeStdEdits;
 begin
 end;
 {
 Poll standard Edits.
 }
 procedure PollStdEdits;
 begin
 end;
