 {
 Программа смещения нуля, медленный вариант
 - вычитание сигнала замкнутого входа мультиплексора (если есть)
 - балансировка датчика в нуль
 Последняя редакция:
 04.05.2003 Виноградов Ю.И.
 21.03.2004 Курякин А.В.

 Пример конфигурирования:

 [DeviceList]
 &S.18.2.SHF  = device software program
 [&S.18.2.SHF]
 Comment = корректировка
 InquiryPeriod = 200
 AnalogInputs = 7
 DigitalInputs = 0
 AnalogOutputs = 7
 DigitalOutputs = 0
 Calibrations = 0
 ProgramSource = ..\daqpas\lib\_zrshf.pas
 PathSHF  = ..\calibr\SLW  ; Каталог данных
 FileSHF  = P_MV.SHF    ; файл сохранения
 TagShfBt1 = S.SHF.P#1       ; кнопка смещения в нуль
 TagShfBt2 = S.SHF.P#2       ; кнопка смещения в нуль
 TagShfBt3 = S.SHF.P#3       ; кнопка смещения в нуль
 TagShfBt4 = S.SHF.P#4       ; кнопка смещения в нуль
 TagShfBt5 = S.SHF.P#5       ; кнопка смещения в нуль
 TagShfBt6 = S.SHF.P#6       ; кнопка смещения в нуль
 TagClrBt  = F.CLR.TDD
 TagLoaBt  = F.LOA.TDD
 Link AnalogInput  0  with curve S.18.2.mv0 smoothing  0.2 -1 2 2 ; короткозамкнутый вход
 Link AnalogInput  1  with curve S.18.2.mv1 smoothing 0.01 -1 2 2
 Link AnalogInput  2  with curve S.18.2.mv2 smoothing 0.01 -1 2 2
 Link AnalogInput  3  with curve S.18.2.mv3 smoothing 0.01 -1 2 2
 Link AnalogInput  4  with curve S.18.2.mv4 smoothing 0.01 -1 2 2
 Link AnalogInput  5  with curve S.18.2.mv5 smoothing 0.01 -1 2 2
 Link AnalogInput  6  with curve S.18.2.mv6 smoothing 0.01 -1 2 2
 Link AnalogOutput 1  with curve S.mvP#1 history 100
 Link AnalogOutput 2  with curve S.mvP#2 history 100
 Link AnalogOutput 3  with curve S.mvP#3 history 100
 Link AnalogOutput 4  with curve S.mvP#4 history 100
 Link AnalogOutput 5  with curve S.mvP#5 history 100
 Link AnalogOutput 6  with curve S.mvP#6 history 100
 }
program _zrshf;
const 
 nmax  =  31;
var
 b         : boolean;
 Ok        : boolean;
 errors    : integer;
 errorcode : integer;
 i,n,nch   : integer;
 r,z,tm,mv : real;
 mvshf     : array [1..nmax] of real;
 tagShfBt  : array [1..nmax] of integer;
 shfbt     : array [1..nmax] of boolean;
 tagClrBt  : integer;
 tagLoaBt  : integer;
 name      : string;
 fname     : string;
 fpath     : string;
 {
 Процедура инициализации и проверки тега
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Найти текущую дату
 }
 procedure getdate(var f:string);
 var yy,mm,dd,hh,mn,ss:string; t:real;
 begin
  t:=msecnow;
  yy:=str(ms2year(t));
  while length(yy)<4 do yy:='0'+yy;
  mm:=str(ms2month(t) mod 100);
  while length(mm)<2 do mm:='0'+mm;
  dd:=str(ms2day(t) mod 100);
  while length(dd)<2 do dd:='0'+dd;
  hh:=str(ms2hour(t) mod 100);
  while length(hh)<2 do hh:='0'+hh;
  mn:=str(ms2min(t) mod 100);
  while length(mn)<2 do mn:='0'+mn;
  ss:=str(ms2sec(t) mod 100);
  while length(ss)<2 do ss:='0'+ss;
  f:=' '+yy+'.'+mm+'.'+dd+'\'+hh+':'+mn+':'+ss;
 end;
 {
 Read file of shf
 }
 procedure loadfile;
 begin
  if reset(fname)=0 then begin
   for i:=1 to n do begin
    readln(r);
    if ioresult=0 then begin
     if (isnan(r) or isinf(r)) then mvSHF[i]:=0 else mvSHF[i]:=r;
    end
    else b:=fixerror(errorcode);
   end;
   if reset('')<>0 then b:=fixerror(errorcode);
  end else b:=fixerror(errorcode);
 end;
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {
  Инициализировать ошибки
  }
  errors:=0;
  errorcode:=registererr(progname);
  {
  Инициализировать и проверить теги
  }
  n:=numaos-1;
  if n>nmax then n:=nmax;
  for i:=1 to n do begin
   mvshf[i]:=0;
   InitTag(tagShfBt[i],readini('TagShfBt'+str(i)),1);
  end;
  InitTag(tagClrBt,readini('TagClearBt'),1);
  InitTag(tagLoaBt,readini('TagLoadBt'),1);
  {
  Read & check file path
  }
  fpath:=readini('PathSHF');
  fpath:=paramstr('FExpand '+
         paramstr('DefaultPath '+fpath+' '+
         paramstr('ExtractFilePath '+
         paramstr('DaqConfigFile'))));
  if length(fpath)=0 then errors:=errors+1 else
  if iand(getfattr(fpath),16)<>16 then errors:=errors+1;
  fname:=fpath+'\'+readini('FileShf');
  loadfile;
  {
  Анализ ошибок
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Действия при останове программы
 }
 if isinf(runcount) then begin
  name:='';
  fname:='';
  fpath:='';
 end else 
 {
 Основной цикл опроса
 }
 if Ok then begin
  {
  При нажатии Clear...
  }
  if igettag(tagClrBt)>0 then
  if isettag(tagClrBt,0) then for i:=1 to n do mvShf[i]:=0;
  {
  При нажатии Load...
  }
  if igettag(tagLoaBt)>0 then
  if isettag(tagLoaBt,0) then loadfile; 
  {
  Если нажата Bt#i
  }
  b:=false;
  for i:=1 to n do begin
   shfbt[i]:=false;
   if igettag(tagShfBt[i])>0 then
   if isettag(tagShfBt[i],0) then begin
    shfbt[i]:=true;
    b:=true;
   end;
  end;
  {
  Сохранить данные в файле
  }
  if  b then begin
   if fileexists(fname) then b:=fileerase(fname);
   if not fileexists(fname) then begin
    if rewrite(fname)=0 then begin
     for i:=1 to n do begin
      writeln(mvShf[i]);
      if ioresult<>0 then b:=fixerror(errorcode);
     end;
     getdate(name);
     writeln (name);
    end else b:=fixerror(errorcode);
    if rewrite('')<>0 then b:=fixerror(errorcode);
   end else b:=fixerror(errorcode);
  end;
  {
  Выполнить коррекцию
  }
  z:=0;
  if refai(0)<>_nil then if getai_n(0)>0 then z:=getai(0,getai_xn(0));   
  for nch:=1 to n do begin            {цикл по каналам:}
   if getai_n(nch)>0 then             {если есть точки на кривой милливольт}
   {канал разрешен если нет цифрового входа или на входе есть ненулевой бит}
   if (refdi(nch)=_nil) or (diword(nch,1)<>0) then begin
    tm:=getai_xn(nch);                {время последней точки кривой термоэдс}
    mv:=getai(nch,tm)-z;              {милливольты }
    if shfbt[nch] then mvshf[nch]:=mv;{по кнопке фиксируем ноль}
    b:=putao(nch,tm,mv-mvshf[nch]);   {запоминаем точку}
   end;
  end;
 end;
end.
