 {
 Программа-приемник для организации связи по сети через сетевой файл.
 ***************************************************************************
 Принимает данные на выходы AnalogOutput(...) в виде потока событий
 (то есть пакетов <канал,время,данные>). Время глобальное в миллисекундах.
 Глобальное время передатчика в момент приема первого пакета синхронизируется
 с глобальным временем приемника.
 ***************************************************************************
 Для организации односторонней связи передатчика Tx и приемника Rx 
 используется обмен через сетевые файлы Tx,Rx.
 Логика работы такая:
 1) При старте передатчик удаляет файл Tx, а приемник Rx
 2) В цикле опроса передатчик создает файл Tx (если его нет) и записывает 
    в него данные. 
 3) Если файл Rx не существует, то передатчик закрывает файл Tx,
    переименовывает его в Rx и создает новый пустой файл Tx.
 4) Если оба файла Rx и Tx существуют, значит передатчик уже закрыл файл Tx,
    переименовал его и открыл новый. Теперь приемник может безопасно 
    прочитать данные из Rx. 
 5) После чтения данных из файла приемник должен закрыть и удалить файл Rx. 
    Исчезновение файла Rx уведомляет передатчика о том, что данные уже
    прочитаны что можно перейти к следующему циклу.
 Для организации двусторонней связи надо использовать две односторонние.
 То же самое в псевдокоде:
 program Transmitter;
 begin
  fileerase(Tx);
  rewrite(Tx);
  while not quit do begin
   write(Tx,data);
   if not fileexists(Rx) then begin
    close(Tx);
    filerename(Tx,Rx);
    rewrite(Tx);
   end;
  end;
  close(Tx);
  fileerase(Tx);
 end.
 program Receiver;
 begin
  fileerase(Rx);
  while not quit do begin
   if fileexists(Rx) and fileexists(Tx) then begin
    reset(Rx);
    while not eof(Rx) do read(Rx,data);
    close(Rx);
    fileerase(Rx);
   end;
  end;
  fileerase(Rx);
 end.
 ***************************************************************************
 Конфигурация:
 1) В секции тегов должны быть:
  [TagList]
  TxFile     = string  \\alex\datapipe\$pipe.tx ; сетевой файл Tx
  RxFile     = string  \\alex\datapipe\$pipe.rx ; сетевой файл Rx
  RxEnable   = integer 1                        ; разрешение приемника
  RxErrors   = real    0                        ; счетчик ошибок приемника
 2) В секции передатчика указать:
  [DeviceList]
  &Receiver = device software program
  [&Receiver]
  AnalogFifo = 8192
  AnalogOutputs = 2
  Link AnalogOutput 0 with curve data1
  Link AnalogOutput 1 with curve data2
  ProgramSource = ..\daqpas\_piperx
  TagTxFile = TxFile     ; имя string тега с именем сетевого файла Tx
  TagRxFile = RxFile     ; имя string тега с именем сетевого файла Rx
  TagRxEnable = RxEnable ; имя integer тега разрешения приема
  TagRxErrors = RxErrors ; имя real тега счетчика ошибок приема
 ***************************************************************************
 }
program _piperx;
var
 b           : boolean;
 Ok          : boolean;
 quit        : boolean;
 errors      : integer;
 tagRxEnable : integer;
 tagRxErrors : integer;
 i           : integer;
 TxFile      : string;
 RxFile      : string;
 ti          : real;
 xi          : real;
 yi          : real;
 dt          : real;
 {
 Фиксация ошибки вывода в файл Rx, инкрементирует счетчик ошибок
 }
 procedure RxError(n:integer);
 var b:boolean;
 begin
  b:=rsettag(tagRxErrors,rgettag(tagRxErrors)+1);
 end;
 {
 Процедура инициализации и проверки тега
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {
  Инициализация некоторых переменных
  }
  dt:=_nan;
  errors:=0;
  {
  Чтение данных из конфигурации и инициализация тегов
  }
  TxFile:=sgettag(findtag(readini('TagTxFile')));
  RxFile:=sgettag(findtag(readini('TagRxFile')));
  InitTag(tagRxEnable,readini('TagRxEnable'),1);
  InitTag(tagRxErrors,readini('TagRxErrors'),2);
  b:=rsettag(tagRxErrors,0);
  {
  Удаление файла Rx и анализ ошибок
  }
  if length(TxFile)=0 then errors:=errors+1;
  if length(RxFile)=0 then errors:=errors+1 else
  if not fileerase(RxFile) then errors:=errors+1;
  if errors<>0 then b:=fixerror(9);
  Ok:=(errors=0);
 end else
 {
 Действия при остановке программы
 }
 if isinf(runcount) then begin
  {
  Закрыть файл Rx и удалить его
  }
  b:=(reset('')=0) and fileerase(RxFile);
  TxFile:='';
  RxFile:='';
 end else
 {
 Действия в цикле опроса программы
 }
 if Ok then begin
  {
  Прием данных
  Если оба файла Rx,Tx существуют, то можно читать файл Rx и удалять его.
  Прочитанное время указано в глобальных миллисекундах по часам приемника.
  При чтении первого пакета (dt=_nan) делается синхронизация часов, то есть 
  вычисление сдвига dt в миллисекундах между часами.
  }
  if igettag(tagRxEnable)>0 then begin
   if fileexists(RxFile) then
   if fileexists(TxFile) then begin
    if reset(RxFile)=0 then begin
     quit:=false;
     while not quit do begin
      if eof then quit:=true else begin
       readln(i,ti,yi);
       if ioresult<>0 then begin
        RxError(1);
        quit:=true;
       end else begin
        if isnan(dt) then dt:=int(time*timeunits-ti);
        xi:=(ti+dt)/timeunits;
        b:=putao(i,xi,yi);
       end;
      end;
     end;
    end else RxError(2);
    if reset('')<>0 then RxError(3);
    if not fileerase(RxFile) then RxError(4);
   end;
  end;
  {
  Отработка нажатий сенсоров
  }
  if clickbutton=1 then begin
   {
   Кнопка разрешения приема
   }
   if clicktag=tagRxEnable then begin
    b:=voice('нажато');
    b:=isettag(tagRxEnable,ord(igettag(tagRxEnable)=0));
   end;
   {
   Очистка счетчика ошибок
   }
   if clicktag=tagRxErrors then begin
    b:=voice('нажато');
    b:=rsettag(tagRxErrors,0);
   end;
  end;
 end;
end.
