 {
 Программный драйвер DAQ PASCAL для одновременного перевода нескольких
 каналов милливольт термоэдс и температур холодного спая в температуру.
 Конфигурирование (пример для 3-х канального преобразователя):
 [DeviceList]
 ThermoCouples = device software program
 [ThermoCouples]
 Comment = Устройство для термопарных преобразований
 InquiryPeriod = 50
 DigitalInputs = 3
 DigitalOutputs = 0
 AnalogInputs = 6
 AnalogOutputs = 3
 Calibrations = 3
 DebugMode = 0
 Link AnalogInput  0 with curve ТермоЭДС#0
 Link AnalogInput  1 with curve ХолодСпай#0
 Link AnalogOutput 0 with curve Температура#0 tolerance 1 0.001
 Calibration#0 = ..\calibr\_hral.cal U(mV) T Tc Line HrAl 0 10
 Link AnalogInput  2 with curve ТермоЭДС#1
 Link AnalogInput  3 with curve ХолодСпай#1
 Link AnalogOutput 1 with curve Температура#1 tolerance 1 0.001
 Calibration#1 = ..\calibr\_hral.cal U(mV) T Tc Line HrAl 0 10
 Link AnalogInput  4 with curve ТермоЭДС#2
 Link AnalogInput  5 with curve ХолодСпай#2
 Link AnalogOutput 2 with curve Температура#2 tolerance 1 0.001
 Calibration#2 = ..\calibr\_hral.cal U(mV) T Tc Line HrAl 0 10
 Link DigitalInput 0 with curve Ворота bit 0
 Link DigitalInput 1 with curve Ворота bit 1
 Link DigitalInput 2 with curve Ворота bit 2
 ProgramSource = ..\daqpas\_mv2tc
 }
 {
 ****************************************************************
 Milli Volts of thermocouples to Temperature in Celsius converter
 ****************************************************************
 }
program _mv2tc;
var nch,nmv,ncj:integer; tm,mv,cj,tc:real; ok:boolean;
begin
 for nch:=0 to numaos-1 do begin {цикл по каналам:}
  nmv:=nch*2;                    {номер входа кривой термоэдс}
  ncj:=nmv+1;                    {номер входа кривой холодного спая}
  if getai_n(nmv)>0 then         {если есть точки на кривой термоэдс}  
  if getai_n(ncj)>0 then         {если есть точки на кривой холодного спая}
  {канал разрешен если нет цифрового входа или на входе есть ненулевой бит}
  if (refdi(nch)=_nil) or (diword(nch,1)<>0) then begin
   tm:=getai_xn(nmv);            {время последней точки кривой термоэдс}
   mv:=getai(nmv,tm);            {милливольты кривой термоэдс}
   cj:=getai(ncj,tm);            {температура холодного спая}
   tc:=calibr(nch,mv,cj);        {температура в градусах Цельсия}
   ok:=putao(nch,tm,tc);         {запоминаем точку}
  end;
 end;
end.
