 {
 ***********************************************************************
 RS485 Proxy (Master).
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Port port prot decl
|  Open logical RS485 port to connect device nodes.
|  port (1..16) is logical number (i.e. port identifier).
|  prot (IP,RTU,ASCII) is RS485 transport protocol.
|  decl is port detail declaration, looks like that:
|   @Port 1 IP  tcp port 502 client locahost 
|   @Port 2 RTU com port 1 baudrate 9600 parity even databits 8 stopbits 1
|   @Port 3 ASCII com port 2 baudrate 115200 parity even databits 8 stopbits 1
|   See help on function pipe_init() for details.
| @PortPollRates Rx Tx
| @PortByteRates Rx Tx
| @PortPollCounters Rx Tx
| @PortByteCounters Rx Tx
| @PortErrorRates Rx Tx
| @PortErrorCounters Rx Tx
| @ZeroPortCounters n - Zero all stat. counters on port n (0 mean all).
|  Set polls/bypes/errors counter/rate tag names of type Integer or Real
|  to count errors and rate (per second) on this port:
|  Rx - Receiver polls/bytes/errors (errors is bad request, no answer).
|  Tx - Transmitter polls/bytes/errors (errors is fail to send answer).
| @View n
|  Print information about specified port n (0 mean all).
| @RS485.Poll ref cid tot port uid fid end $$dat//lineending 
|  ref  = sender device reference or device name
|  cid  = command id (user defined parameter)  
|  tot  = timeout, ms: 1..MaxInt
|  port = port number: 1..16
|  uid  = unit id: 1..247
|  dat  = data unit;
|  lineending = symbols in hexcode (examples: 0D; 0A; 0D0A); 
|  Reply to sender may be one of:
|   @RS485.Reply   ref cid tim port uid $$ans - reply   successfully with answer data
|   @RS485.TimeOut ref cid tim port uid $$req - timeout on request with original data
|   @RS485.Refuse  ref cid tim port uid msg   - refuse  request with error message msg
|  where:
|   ref is &RS485Proxy reference; tim is response time, ms.
|   cid,port,uid should be the same as in request (fid also may include exception bit).
|  Example:
|   @RS485.Poll &Demo.Driver 33 1000 1 1 0D $$@01FFFF//0D   Request to poll from &Demo.Driver command 33
|   @RS485.Reply &RS485Proxy 33 1000 1 1 $$!01              Success reply    send to &Demo.Driver
|   @RS485.Timeout &RS485Proxy 33 110 1 1 $$@01FFFF         Timeout detected send to &Demo.Driver
|   @RS485.Refuse &RS485Proxy 33 Port closed 1              Refuse notifier  send to &Demo.Driver
| @TimeGap port gap
|  Time gap (time of silence) between i/o transactions
|  port = RS485Proxy logical port
|  gap  = time gap, ms
| @Skip n
| @RS485.Reply ...
| @RS485.Refuse ...
| @RS485.TimeOut ...
|********************************************************
[]
 }
{
[Compiler.Options]            ; Size of table for ... 
Compiler.dtabmax = 1024*40    ; -Data segment ( number of virtual machine data items )
Compiler.stabmax = 1024*16    ; -Strings      ( number of available string var+const )
Compiler.dtabmin = 1024*4     ; Min stack  space at start ( error if free space less )
Compiler.stabmin = 1024*1     ; Min string space at start ( error if free space less )
[]
}
program RS485Proxy;              { RS485 Proxy (Master)             }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetRS485}              { NetRS485 constants               }
 MaxPortNum = 16;                { Max.number of logical ports      }
 MaxItemNum = 256;               { Max.number of items in fifo      }
 MaxBuffer  = 8192;              { Maximum size of buffer to read   }
 RatePeriod = 1000;              { Statistics poll period           }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TRSIORec   = record             { RS485 I/O record                 }
  ref       : Integer;           { Reference of sender device       }
  tot       : Integer;           { Timeout, ms                      }
  cid       : Integer;           { Command Id                       }
  uid       : Integer;           { Unit Id                          }
  dat       : String;            { data                             }
  tim       : Real;              { Time stamp                       }
 end;                            {                                  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetRS485}              { NetRS485 variables               }
 RS485     : record              { RS485 related data               }
  Port      : array[1..MaxPortNum] of record { TCP/COM ports        }
   Decl     : String;            { Port declaration                 }
   Pipe     : Integer;           { TCP/COM port pipe                }
   Tran     : Integer;           { Transaction Id                   }
   Req      : TRSIORec;          { Request to port                  }
   Ans      : TRSIORec;          { Answer from port                 }
   Buf      : String;
   Last     : record             { Last poll data                   }
    Poll    : Real;              { Last poll time, ms               }
    Rate    : Real;              { Last rate time, ms               }
   end;                          {                                  }
   Stat     : record             { Traffic Statistics               }
    Rate,                        { Rate                             }
    Count   : record             { Count                            }
     Bugs,                       { Errors                           }
     Bytes,                      { Bytes                            }
     Polls  : record             { Polls                            }
      Rx    : TTagRef;           { Received                         }
      Tx    : TTagRef;           { Transmitted                      }
     end;                        {                                  }
    end;                         {                                  }
   end;
   FIFO     : record             { FIFO buffer                      }
    Count   : Integer;           { Count of items                   }
    Head    : Integer;           { Head index                       }
    Item    : array[0..MaxItemNum] of TRSIORec; { Data items        }
   end;                          {                                  }
   TimeGap  : Integer;           { Gap between poll transactions,ms }
  end;                           {                                  }
 end;                            {                                  }
 cmd_View            : Integer;  { Command @View                    }
 cmd_Skip            : Integer;  { Command @Skip                    }
 cmd_Reset           : Integer;  { Command @Reset                   }
 cmd_CheckOpt        : Integer;  { Command @CheckOpt                }
 cmd_TimeGap         : Integer;  { Command @TimeGap                 }
 cmd_Port            : Integer;  { Command @Port                    }
 cmd_PortErrorCounters :Integer; { Command @PortErrorCounters       }
 cmd_PortErrorRates  : Integer;  { Command @PortErrorRates          }
 cmd_PortByteCounters : Integer; { Command @PortByteCounters        }
 cmd_PortByteRates    : Integer; { Command @PortByteRates           }
 cmd_PortPollCounters : Integer; { Command @PortPollCounters        }
 cmd_PortPollRates   : Integer;  { Command @PortPollRates           }
 cmd_ZeroPortCounters : Integer; { Command @ZeroPortCounters        }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetRS485}              { NetRS485 functions               }

 //
 // Check port is good to use.
 //
 function RS485_port_ok(port:Integer):Boolean;
 begin
  RS485_port_ok:=(1<=port) and (port<=MaxPortNum);
 end;
 //
 // Return string like Port[1]
 //
 function RS485_port_alias(port:Integer):String;
 begin
  RS485_port_alias:='Port['+Str(port)+']';
 end;
 //
 // RS485 routine uses to send refuse message and fix error.
 //
 procedure RS485_refuse(tag,code,ref,cid,tot,port,uid:Integer; msg:String);
 begin
  if ref<>0 then DevSendCmd(ref,RS485_proxy_nice('@RS485.Refuse',devMySelf,cid,tot,port,uid,msg,0));
  RS485_fixerror(tag,code,msg);
 end;
 //
 // RS485 I/O record routines. D=Destination, S=Source.
 //
 procedure RSIORec_Assign(var D:TRSIORec; ref,cid,tot,uid:Integer; dat:String; tim:Real);
 begin
  D.ref:=ref; D.cid:=cid; D.tot:=tot; D.uid:=uid; D.dat:=dat; D.tim:=tim;
 end;
 procedure RSIORec_Clear(var D:TRSIORec);
 begin
  RSIORec_Assign(D,0,0,0,0,'',0);
 end;
 //
 // Zero statistics for specified port (0=all ports).
 //
 procedure RS485_zero_stat(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do RS485_zero_stat(port);
  end else
  if RS485_port_ok(port) then begin
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Bugs.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Bugs.Tx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Bytes.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Bytes.Tx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Polls.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Rate.Polls.Tx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Bugs.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Bugs.Tx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Bytes.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Bytes.Tx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Polls.Rx.tag,0));
   bNul(RS485_set_tag(RS485.Port[port].Stat.Count.Polls.Tx.tag,0));
   RS485.Port[port].Stat.Rate.Bugs.Rx.val:=0;
   RS485.Port[port].Stat.Rate.Bugs.Tx.val:=0;
   RS485.Port[port].Stat.Rate.Bytes.Rx.val:=0;
   RS485.Port[port].Stat.Rate.Bytes.Tx.val:=0;
   RS485.Port[port].Stat.Rate.Polls.Rx.val:=0;
   RS485.Port[port].Stat.Rate.Polls.Tx.val:=0;
   RS485.Port[port].Stat.Count.Bugs.Rx.val:=0;
   RS485.Port[port].Stat.Count.Bugs.Tx.val:=0;
   RS485.Port[port].Stat.Count.Bytes.Rx.val:=0;
   RS485.Port[port].Stat.Count.Bytes.Tx.val:=0;
   RS485.Port[port].Stat.Count.Polls.Rx.val:=0;
   RS485.Port[port].Stat.Count.Polls.Tx.val:=0;
  end;
 end;
 //
 // Clear RS485 variables for specified port (0=all ports).
 //
 procedure RS485_clear(port:Integer);
 var item:Integer;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do RS485_clear(port);
  end else
  if RS485_port_ok(port) then begin
   RS485.Port[port].Decl:='';
   RS485.Port[port].Buf:='';
   RS485.Port[port].Pipe:=0;
   RS485.Port[port].Tran:=0;
   RS485.Port[port].Last.Poll:=0;
   RS485.Port[port].Last.Rate:=0;
   RSIORec_Clear(RS485.Port[port].Req);
   RSIORec_Clear(RS485.Port[port].Ans);
   RS485.Port[port].Stat.Rate.Bugs.Rx.tag:=0;
   RS485.Port[port].Stat.Rate.Bugs.Tx.tag:=0;
   RS485.Port[port].Stat.Rate.Bytes.Rx.tag:=0;
   RS485.Port[port].Stat.Rate.Bytes.Tx.tag:=0;
   RS485.Port[port].Stat.Rate.Polls.Rx.tag:=0;
   RS485.Port[port].Stat.Rate.Polls.Tx.tag:=0;
   RS485.Port[port].Stat.Count.Bugs.Rx.tag:=0;
   RS485.Port[port].Stat.Count.Bugs.Tx.tag:=0;
   RS485.Port[port].Stat.Count.Bytes.Rx.tag:=0;
   RS485.Port[port].Stat.Count.Bytes.Tx.tag:=0;
   RS485.Port[port].Stat.Count.Polls.Rx.tag:=0;
   RS485.Port[port].Stat.Count.Polls.Tx.tag:=0;
   RS485_zero_stat(port);
   RS485.Port[port].Fifo.Count:=0;
   RS485.Port[port].Fifo.Head:=0;
   for item:=0 to MaxItemNum do RSIORec_Clear(RS485.Port[port].Fifo.Item[item]);
   RS485.Port[port].TimeGap:=0;
  end;
 end;
 //
 // Close specified port (0=all ports).
 //
 procedure RS485_close(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do RS485_close(port);
  end else
  if RS485_port_ok(port) then begin
   if RS485.Port[port].Pipe<>0 then
   if pipe_free(RS485.Port[port].Pipe)
   then Success('PORT CLOSE SUCCESS: '+Str(port)
               +' '+RS485.Port[port].Decl)
   else Trouble('PORT CLOSE FAILURE: '+Str(port)
               +' '+RS485.Port[port].Decl);
   RS485_clear(port);
  end;
 end;
 //
 // Open RS485 port
 //  arg = Port Decl
 //  arg = 1    tcp port 502 client localhost
 //  arg = 2    com port 1 baudrate 9600 parity even databits 8 stopbits 1
 //
 function RS485_open(arg:String):Integer;
 var Port,Pipe:Integer; Decl:String;
 begin
  Decl:='';
  Port:=Val(ExtractWord(1,arg));
  Decl:=Trim(SkipWords(1,arg));
  if RS485_port_ok(Port) and not IsEmptyStr(Decl) then begin
   Pipe:=pipe_init(Decl);
   if Pipe<>0 then begin
    RS485_close(Port);
    RS485.Port[Port].Decl:=Decl;
    RS485.Port[Port].Pipe:=Pipe;
    bNul(pipe_txclear(Pipe));
    bNul(pipe_rxclear(Pipe));
   end else Port:=0;
  end else Port:=0;
  RS485_open:=Port;
  Decl:='';
 end;
 //
 // Initialize RS485 variables.
 //
 procedure RS485_init;
 begin
  RS485_clear(0);
 end;
 //
 // Finalize RS485 variables.
 //
 procedure RS485_free;
 begin
  RS485_close(0);
  RS485_clear(0);
 end;
 //
 // Reset RS485 to initial state.
 //
 procedure RS485_reset;
 begin
  RS485_free;
  RS485_init;
 end;
 //
 // Calculate FIFO item index.
 //
 function RS485_item_index(i,L,H:Integer):Integer;
 begin
  if i<L then i:=L;
  RS485_item_index:=L+(i-L) mod (H-L+1);
 end;
 //
 // Put message to RS485 FIFO. Return 1=OK, 0=FAIL.
 //
 function RS485_fifo_poke(ref,cid,tot,port,uid:Integer; dat:String; tim:Real):Integer;
 var i,item,poke:Integer;
 begin
  poke:=0;
  if (ref<>0) then if (tot>=0) then
  if RS485_port_ok(port) then begin
   for i:=0 to RS485.Port[port].FIFO.Count-1 do if poke=0 then begin
    item:=RS485_item_index(RS485.Port[port].FIFO.Head+i,0,MaxItemNum);
    if (RS485.Port[port].FIFO.Item[item].ref = ref) and (RS485.Port[port].FIFO.Item[item].cid = cid) then begin
     RSIORec_Assign(RS485.Port[port].FIFO.Item[item],ref,cid,tot,uid,dat,tim);
     poke:=1;
    end;
   end;
   if poke=0 then
   if RS485.Port[port].FIFO.Count<=MaxItemNum then begin
    item:=RS485_item_index(RS485.Port[port].FIFO.Head+RS485.Port[port].FIFO.Count,0,MaxItemNum);
    RSIORec_Assign(RS485.Port[port].FIFO.Item[item],ref,cid,tot,uid,dat,tim);
    RS485.Port[port].FIFO.Count:=RS485.Port[port].FIFO.Count+1;
    poke:=1;
   end;
  end;
  RS485_fifo_poke:=poke;
 end;
 //
 // Get message from RS485 FIFO.
 //
 function RS485_fifo_peek(var ref,cid,tot:Integer; port:Integer; var uid:Integer; var dat:String; var tim:Real):Integer;
 var i,item,peek:Integer;
 begin
  peek:=0;
  if RS485_port_ok(port) then
  if RS485.Port[port].FIFO.Count>0 then begin
   item:=RS485_item_index(RS485.Port[port].FIFO.Head,0,MaxItemNum);
   RS485.Port[port].FIFO.Head:=RS485_item_index(item+1,0,MaxItemNum);
   RS485.Port[port].FIFO.Count:=RS485.Port[port].FIFO.Count-1;
   ref:=RS485.Port[port].FIFO.Item[item].ref;
   cid:=RS485.Port[port].FIFO.Item[item].cid;
   tot:=RS485.Port[port].FIFO.Item[item].tot;
   uid:=RS485.Port[port].FIFO.Item[item].uid;
   dat:=RS485.Port[port].FIFO.Item[item].dat;
   tim:=RS485.Port[port].FIFO.Item[item].tim;
   peek:=1;
  end;
  if peek=0 then begin ref:=0; cid:=0; tot:=0; uid:=0; dat:=''; tim:=0; end;
  RS485_fifo_peek:=peek;
 end;
 //
 // Delete message from RS485 FIFO.
 //
 function RS485_fifo_skip(port:Integer):Integer;
 var ref,cid,tot,uid:Integer; tim:Real; dat:String;
 begin
  dat:='';
  RS485_fifo_skip:=RS485_fifo_peek(ref,cid,tot,port,uid,dat,tim);
  dat:='';
 end;
 //
 // View specified port (0=all ports).
 //
 procedure RS485_view(port:Integer);
 var item,i,ref,cid,tot,uid,fid:Integer; dat:String; tim:Real;
 begin
  dat:='';
  if port=0 then begin
   for port:=1 to MaxPortNum do RS485_view(port);
  end else
  if RS485_port_ok(port) then
  if RS485.Port[port].Pipe<>0 then begin
   Success('@Port '+Str(port)
          +' '+RS485.Port[port].Decl);
   Success(' Bugs Rate/Count'
          +' Rx='+Str(RS485.Port[port].Stat.Rate.Bugs.Rx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Bugs.Rx.val)
          +' Tx='+Str(RS485.Port[port].Stat.Rate.Bugs.Tx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Bugs.Tx.val));
   Success(' Byte Rate/Count'
          +' Rx='+Str(RS485.Port[port].Stat.Rate.Bytes.Rx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Bytes.Rx.val)
          +' Tx='+Str(RS485.Port[port].Stat.Rate.Bytes.Tx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Bytes.Tx.val));
   Success(' Poll Rate/Count'
          +' Rx='+Str(RS485.Port[port].Stat.Rate.Polls.Rx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Polls.Rx.val)
          +' Tx='+Str(RS485.Port[port].Stat.Rate.Polls.Tx.val)
          +'/'+Str(RS485.Port[port].Stat.Count.Polls.Tx.val));
   Success(' TimeGap '+Str(RS485.Port[port].TimeGap)+' ms');
   Success(' FIFO.Count '+Str(RS485.Port[port].FIFO.Count));
   Success(' FIFO.Head  '+Str(RS485.Port[port].FIFO.Head));
   for i:=0 to RS485.Port[port].FIFO.Count-1 do begin
    item:=RS485_item_index(RS485.Port[port].FIFO.Head+i,0,MaxItemNum);
    ref:=RS485.Port[port].FIFO.Item[item].ref;
    cid:=RS485.Port[port].FIFO.Item[item].cid;
    tot:=RS485.Port[port].FIFO.Item[item].tot;
    uid:=RS485.Port[port].FIFO.Item[item].uid;
    dat:=RS485.Port[port].FIFO.Item[item].dat;
    tim:=RS485.Port[port].FIFO.Item[item].tim;
    Success(RS485_proxy_nice(' FIFO['+Str(i)+']:',ref,cid,tot,port,uid,dat,64)+' '+Str(tim));
   end;
  end;
  dat:='';
 end;
 //
 // Poll RS485 pipe
 //
 procedure RS485_poll;
 const Word16Mask=65535;
 var port,pipe,sid,ref,cid,tot,tim,uid,tid,pid:Integer;
     ms,dt,reqtim:Real; dat:String; acceptable:Boolean;
  procedure CalcRate(rtag:Integer; ctag:Integer; var cval:Real; dt:Real);
  var c:Real;
  begin
   if dt>0 then begin
    c:=RS485_get_tag(ctag,0);
    bNul(RS485_set_tag(rtag,1000*(c-cval)/dt));
    cval:=c;
   end;
  end;
  procedure ClearPoll(port:Integer; ms:Real; sid:Integer);
  begin
   if RS485_port_ok(port) then begin
    RSIORec_Clear(RS485.Port[port].Req);
    RSIORec_Clear(RS485.Port[port].Ans);
    RS485.Port[port].Last.Poll:=ms;
   end;
   if pipe_ref(sid)<>0 then begin
    bNul(pipe_txclear(sid));
    bNul(pipe_rxclear(sid));
   end;
  end;
  procedure Response(ref:Integer; msg:String);
  begin
   if DebugFlagEnabled(dfViewExp) then ViewExp(RS485_port_alias(port)+' > '+msg);
   DevSendCmd(ref,msg);  
  end;
  procedure FixErrorDisconnect(port:Integer);
  var ref,cid,tot,tim,uid,tid,pid:Integer; reqtim:Real;
  begin
   if RS485_fifo_peek(ref,cid,tot,port,uid,dat,reqtim)<>0 then begin
    RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,uid,
                              RS485_port_alias(port)+' disconnected!');
   end;
  end;
 begin
  //
  // Poll RS485 ports: RS485 IP client.
  //
  ms:=mSecNow;
  dat:='';
  for port:=1 to MaxPortNum do begin
   pipe:=RS485.Port[port].Pipe;
   if pipe<>0 then if pipe_connected(pipe)>0 then begin
    sid:=pipe_stream(pipe,0);
    if pipe_connected(sid)=1 then begin
     if RS485.Port[port].Req.ref=0 then begin
      // Create and sent new request from FIFO
      if ms-RS485.Port[port].Last.Poll>=RS485.Port[port].TimeGap then
      if RS485_fifo_peek(ref,cid,tot,port,uid,dat,reqtim)<>0 then begin
       ClearPoll(port,ms,sid);
       RSIORec_Assign(RS485.Port[port].Req,ref,cid,tot,uid,dat,ms);
       RSIORec_Assign(RS485.Port[port].Ans,ref,cid,tot,uid,'',0);
       if pipe_send(sid,RS485.Port[port].Req.dat)=Length(RS485.Port[port].Req.dat) then begin
        bNul(RS485_inc_tag(RS485.Port[port].Stat.Count.Polls.Tx.tag,1));
        bNul(RS485_inc_tag(RS485.Port[port].Stat.Count.Bytes.Tx.tag,Length(RS485.Port[port].Req.dat)));
        if DebugFlagEnabled(dfDetails)
        then Details('Sent '+Str(Length(RS485.Port[port].Req.dat))+' bytes to '+RS485_port_alias(port));
       end else begin
        RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,uid,
                              RS485_port_alias(port)+' fail to send');
        ClearPoll(port,ms,sid);
       end;
      end;
     end else begin
      // Read and process device answer
      if pipe_rxcount(sid)>0 then begin // Read data from port
       if pipe_readln(sid,dat,RS485.Port[port].Buf) then begin
        bNul(RS485_inc_tag(RS485.Port[port].Stat.Count.Bytes.Rx.tag,Length(dat)));
        if DebugFlagEnabled(dfViewImp) then ViewImp(RS485_port_alias(port)+' < '+dat);
        RS485.Port[port].Ans.dat:=RS485.Port[port].Ans.dat+dat; dat:='';
        if Length(RS485.Port[port].Ans.dat)>MaxBuffer then begin
         RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Rx.tag,ErrorCode,RS485.Port[port].Req.ref,
                       RS485.Port[port].Req.cid,RS485.Port[port].Req.tot,port,
                       RS485.Port[port].Req.uid,RS485_port_alias(port)+' Rx fifo over');
         ClearPoll(port,ms,sid);
        end;
       end;
      end;
      if RS485.Port[port].Req.ref<>0 then // Process received data
      if Length(RS485.Port[port].Ans.dat)>0 then begin
       if DebugFlagEnabled(dfDetails) then Details('Recieve Data:'
                          +' u:'+Str(RS485.Port[port].Ans.uid)+'/'+Str(RS485.Port[port].Req.uid)
                          +' $$'+RS485.Port[port].Ans.dat);
        Response(RS485.Port[port].Req.ref,RS485_proxy_poll('@RS485.Reply',devMySelf,
                 RS485.Port[port].Req.cid,Round(ms-RS485.Port[port].Req.tim),port,
                 RS485.Port[port].Ans.uid,RS485.Port[port].Ans.dat));
        ClearPoll(port,ms,sid);
      end;
      if RS485.Port[port].Req.ref<>0 then // Check for TimeOut
      if ms>RS485.Port[port].Req.tim+RS485.Port[port].Req.tot then begin
       if RS485.Port[port].Req.tot>0 then begin 
        Response(RS485.Port[port].Req.ref,RS485_proxy_poll('@RS485.TimeOut',devMySelf,
                RS485.Port[port].Req.cid,Round(ms-RS485.Port[port].Req.tim),port,
                RS485.Port[port].Req.uid,RS485.Port[port].Req.dat));
        bNul(RS485_inc_tag(RS485.Port[port].Stat.Count.Bugs.Rx.tag,1));
       end;
       ClearPoll(port,ms,sid);
      end;
     end;
    end else begin
     FixErrorDisconnect(port);
    end;
   end else begin
    FixErrorDisconnect(port);
   end;
  end;
  //
  // Rate RS485 ports.
  //
  if SysTimer_Pulse(RatePeriod)>0 then begin
   ms:=mSecNow;
   for port:=1 to MaxPortNum do begin
    dt:=ms-RS485.Port[port].Last.Rate;
    CalcRate(RS485.Port[port].Stat.Rate.Polls.Rx.tag,
             RS485.Port[port].Stat.Count.Polls.Rx.tag,
             RS485.Port[port].Stat.Count.Polls.Rx.val,dt);
    CalcRate(RS485.Port[port].Stat.Rate.Bytes.Rx.tag,
             RS485.Port[port].Stat.Count.Bytes.Rx.tag,
             RS485.Port[port].Stat.Count.Bytes.Rx.val,dt);
    CalcRate(RS485.Port[port].Stat.Rate.Bugs.Rx.tag,
             RS485.Port[port].Stat.Count.Bugs.Rx.tag,
             RS485.Port[port].Stat.Count.Bugs.Rx.val,dt);
    CalcRate(RS485.Port[port].Stat.Rate.Polls.Tx.tag,
             RS485.Port[port].Stat.Count.Polls.Tx.tag,
             RS485.Port[port].Stat.Count.Polls.Tx.val,dt);
    CalcRate(RS485.Port[port].Stat.Rate.Bytes.Tx.tag,
             RS485.Port[port].Stat.Count.Bytes.Tx.tag,
             RS485.Port[port].Stat.Count.Bytes.Tx.val,dt);
    CalcRate(RS485.Port[port].Stat.Rate.Bugs.Tx.tag,
             RS485.Port[port].Stat.Count.Bugs.Tx.tag,
             RS485.Port[port].Stat.Count.Bugs.Tx.val,dt);
    RS485.Port[port].Last.Rate:=ms;
   end;
  end;
  dat:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetRS485;
  RS485_clear(0);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitNetRS485;
  RS485_init;
  StdIn_SetScripts('@StartupScript','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  cmd_View              := RegisterStdInCmd('@View',              '');
  cmd_Skip              := RegisterStdInCmd('@Skip',              '');
  cmd_Reset             := RegisterStdInCmd('@Reset',             '');
  cmd_TimeGap           := RegisterStdInCmd('@TimeGap',           '');
  cmd_Port              := RegisterStdInCmd('@Port',              '');
  cmd_PortErrorCounters := RegisterStdInCmd('@PortErrorCounters', '');
  cmd_PortErrorRates    := RegisterStdInCmd('@PortErrorRates',    '');
  cmd_PortByteCounters  := RegisterStdInCmd('@PortByteCounters',  '');
  cmd_PortByteRates     := RegisterStdInCmd('@PortByteRates',     '');
  cmd_PortPollCounters  := RegisterStdInCmd('@PortPollCounters',  '');
  cmd_PortPollRates     := RegisterStdInCmd('@PortPollRates',     '');
  cmd_ZeroPortCounters  := RegisterStdInCmd('@ZeroPortCounters',  '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeNetRS485;
  RS485_free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetRS485;
  RS485_poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; mend,dat:String;
     ref,cid,tot,tim,port,uid,fid,poke,peek,tag,saddr,quant,p,v,nummend,i:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   dat:='';
   mend:='';
   {
   @RS485.Poll &Sender 0 100 1 1 $$00000003//0D0A
   }
   if (cmdid = cmd_NetRS485Poll) then begin
    cid:=0; tot:=0; port:=0; uid:=0;
    p:=Pos(' $$',arg);
    v:=Pos('//',arg);
    if p>1 then begin
     if v>1 then begin 
      mend:=Copy(arg,v+2);
      dat:=Copy(arg,p+3,v-p-3);
     end else dat:=Copy(arg,p+3);
     arg:=Copy(arg,1,p-1);
     ref:=Val(ExtractWord(1,arg));
     if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg)); 
     if IsRefDevice(ref) then begin
      cid:=Val(ExtractWord(2,arg));
      tot:=Val(ExtractWord(3,arg));
      if tot>=0 then begin
       port:=Val(ExtractWord(4,arg));
       if RS485_port_ok(port) then begin
        if pipe_ref(RS485.Port[port].Pipe)<>0 then begin
         uid:=Val(ExtractWord(5,arg));
         if RS485_addr_ok(uid) then begin
          if Length(dat)>0 then begin
           if Frac(Length(mend)/2)<>0 then nummend:=0 else nummend:=Round(Length(mend)/2);
           if nummend>0 then begin
            for i:=1 to Length(mend) do begin
             if Odd(i) then dat:=dat+Chr(StrToIntBase(Copy(mend,i,2),16,0));
            end;
           end;
           poke:=RS485_fifo_poke(ref,cid,tot,port,uid,dat,mSecNow);
           if poke=0 then RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                        ref,cid,tot,port,uid,'FIFO OVER');
           if poke>0 then if DebugFlagEnabled(dfDetails) then Details(Cmd+'='+Str(poke));
          end else RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                  ref,cid,tot,port,uid,'Bad Data '+dat);
         end else RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                ref,cid,tot,port,uid,'Bad Unit '+ExtractWord(5,arg));
        end else RS485_refuse(RS485.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                               ref,cid,tot,port,uid,'Port closed '+ExtractWord(4,arg));
       end else RS485_refuse(0,ErrorCode,ref,cid,tot,port,uid,'Bad Port '+ExtractWord(4,arg));
      end else RS485_refuse(0,ErrorCode,ref,cid,tot,port,uid,'Bad Timeout '+ExtractWord(3,arg));
     end else RS485_refuse(0,ErrorCode,ref,cid,tot,port,uid,'Bad Device '+ExtractWord(1,arg));
    end else RS485_refuse(0,ErrorCode,ref,cid,tot,port,uid,'Bad Marker $$');
    Data:='';
   end else
   {
   @RS485.Refuse ...
   }
   if (cmdid = cmd_NetRS485Refuse) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Problem(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,0))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @RS485.Reply ...
   }
   if (cmdid = cmd_NetRS485Reply) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Success(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,MaxInt))
    else Success(cmd+' '+arg);
    Data:='';
   end else
   {
   @RS485.TimeOut ...
   }
   if (cmdid = cmd_NetRS485TimeOut) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Problem(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,MaxInt))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @View 1
   }
   if (cmdid = cmd_View) then begin
    RS485_view(iValDef(arg,0));
    Data:='';
   end else
   {
   @Skip 1
   }
   if (cmdid = cmd_Skip) then begin
    port:=iValDef(arg,0);
    peek:=RS485_fifo_skip(port);
    Success(cmd+'='+Str(peek));
    Data:='';
   end else
   {
   @Reset
   }
   if (cmdid = cmd_Reset) then begin
    RS485_reset;
    Success(cmd);
    Data:='';
   end else
   {
   @TimeGap 1 10
   }
   if (cmdid = cmd_TimeGap) then begin
    port:=iValDef(ExtractWord(1,arg),-1);
    if RS485_port_ok(port) then begin
     RS485.Port[port].TimeGap:=iValDef(ExtractWord(2,arg),RS485.Port[port].TimeGap);
    end;
    Data:='';
   end else
   {
   @Port 1 tcp port 502 client localhost
   @Port 2 com port 1 baudrate 9600 parity even databits 8 stopbits 1
   @Port PortNum[1..16] Description[see pipe_init()]
   }
   if (cmdid = cmd_Port) then begin
    port:=RS485_open(Trim(arg));
    if RS485_port_ok(port)
    then Success(cmd+' '+Str(port)+' '+RS485.Port[port].Decl)
    else Trouble('Failed: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorCounters 1 RS485.BugsCount.Rx RS485.BugsCount.Tx
   }
   if (cmdid = cmd_PortErrorCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Count.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Count.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Bugs.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorRates 1 RS485.ErrorRates.Rx RS485.ErrorRates.Tx
   }
   if (cmdid = cmd_PortErrorRates) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Rate.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Rate.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Bugs.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteCounters 1 RS485.Bytes.Rx RS485.Bytes.Tx
   }
   if (cmdid = cmd_PortByteCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Count.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Count.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteRates 1 RS485.ByteRates.Rx RS485.ByteRates.Tx
   }
   if (cmdid = cmd_PortByteRates) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Rate.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Rate.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollCounters 1 RS485.Polls.Rx RS485.Polls.Tx
   }
   if (cmdid = cmd_PortPollCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Count.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Count.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Count.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollRates 1 RS485.PollRates.Rx RS485.PollRates.Tx
   }
   if (cmdid = cmd_PortPollRates) then begin
    port:=Val(ExtractWord(1,arg));
    if RS485_port_ok(port) then begin
     RS485.Port[port].Stat.Rate.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     RS485.Port[port].Stat.Rate.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(RS485.Port[port].Stat.Rate.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @ZeroPortCounters 1
   }
   if (cmdid = cmd_ZeroPortCounters) then begin
    RS485_zero_stat(Val(Trim(arg)));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  mend:='';
  dat:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
