#!/bin/bash

#####################################################
# Copyright (c) 2001-2024 DaqGroup <daqgroup@mail.ru>
#####################################################

#####################################################
# Adam traffic monitor configuration generator
#####################################################

# script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

declare -i rateshist=300;
declare -i counthist=30;
declare -i nport=0;
declare -i ndo=0;

function com_port_table(){
 if [ -n "$1" ]; then
  local cfg="$1";
  local ports="1"; # Uses COM ports
  delete_files                 "$cfg";
  add_header                >  "$cfg";
  add_com_port COMS "*"     >> "$cfg";
  for p in $ports; do
   add_com_port COM$p COM$p >> "$cfg";
  done;
  add_device                >> "$cfg";
 else
  return 1;
 fi;
};

function delete_files(){
 while [ -n "$1" ]; do
  if [ -e "$1" ]; then rm -f "$1"; fi;
  shift;
 done;
};

function add_header(){
 echo ";***********************************";
 echo "; Adam traffic monitor configuration";
 echo ";***********************************";
};

function add_device(){
 echo "";
echo "[DeviceList]";
echo "&AdamTraffic = device software program";
echo "[&AdamTraffic]";
echo "Comment        = ADAM traffic monitor.";
echo "InquiryPeriod  = 1";
echo "DevicePolling  = 1000, tpHigher";
echo "ProgramSource  = ../daqpas/adamtraffic.pas";
echo "DigitalFifo    = 1000";
echo "OpenConsole    = 2";
echo "DebugFlags     = 3";
echo "DigitalOutputs = $ndo";
echo "[]";
 echo "";
};

function add_com_port(){
 if [ -z "$1" ] || [ -z "$2" ]; then return 1; fi;
 echo "";
 echo "[DataStorage]";
 echo "AdamTraffic.$1.BR.RX = Curve 0 10 Black  15 1 ; ADAM Byte Rate  Receiver    $2";
 echo "AdamTraffic.$1.BR.TX = Curve 0 10 Black  15 1 ; ADAM Byte Rate  Transmitter $2";
 echo "AdamTraffic.$1.PR.RX = Curve 0 10 Black  15 1 ; ADAM Poll Rate  Receiver    $2";
 echo "AdamTraffic.$1.PR.TX = Curve 0 10 Black  15 1 ; ADAM Poll Rate  Transmitter $2";
 echo "AdamTraffic.$1.BC.RX = Curve 0 10 Black  15 1 ; ADAM Byte Count Receiver    $2";
 echo "AdamTraffic.$1.BC.TX = Curve 0 10 Black  15 1 ; ADAM Byte Count Transmitter $2";
 echo "AdamTraffic.$1.PC.RX = Curve 0 10 Black  15 1 ; ADAM Poll Count Receiver    $2";
 echo "AdamTraffic.$1.PC.TX = Curve 0 10 Black  15 1 ; ADAM Poll Count Transmitter $2";
 echo "[]";
 echo "";
 echo "[&AdamTraffic]";
 echo "Port$nport = $2";
 let nport++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.BR.RX history $rateshist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.BR.TX history $rateshist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.PR.RX history $rateshist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.PR.TX history $rateshist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.BC.RX history $counthist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.BC.TX history $counthist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.PC.RX history $counthist"; let ndo++;
 echo "Link DigitalOutput $ndo with curve AdamTraffic.$1.PC.TX history $counthist"; let ndo++;
 echo "[]";
 echo "";
};

function main(){
 if pushd $scriptHOME >/dev/null 2>&1; then
  com_port_table "$scriptHOME/$scriptbase.cfg";
 fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
