//This is the view for the mockup elements (button, checkbox, etc.)

Handlebars.registerHelper('sp', function(text, value) {
    text = Handlebars.Utils.escapeExpression(text);
    text = text.toString();
	dif = value - text.length;
	text = text + new Array(dif).join(' ');
    return new Handlebars.SafeString(text);
});

Handlebars.registerHelper('plus', function(text, value) {
    text = Handlebars.Utils.escapeExpression(text);
	text = parseInt(text) + parseInt(value);
    return new Handlebars.SafeString(text);
});
	
var HandlebarMockup = Handlebars.compile($("#universal-template").html());
usemockups.views.Mockup = Backbone.View.extend({
    tagName: "div",
    className: "object",
    events: {
        "click": "show_property_dialog",
        "keydown": "keydown",
        "keyup": "keyup"
    },
    initialize: function () {
		this.model.on("change", this.render, this);
        this.model.on("change:top", this.render, this);
        this.article = $("article");
        this.tool = usemockups.toolbox.get(this.model.get("tool")); //gets which kind of mockup element it is (called tool, since they are created via tools). Get model via text string like "text"(for text tool) ,since the toolbox-model’s ids are actually human readable text strings for the represented tools.
        this.model.on("destroy", this.detach, this);
        this.model.document = this.model.collection;
    },
    render: function (rendering_options) {
        var options = _.extend({
            focus: true,
            show_property_dialog: true
        }, rendering_options);
        var gridDivider = 1;
		//console.log(this);
        this.$el.css({
            "top": this.model.get("top") + this.article.offset().top,
            "left": this.model.get("left") + this.article.offset().left,
            "font-size": this.model.get("tags[0].height"),
            "width": this.model.get("width") || "auto",
            "height": this.model.get("height") || "auto"
        }).draggable({
            snap: ".object",
            snapTolerance: 2,
            "containment": "article",
            "drag": function (event, ui) {
				if ($("#id_grid").is(":checked")) {
                    gridDivider = Number($("#id_grid_divider").val());
                    ui.position.top = Math.round(ui.position.top/gridDivider)*gridDivider;
                    ui.position.left = Math.round(ui.position.left/gridDivider)*gridDivider;
                }
				
				$("#id_top").val(ui.position.top - this.article.offset().top);
				$("#id_left").val(ui.position.left - this.article.offset().left);
				//console.log(Math.round(ui.position.left - this.article.offset().left)+' '+Math.round(ui.position.top - this.article.offset().top));
            }.bind(this),
            "stop": function (event, ui) {
				if ($("#id_grid").is(":checked")) {
                    gridDivider = Number($("#id_grid_divider").val());
                    ui.position.top = Math.round(ui.position.top/gridDivider)*gridDivider;
                    ui.position.left = Math.round(ui.position.left/gridDivider)*gridDivider;
                }
                this.model.set({
                    "top": (ui.position.top - this.article.offset().top),
                    "left": (ui.position.left - this.article.offset().left)
                });
                this.model.trigger('change');
            }.bind(this)
        }).html(HandlebarMockup(this.model.get_attributes()));
        this.$el.find("[data-attribute]").dblclick(function (event) {
            var attribute = $(event.target).data("attribute");
            var input = $("<input>")
                .attr("name", attribute)
                .data("attribute", attribute)
                .val(this.model.get(attribute));
            $(event.target).html(input);
            input.select();

            input.bind("change blur", function (event) {
                var input = $(event.target);
                this.model.set(input.data("attribute"), input.val());
            }.bind(this)).keyup(function (event) {
                usemockups.active_property_dialog.trigger("update_for_attribute", $(event.target));
                usemockups.active_tags_dialog.trigger("update_for_attribute", $(event.target));
            }.bind(this));

        }.bind(this))

        this.$el.find("input").change(function (event) {
            var input = $(event.target);
            var tags = JSON.parse(JSON.stringify(this.model.get("tags")));
            var id = input.data("column");
            tags[input.attr("id-attribute")][input.attr("data-attribute")] = input.val() || "";
            this.model.set("tags", tags);
            this.model.trigger("persist");
        }.bind(this));
        
        this.make_resizable();

        this.$el.bind("click mousedown", function (event) {
            if (!$(event.target).is("input")) {
                this.focus();
            }
        }.bind(this));

        if (options.show_property_dialog)
            this.show_property_dialog();

        if (options.focus)
            this.focus();
        return this;
    },

    make_resizable: function () {
        if (!this.model.is_resizable())
            return;

        if (this.$el.hasClass("ui-resizable"))
            this.$el.resizable("destroy");
        
        this.$el.resizable({
            handles: "se",
            resize: function(event, ui) {
                if (!this.model.has("height"))
                    ui.size.height = ui.originalSize.height;
					$("#id_height").val(ui.size.height);
                if (!this.model.has("width"))
                    ui.size.width = ui.originalSize.width;
					$("#id_width").val(ui.size.width);
            }.bind(this),
            stop: function (event, ui) {
                ui.size.width = ui.size.width;
				if (ui.size.width < 1) ui.size.width = 1;
				ui.size.height = ui.size.height;
				if (ui.size.height < 1) ui.size.height = 1;
                
                if (this.model.has("width"))
                    this.model.set("width", ui.size.width);
                if (this.model.has("height"))
                    this.model.set("height", ui.size.height)
            }.bind(this),
            minWidth: this.tool.get("min_width"),
            minHeight: this.tool.get("min_height")
        });
    },

	measure: function(){
    	this.model.set("measured_size", {height: this.$el.height(), width: this.$el.width()});
	},

    focus: function () {
        this.$el.focus();
        return this;
    },
    show_property_dialog: function () {
		this.$el.toggleClass('selected');
        if (usemockups.active_property_dialog &&
            usemockups.active_property_dialog.model === this.model) {
            return;
        }

        if (usemockups.active_property_dialog) {
            usemockups.active_property_dialog.undelegateEvents();
        }
        
        if (usemockups.active_tags_dialog) {
            usemockups.active_tags_dialog.undelegateEvents();
        }

        var measuredSizes = {height: this.$el.height(), width: this.$el.width()};

        usemockups.active_property_dialog = (new usemockups.views.PropertyDialog({
            "model": this.model
        })).set_measuredSizes(measuredSizes).render()
    },

    detach: function () {
        this.$el.remove();
    },

    /*
     * Moves the mockup if the key was an arrow key.
     */
    keydown_move: function (e) {
        var movements = {
            37: { "left": -5 },
            39: { "left": 5 },
            38: { "top": -5 },
            40: { "top": 5}
        };
        if (movements[e.keyCode]) {
            var movement = movements[e.keyCode];
            for (var direction in movement) {
                this.model.set(direction, this.model.get(direction) + movement[direction]);
                $("#id_top").val(this.model.get("top"));
                $("#id_left").val(this.model.get("left"));
            }
			
            return false;
        }
    },

    /*
     * Deletes the mockup if the key was the del key.
     */
    keydown_destroy: function (e) {
        if (e.keyCode == 46) {
            this.model.destroy();
            return false;
        }
    },

    keydown: function (e) {
        this.keydown_move(e);
        this.keydown_destroy(e);
    },
    
    keyup: function (e) {
        if (event.code == 'KeyC' && (event.ctrlKey || event.metaKey)) {
            var copy = this.model.clone();
            copy.attributes.top = copy.attributes.top + 5;
            copy.attributes.left = copy.attributes.left + 5;
            this.model.collection.add(copy);
            return copy;}
    }
});
