@echo off
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001
goto :Start

:About
echo.
echo #####################################################
echo CRW-DAQ tool to build/compile Free Pascal projects.
echo This script designed to use with FpcUpDeluxe
echo Build command: 'lazbuld --pcp="$cfg" -B $lpi' or
echo lazbuld --primary-config-path="$cfg" --build-all $lpi
echo where $cfg - primary config path, $lpi - project .lpi
echo #####################################################
echo.
goto :EOF

:Start

call :About

:ScriptIdentification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"

:AssignFpcUpDeluxeDirectories
set FpcUpDeluxeDir=c:\opt\daqgroup\development\tools\fpcupdeluxe
set PrimaryConfigPath=%FpcUpDeluxeDir%\config_lazarus
set LazarusBinDir=%FpcUpDeluxeDir%\lazarus

:GetLazarusBinDirFromLnk
for /f "tokens=1* delims= " %%i in ('%~dp0\crwprintlnk.cmd %~dp0\fpcupdeluxe.lnk ^| findstr /c:TargetPath:') do set "LazarusBinDir=%%~dpj"
for %%i in ("%LazarusBinDir%\.") do if exist "%%~fi\" set "LazarusBinDir=%%~fi"
echo LazarusBinDir=%LazarusBinDir%

:SetLazBuildCmd
set LazBuildCmd="%LazarusBinDir%\lazbuild.exe" --primary-config-path="%PrimaryConfigPath%" --build-all
for /f "tokens=* delims=" %%i in ('%~dp0\crwprintlnk.cmd %~dp0\fpcupdeluxe.lnk ^| findstr /c:Arguments:') do set LazBuildCmd="%LazarusBinDir%\lazbuild.exe" %%i -B
set LazBuildCmd=%LazBuildCmd:Arguments:=%
set LazBuildCmd=%LazBuildCmd:  = %
set LazBuildCmd=%LazBuildCmd:  = %
set LazBuildCmd=%LazBuildCmd:  = %
set LazBuildCmd=%LazBuildCmd:  = %
echo LazBuildCmd=%LazBuildCmd%

:ActionOnEmptyArgs
if "%~1" == "" (
 call :Trouble 1 "%~n0 error: file name is empty."
 goto :Exit
)

:SetAndCheckSourceFiles
set SourceLpr=%~dpn1.lpr
set SourceLpi=%~dpn1.lpi
set TargetLog=%~dpn1_build.log
call :EnsureCreateLpiByLpr
call :CheckSourceFile "%~1"
call :CheckSourceFile "%SourceLpr%"
call :CheckSourceFile "%SourceLpi%"

:BuildProjectTargets
call :ExecuteBuild
exit /b %ErrorLevel%
goto :EOF

:CheckSourceFile
if not exist "%~1" call :Fatal 1 "Error: File not found - %~1"
goto :EOF

:EnsureCreateLpiByLpr
if not exist "%SourceLpr%" goto :EOF
if     exist "%SourceLpi%" goto :EOF
echo Create "%SourceLpi%" by "%SourceLpr%"
goto :EOF

:ExecuteBuild
del /f /q "%TargetLog%"
echo %date%-%time% - Build project: "%SourceLpr%" > "%TargetLog%"
echo %LazBuildCmd% %SourceLpr% | unix tee -a "%TargetLog%"
call %LazBuildCmd% %SourceLpr% | unix tee -a "%TargetLog%"
call :StripLinking
call :BackupCompilerLog
call :CheckLinesCompiled
goto :EOF

:StripLinking
for /f "tokens=1,2,* delims= " %%i in ('findstr /C:") Linking " "%TargetLog%"') do call :StripTheFile "%%~k"
goto :EOF

:StripTheFile
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
if /i "%~x1" == ".exe" goto :DoStripTheFile
if /i "%~x1" == ".dll" goto :DoStripTheFile
goto :EOF
:DoStripTheFile
for %%l in ( "%~f1" ) do set /a n1=%%~zl
unix strip -v "%~f1" | unix tee -a "%TargetLog%"
for %%l in ( "%~f1" ) do set /a n2=%%~zl
set /a "pc=100-100*n2/n1"
echo File stripped "%~f1" from %n1% to %n2% bytes - %pc% %% stripped. | unix tee -a "%TargetLog%"
goto :EOF

:CheckLinesCompiled
for /f "tokens=* delims=" %%i in ('findstr /C:"lines compiled" "%TargetLog%"') do (
 call :CompiledOk %%i
 goto :EOF
)
for %%i in ("%SourceLpr%") do call :Trouble 1 "Error compiling %%~nxi"
goto :EOF

:CompiledOk
shift /1
for %%i in ("%SourceLpr%") do unix tooltip-notifier text "%%~nxi: %1 %2 %3, %4 %5, %6 %7 %8." preset stdOk delay 60000
goto :EOF

:BackupCompilerLog
if not defined CRW_DAQ_VAR_TMP_DIR goto :EOF
type "%TargetLog%" >> "%CRW_DAQ_VAR_TMP_DIR%\%scriptbase%.log"
echo.>> "%CRW_DAQ_VAR_TMP_DIR%\%scriptbase%.log"
echo.>> "%CRW_DAQ_VAR_TMP_DIR%\%scriptbase%.log"
goto :EOF

:Fatal
call :Trouble %1 %2
exit %1
goto :EOF

:Trouble
call :NotifyCrwdaq "%~2"
unix tooltip-notifier text "%~2" preset stdError
1>&2 echo %~2
exit /b %1
goto :EOF

:NotifyCrwdaq
if not defined CRW_DAQ_SYS_EXE_PID goto :EOF
<nul set /p "_=@silent @echo %date: =0%-%time: =0% => %scriptname%: %~1" | cmd /c %scripthome%\shell\send2crwdaq.exe
goto :EOF

:Exit
exit /b %ErrorLevel%

::::::::::::::
:: END OF FILE
::::::::::::::
