#!/bin/bash

##########################################################
# Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# CRW-DAQ script to set capabilities requiring for crwdaq.
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly defcaps="cap_net_bind_service,cap_sys_nice+ep";
readonly homedir="$(realpath $scriptHOME/..)";
readonly exefile="$homedir/crwdaq";
declare  gcaps="";

function readinicaps(){
 local caps="";
 local gini="crwdaq.ini";
 local pini="resource/crwdaq.param.ini";
 if [[ -z $caps ]]; then caps="$(unix readini $pini '[System:Unix]' 'RequiredCapabilities')"; fi;
 if [[ -z $caps ]]; then caps="$(unix readcfg $gini '[System:Unix]' 'RequiredCapabilities')"; fi;
 if [[ -z $caps ]]; then caps="$defcaps"; fi;
 if [[ -z $caps ]]; then return 1; fi; 
 echo "$caps" | sed 's/.*=//';
 return 0;
};

function do_getcaps(){
 if unix sudoit getcap $exefile > /dev/null 2>&1; then
  gcaps="$(unix sudoit getcap $exefile | cut -d' ' -f2)";
  echo "getcap: $gcaps";
 else
  fatal 1 "Could not getcap: $exefile";
 fi;
};

function crwdaq_setcaps(){
 do_getcaps;
 local icaps="$(readinicaps)";
 if [[ -n $icaps ]]; then
  echo "inicap: $icaps";
 else
  fatal 1 "Could not read ini file";
 fi;
 if unix sudoit setcap -v $icaps $exefile; then
  echo "curcap: $gcaps";
  return 0;
 fi;
 if unix sudoit setcap $icaps $exefile; then
  echo "setcap: $icaps";
  do_getcaps;
 else
  fatal 1 "Could not setcap: $exefile";
 fi;
};

function main(){
 if pushd "$homedir" > /dev/null 2>&1; then
  crwdaq_setcaps "$@";
 fi;
 popd > /dev/null 2>&1; 
};

main "$@";

#############
# END OF FILE
#############
