@echo off
Title %~nx0 %*
SetLocal EnableExtensions EnableDelayedExpansion

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2020 Alexey Kuryakin kouriakine@mail.ru
:: Installer utility for the VisualTech DieselPascal.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: VisualTech DieselPascal home: http://www.visual-t.ru
:: Copyryight(c) 2020 Yuriy Kopnin - visualtech@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CheckAccessRights
call net session 1>nul 2>nul || ( call :ErrorFound "Error: Access denied to user (%UserName%)." & call :Sleep 5 & exit /b 1 )

:SetInstallFlag
set /a "InstallFlag=1"
for %%i in ( %* ) do if /i "%%i" == "--uninstall" set /a "InstallFlag=0"
if "%InstallFlag%" == "1" echo Detected Installer mode.

:SetUnInstallFlag
set /a "UnInstallFlag=0"
for %%i in ( %* ) do if /i "%%i" == "--uninstall" set /a "UnInstallFlag=1"
if "%UnInstallFlag%" == "1" echo Detected UnInstaller mode.

:SetSelfVariables
set "SelfCmd=%~nx0"
set "SelfDir=%~dp0"
set "SelfDir=%SelfDir:~0,-1%"
for %%i in ("%~dp0.") do set "SelfDir=%%~fi"
echo.
echo Started "%SelfCmd%" at "%SelfDir%".

:SetTargetVariables
set "ProductTm=VisualTech"
set "ProductId=DieselPascal"
set "VersionId=2.1.6 Build 16.06.2023"
set "ConfigDir=%UserProfile%\%ProductId%"
set "TempDir=%Temp%\%ProductTm%\%ProductId%"
set "TargetDir=%ProgramFiles%\%ProductTm%\%ProductId%"
set "DesignDir=%ProgramFiles%\%ProductTm%\%ProductId%Design"
set "TargetExeDir=%TargetDir%\exewindows"
set "DManagerExe=%TargetExeDir%\DManager.exe"
set "CrossMachineExe=%TargetExeDir%\CrossMachine.exe"
set "CrossDesignerExe=%TargetExeDir%\CrossDesigner.exe"
set "UninstallRegPath=HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
echo.
echo Target Name: %ProductTm% %ProductId% %VersionId%
echo Target Site: %TargetDir%
echo Temp Folder: %TempDir%
echo.

:CheckSourceFileList
echo.
echo Check Source File List:
echo.
set "SourceFileList=%SelfCmd% Un%SelfCmd% getfilesize.cmd handleopenwithmenu.cmd 7za.exe %ProductId%.7z license.txt"
if "%InstallFlag%" == "1" for %%i in ( %SourceFileList% ) do (
 if exist "%SelfDir%\%%i" ( echo Found: %%i ) else ( call :ErrorFound "Error: Missed %%i" & call :Sleep 5 & exit /b 1 )
)

:KillProcesses
echo.
echo Terminate %ProductId% processes:
echo.
for %%i in ( DManager.exe CrossMachine.exe CrossDesigner.exe ) do (
 for /f "tokens=1" %%j in ('tasklist /nh /fi "imagename eq %%i"') do if /i "%%j" == "%%i" call taskkill    /im %%i
 for /f "tokens=1" %%j in ('tasklist /nh /fi "imagename eq %%i"') do if /i "%%j" == "%%i" call taskkill /f /im %%i
)

:UninstallSelfFromTempDir
if "%UnInstallFlag%" == "1" (
 if /i "%SelfDir%" == "%TempDir%" (
  call :Sleep 3
 ) else (
  echo.
  echo Starting %SelfCmd% from "%TempDir%"
  if not exist "%TempDir%" mkdir "%TempDir%"
  for %%i in ( %SourceFileList% ) do copy /v /y "%SelfDir%\%%i" "%TempDir%\"
  pushd "%TempDir%" && start /min "Uninstall %ProductId%..." "%ComSpec%" /c "%SelfCmd%" %*
  popd
  exit 0
 )
)

:AppendSelfPath
set "PATH=%SelfDir%;%PATH%"

:SetSourceZip
set "SourceZip=%SelfDir%\%ProductId%.7z"
set "DesignZip=%SelfDir%\%ProductId%Design.7z"
set "ConfigZip=%SelfDir%\%ProductId%Config.7z"

:CheckSourceZip
if "%InstallFlag%" == "1" if not exist "%SourceZip%" ( call :ErrorFound "Error: Source file is not found: %SourceZip%." & call :Sleep 5 & exit /b 1 )

:Check7za
if "%InstallFlag%" == "1" call 7za 1>nul 2>nul || ( call :ErrorFound "Error: 7za archiver is not found in PATH." & call :Sleep 5 & exit /b 1 )

:RemoveTargetDirOld
call :RemoveDir "%TargetDir%.OLD"
if exist "%TargetDir%.OLD" ( call :ErrorFound "Error: Failed delete: %TargetDir%.OLD." & call :Sleep 5 & exit /b 1 )

:RemoveTargetDir
if exist "%TargetDir%" rename "%TargetDir%" "%ProductId%.OLD" || ( call :ErrorFound "Error: Failed rename: %TargetDir%." & call :Sleep 5 & exit /b 1 )
call :RemoveDir "%TargetDir%.OLD"
if exist "%TargetDir%.OLD" ( call :ErrorFound "Error: Failed delete: %TargetDir%.OLD." & call :Sleep 5 & exit /b 1 )
call :RemoveDir "%TargetDir%"
if exist "%TargetDir%" ( call :ErrorFound "Error: Failed delete: %TargetDir%." & call :Sleep 5 & exit /b 1 )

:RemoveDesignDir
if exist "%DesignZip%"     call :RemoveDir "%DesignDir%"
if "%UnInstallFlag%" == "1" call :RemoveDir "%DesignDir%"

:CreateTargetDir
if "%InstallFlag%" == "1" if not exist "%TargetDir%" mkdir "%TargetDir%" || ( call :ErrorFound "Error: Failed mkdir: %TargetDir%." & call :Sleep 5 & exit /b 1 )

:UnpackTarget
if "%InstallFlag%" == "1" if exist "%TargetDir%" if exist "%SourceZip%" (
 echo.
 echo Unpack Files to "%TargetDir%":
 echo.
 pushd "%TargetDir%" && call 7za x -y "%SourceZip%"
 popd
 for %%i in ( %SourceFileList% ) do copy /v /y "%SelfDir%\%%i" "%TargetDir%\"
)

:CreateConfigDir
if "%InstallFlag%" == "1" if not exist "%ConfigDir%" mkdir "%ConfigDir%"

:UnpackConfig
if "%InstallFlag%" == "1" if exist "%ConfigDir%" if exist "%ConfigZip%" (
 echo.
 echo Unpack Files to "%ConfigDir%":
 echo.
 pushd "%ConfigDir%" && call 7za x -y "%ConfigZip%"
 popd
 copy /v /y "%ConfigZip%" "%ConfigDir%\"
)

:CreateDesignDir
if "%InstallFlag%" == "1" if not exist "%DesignDir%" if exist "%DesignZip%" mkdir "%DesignDir%"

:UnpackDesign
if "%InstallFlag%" == "1" if exist "%DesignDir%" if exist "%DesignZip%" (
 echo.
 echo Unpack Files to "%DesignDir%":
 echo.
 pushd "%DesignDir%" && call 7za x -y "%DesignZip%"
 popd
 copy /v /y "%DesignZip%" "%DesignDir%\"
)

:SetOpenWithCrossMachine
echo.
echo Set OpenWith menu for CrossMachine:
echo.
call :SetOpenWithLm9 "%ProductTm%.%ProductId%.CrossMachine" "%CrossMachineExe%" "%ProductTm% %ProductId% CrossMachine"

:SetOpenWithCrossDesigner
echo.
echo Set OpenWith menu for CrossDesigner:
echo.
call :SetOpenWithLm9 "%ProductTm%.%ProductId%.CrossDesigner" "%CrossDesignerExe%" "%ProductTm% %ProductId% CrossDesigner"

:RegisterUnInslaller
echo.
echo Set Uninstall Registry:
echo.
reg delete "%UninstallRegPath%\%ProductTm%_%ProductId%" /f
if "%InstallFlag%" == "1" if exist "%CrossDesignerExe%" (
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "Comments"        /t REG_SZ    /d "%ProductId% by %ProductTm% - advanced Pascal interpreter with IDE for business." /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "Contact"         /t REG_SZ    /d "mailto:visualtech@mail.ru" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "DisplayIcon"     /t REG_SZ    /d "%CrossMachineExe%" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "DisplayName"     /t REG_SZ    /d "%ProductTm% %ProductId%" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "DisplayVersion"  /t REG_SZ    /d "%VersionId%" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "Publisher"       /t REG_SZ    /d "%ProductTm%" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "URLInfoAbout"    /t REG_SZ    /d "http://www.visual-t.ru/" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "URLUpdateInfo"   /t REG_SZ    /d "http://www.visual-t.ru/" /f
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "UninstallString" /t REG_SZ    /d "%TargetDir%\Un%SelfCmd%" /f
 set /a "ProductSize=0"
 for /f "tokens=1" %%i in ('cmd /c getfilesize "%TargetDir%\*" kb') do set /a "ProductSize=%%i"
 reg add "%UninstallRegPath%\%ProductTm%_%ProductId%" /v "EstimatedSize"   /t REG_DWORD /d "!ProductSize!" /f
)

:SetFTypeAssoc
echo.
echo Set file type associations:
echo.
assoc .lm9=
ftype %ProductTm%.%ProductId%.DManager=
ftype %ProductTm%.%ProductId%.CrossMachine=
ftype %ProductTm%.%ProductId%.CrossDesigner=
if "%InstallFlag%" == "1" if exist "%CrossMachineExe%" (
 ftype %ProductTm%.%ProductId%.CrossDesigner="%CrossDesignerExe%" "%%1" %%*
 ftype %ProductTm%.%ProductId%.CrossMachine="%CrossMachineExe%" "%%1" %%*
 ftype %ProductTm%.%ProductId%.DManager="%DManagerExe%" "%%1" %%*
 assoc .lm9=%ProductTm%.%ProductId%.CrossMachine
)

:UpdateFbClientDll
echo.
echo Update FBCLIENT.DLL:
echo.
if "%InstallFlag%" == "1" if exist "%CrossMachineExe%" (
 call :UpdateDefaultFbClientDll
 call :UpdateSystemFbClientDll
)

:CheckUninstall
if "%UnInstallFlag%" == "1" if not exist "%TargetDir%" (
 echo.
 call :Print "UnInstallation Success"
 call :Sleep 5 . .
 echo.
 exit /b 0
) else (
 echo.
 call :Print "UnInstallation Failure"
 call :Sleep 5 . .
 echo.
 exit /b 1
)

:CheckTargetExe
if "%InstallFlag%" == "1" if exist "%CrossMachineExe%" (
 echo.
 call :Print "Installation Success"
 call :Sleep 5 . .
 echo.
 exit /b 0
) else (
 echo.
 call :Print "Installation Failure"
 call :Sleep 5 . .
 echo.
 exit /b 1
)
goto :EOF

:SetOpenWithLm9
if "%~1" == "" goto :EOF
call cmd /c HandleOpenWithMenu --uninstall %1
if "%~2" == "" goto :EOF
if "%~3" == "" goto :EOF
if not exist "%~2" goto :EOF
if "%InstallFlag%" == "1" call cmd /c HandleOpenWithMenu --install %1 --command %2 --prompt %3 --extlist ".lm9"
goto :EOF

:UpdateSystemFbClientDll
for /f "tokens=* delims=" %%i in ('getspecialfolderpath system') do set "SysFbClientDll=%%~fi\fbclient.dll"
if defined SysFbClientDll if exist "%SysFbClientDll%" xcopy /V /C /I /R /D /Y "%SysFbClientDll%" "%TargetExeDir%\"
goto :EOF

:UpdateDefaultFbClientDll
call :ReadFirebirdDefaultInstance FirebirdDir
if defined FirebirdDir if exist "%FirebirdDir%\fbclient.dll" xcopy /V /C /I /R /D /Y "%FirebirdDir%\fbclient.dll" "%TargetExeDir%\"
goto :EOF

:ReadFirebirdDefaultInstance
if "%~1" == "" goto :EOF & set "%~1="
for /f "tokens=1,2*" %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Firebird Project\Firebird Server\Instances" /v "DefaultInstance" /t REG_SZ') do if /i "%%~i" == "DefaultInstance" if /i "%%~j" == "REG_SZ" set "%~1=%%~k"
for %%i in ("!%~1!\.") do set "%~1=%%~fi"
if not exist "!%~1!" set "%~1="
goto :EOF

:RemoveDir
if "%~1" == "" goto :EOF
if not exist "%~1\" goto :EOF
pushd "%Temp%" && rmdir /S /Q "%~1"
popd
goto :EOF

:ErrorFound
call :PrintToStdErr %*
call :SetErrorLevel 1 
goto :EOF

:PrintToStdErr
if not "%~1" == "" echo %~1 1>&2
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :Print %2
if not "%~3" == "" ( for /L %%i in (1,1,%1) do ( call :Sleep 1 & call :Print %~3 ) ) else ( call ping -n %PingCount% 127.0.0.1 1>nul 2>nul  )
EndLocal
goto :EOF

:Print
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p "_=%~1"
EndLocal
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
