@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

:SetHomeDir
set HomeDir=%~dp0
rem set HomeDir=%HomeDir:~0,-1%
for %%i in ("%HomeDir%") do set HomeDir=%%~fi

:SetProductInstaller
:DetectWindowsVersion
rem see https://en.wikipedia.org/wiki/Ver_(command)
for /f "delims=" %%i in ('ver ^| findstr /C:" 5."')  do goto :DetectedWindowsXp
for /f "delims=" %%i in ('ver ^| findstr /C:" 6.0"') do goto :DetectedWindowsVista
for /f "delims=" %%i in ('ver ^| findstr /C:" 6.1"') do goto :DetectedWindows7
for /f "delims=" %%i in ('ver ^| findstr /C:" 6.2"') do goto :DetectedWindows8
for /f "delims=" %%i in ('ver ^| findstr /C:" 6.3"') do goto :DetectedWindows8
for /f "delims=" %%i in ('ver ^| findstr /C:" 6."')  do goto :DetectedWindows10
for /f "delims=" %%i in ('ver ^| findstr /C:" 10."') do goto :DetectedWindows10
goto :DetectedWindowsOther

:DetectedWindowsOther
echo Skipped for this version of OS.
call :Sleep 5 Wait . & echo.
call :SetErrorLevel 0
goto :EOF

:DetectedWindowsXp
set Installer=com0com_setup_unsigned.exe
if defined ProgramFiles set Installer=com0com_setup_x86_signed.exe
if defined ProgramW6432 set Installer=com0com_setup_x64_signed.exe
set Arguments=/S
set ProductId=Null-modem emulator (com0com)
set DisplayId=com0com
goto :PrintGreetings

:DetectedWindowsVista
:DetectedWindows7
:DetectedWindows8
:DetectedWindows10
set Installer=com0com_setup_unsigned.exe
if defined ProgramFiles set Installer=com0com_setup_x86_signed.exe
if defined ProgramW6432 set Installer=com0com_setup_x64_signed.exe
set Arguments=/S
set ProductId=Null-modem emulator (com0com)
set DisplayId=com0com
goto :PrintGreetings

:PrintGreetings
echo "%ProductId%" installer.
echo.

:CheckIsInstallerExists
if not exist "%HomeDir%\%Installer%" (
 echo Failed: %Installer% not found.
 call :Sleep 5 Wait . & echo.
 call :SetErrorLevel 1
 goto :EOF
)

:CheckIsAlreadyInstalled
call :ReadProductId Product "%DisplayId%"
if "!Product!" == "%ProductId%" (
 echo "%ProductId%" is already installed.
 call :Sleep 5 Wait . & echo.
 call :SetErrorLevel 0
 goto :EOF
)

:StartInstaller
echo Start installer "%ProductId%"
echo Start directory "%HomeDir%"
pushd "%HomeDir%" || goto :CouldNotInstall
call :RunPredInstall
call :RunInstaller "%Installer%" %Arguments%
call :RunPostInstall
call :CheckProductId
popd
goto :EOF

:RunInstaller
if /i "%~x1" == ".msi" goto :RunInstallerMsi
goto :RunInstallerExe

:RunInstallerExe
call :Execute %*
goto :EOF

:RunInstallerMsi
call :Execute msiexec.exe /i %*
goto :EOF

:RunPredInstall
set "CNC_INSTALL_START_MENU_SHORTCUTS=YES"      & rem YES/NO - select/unselect "Start Menu Shortcuts"
set "CNC_INSTALL_CNCA0_CNCB0_PORTS=YES"         & rem YES/NO - select/unselect "CNCA0 --- CNCB0"
set "CNC_INSTALL_COMX_COMX_PORTS=YES"           & rem YES/NO - select/unselect "COM#  --- COM#"
set "CNC_INSTALL_SKIP_SETUP_PREINSTALL=NO"      & rem YES/NO - skip preinstalling/updating driver
goto :EOF

:RunPostInstall
goto :EOF

:CouldNotInstall
echo Fail call pushd "%HomeDir%"
echo Could not install "%ProductId%"
call :SetErrorLevel 1
goto :EOF

:CheckProductId
call :ReadProductId Product "%DisplayId%"
if "!Product!" == "%ProductId%" (
 echo *****************************
 echo Installation Result: SUCCESS.
 echo *****************************
 call :SetErrorLevel 0
) else (
 echo ****************************
 echo Installation Result: FAILED.
 echo ****************************
 call :SetErrorLevel 1
)
goto :EOF

:ReadProductId
rem Usage = call :ReadProductId Product DisplayName
rem Product is variable name for Product Identifier
rem DisplayName is HKLM\..\Uninstall\DisplayName Id
if "%~1" == "" goto :EOF
set %~1=ProductNotFound.
if "%~2" == "" goto :EOF
if defined ProgramFiles call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:64
goto :EOF

:RegQueryString
rem Usage = call :RegQuery Variable Key Name Option
for /F "tokens=1,2*" %%x in ('reg query "%~2" /v "%~3" %~4 2^> nul') do if /I "%%x" == "%~3" if /I "%%y" == "REG_SZ" set %~1=%%z
goto :EOF

:Sleep
rem Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
SetLocal EnableExtensions EnableDelayedExpansion
if not "%~2" == "" call :ShowSleepProgress %~2
if not "%~3" == "" (for /L %%i in (1,1,%1) do (call :SleepSilent 1 & call :ShowSleepProgress %~3)) else (call :SleepSilent %1)
EndLocal
goto :EOF

:SleepSilent
rem Usage = call :SleepSilent NumSeconds
SetLocal EnableExtensions EnableDelayedExpansion
set /a NumSeconds=%1+1
ping -n %NumSeconds% 127.0.0.1 > nul 2>&1
EndLocal
goto :EOF

:ShowSleepProgress
rem Usage = call :ShowSleepProgress Message
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p Dummy=%*
EndLocal
goto :EOF

:DeleteFiles
rem Usage = call :DeleteFiles file1 file2 ...
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF

:IfProcessNameExistDo
rem Usage = call :IfProcessNameExistDo name.exe command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "imagename eq %~1"') do if /i "%%i" == "%~1" ( %2 %3 %4 %5 %6 %7 %8 %9 & goto :EOF )
goto :EOF

:IfProcessTitleExistDo
rem Usage = call :IfProcessTitleExistDo "window title" command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "windowtitle eq %~1"') do if /i "%%i" == "%~1" ( %2 %3 %4 %5 %6 %7 %8 %9  & goto :EOF )
goto :EOF

:IfProcessNameTitleExistDo
rem Usage = call :IfProcessNameTitleExistDo name.exe "window title" command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "imagename eq %~1" /fi "windowtitle eq %~2"') do if /i "%%i" == "%~1" ( %3 %4 %5 %6 %7 %8 %9 & goto :EOF )
goto :EOF

:IfExistExecute
rem Usage = call :IfExistExecute filename args
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
call :Execute %*
goto :EOF

:Execute
rem Usage = call :Execute command
if "%~1" == "" goto :EOF
echo %*
call %*
goto :EOF

:SetErrorLevel
rem Usage = call :SetErrorLevel exitcode
exit /b %1
goto :EOF
